/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.meta.model;

import cn.chenzw.excel.magic.core.util.ExcelXmlCodecUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;

public class ExcelCellDefinition {
    private Integer sheetIndex;
    private Integer rowIndex;
    private Integer colIndex;
    private String colTitle;
    private String cellValue;
    private ExcelCellType cellType;

    public Integer getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(Integer sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Integer getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(Integer colIndex) {
        this.colIndex = colIndex;
    }

    public String getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(String colTitle) {
        this.colTitle = colTitle;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public ExcelCellType getCellType() {
        return this.cellType;
    }

    public void setCellType(ExcelCellType cellType) {
        this.cellType = cellType;
    }

    public String toString() {
        return "ExcelCell{sheetIndex=" + this.sheetIndex + ", rowIndex=" + this.rowIndex + ", colIndex=" + this.colIndex + ", colTitle='" + this.colTitle + '\'' + ", cellValue='" + this.cellValue + '\'' + ", cellType='" + this.cellType + '\'' + '}';
    }

    public static class ExcelNullCellType
    implements ExcelCellType {
        @Override
        public boolean matches(String name, Attributes attributes) {
            return true;
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelErrorCellType
    implements ExcelCellType {
        @Override
        public boolean matches(String name, Attributes attributes) {
            return "c".equals(name) && "e".equals(attributes.getValue("t"));
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelBooleanCellType
    implements ExcelCellType {
        @Override
        public boolean matches(String name, Attributes attributes) {
            return "c".equals(name) && "b".equals(attributes.getValue("t"));
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelInlinStrCellType
    implements ExcelCellType {
        @Override
        public boolean matches(String name, Attributes attributes) {
            return "c".equals(name) && "inlineStr".equals(attributes.getValue("t"));
        }

        @Override
        public String getValue(String value) {
            XSSFRichTextString rtsi = new XSSFRichTextString(value);
            return rtsi.toString();
        }
    }

    public static class ExcelNumbericCellType
    implements ExcelCellType {
        private StylesTable stylesTable;

        public ExcelNumbericCellType(StylesTable stylesTable) {
            this.stylesTable = stylesTable;
        }

        @Override
        public boolean matches(String name, Attributes attributes) {
            String dataFormat;
            return "c".equals(name) && !StringUtils.isBlank((CharSequence)attributes.getValue("s")) && StringUtils.containsAny((CharSequence)(dataFormat = ExcelXmlCodecUtils.getDataFormat(Integer.parseInt(attributes.getValue("s")), this.stylesTable)), (CharSequence[])new CharSequence[]{"#", "0", "General"});
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelDateCellType
    implements ExcelCellType {
        private StylesTable stylesTable;

        public ExcelDateCellType(StylesTable stylesTable) {
            this.stylesTable = stylesTable;
        }

        @Override
        public boolean matches(String name, Attributes attributes) {
            if ("c".equals(name) && !StringUtils.isBlank((CharSequence)attributes.getValue("s"))) {
                int styleIndex = Integer.parseInt(attributes.getValue("s"));
                XSSFCellStyle cellStyle = this.stylesTable.getStyleAt(styleIndex);
                short dataFormatIndex = cellStyle.getDataFormat();
                String dataFormatString = cellStyle.getDataFormatString();
                if (StringUtils.containsAny((CharSequence)dataFormatString, (CharSequence[])new CharSequence[]{"y", "m", "d", "h", "s"})) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            Date date = HSSFDateUtil.getJavaDate((double)Double.parseDouble(value));
            return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
    }

    public static class ExcelStringCellType
    implements ExcelCellType {
        private SharedStringsTable sst;

        public ExcelStringCellType(SharedStringsTable sst) {
            this.sst = sst;
        }

        @Override
        public boolean matches(String name, Attributes attributes) {
            return "c".equals(name) && "s".equals(attributes.getValue("t"));
        }

        @Override
        public String getValue(String value) {
            int idx = Integer.parseInt(value);
            return new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
        }
    }

    public static interface ExcelCellType {
        public boolean matches(String var1, Attributes var2);

        public String getValue(String var1);
    }
}

