/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.executor;

import cn.chenzw.excel.magic.core.context.ExcelWriterContext;
import cn.chenzw.excel.magic.core.exception.ExcelWriterException;
import cn.chenzw.excel.magic.core.executor.AbstractExcelWriterExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriterExecutor
extends AbstractExcelWriterExecutor {
    private Logger logger = LoggerFactory.getLogger(ExcelWriterExecutor.class);

    public ExcelWriterExecutor(ExcelWriterContext writerContext) {
        super(writerContext);
    }

    @Override
    public void beforeCallback() {
        super.beforeCallback();
    }

    @Override
    public void sheetPaging() {
        this.logger.debug("start sheet paging!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            super.sheetPaging();
        }
        catch (Throwable e) {
            throw new ExcelWriterException(this.curSheetIndex, this.curRowIndex, this.curColIndex, "", "Sheet\u5206\u9875\u5931\u8d25", e);
        }
        finally {
            this.logger.debug("finish sheet paging! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void handleComplexHeader() {
        this.logger.debug("start handle complex header!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            super.handleComplexHeader();
        }
        catch (Throwable e) {
            throw new ExcelWriterException(this.curSheetIndex, this.curRowIndex, this.curColIndex, "", "\u590d\u6742\u8868\u5934\u751f\u6210\u5931\u8d25!", e);
        }
        finally {
            this.logger.debug("finish handle complex header! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void addDataValidation() {
        this.logger.debug("start add data validation!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            super.addDataValidation();
        }
        catch (Throwable e) {
            throw new ExcelWriterException(this.curSheetIndex, this.curRowIndex, this.curColIndex, "", "\u6dfb\u52a0\u5355\u5143\u683c\u6821\u9a8c\u5668\u5931\u8d25", e);
        }
        finally {
            this.logger.debug("finish add data validation! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void initHeadTitle() {
        this.logger.info("start write head title!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            super.initHeadTitle();
        }
        catch (Throwable e) {
            throw new ExcelWriterException(this.curSheetIndex, this.curRowIndex, this.curColIndex, "", "\u521d\u59cb\u5316\u6807\u9898\u5931\u8d25", e);
        }
        finally {
            this.logger.debug("finish write head title! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void initData() {
        this.logger.debug("start write data!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            super.initData();
        }
        catch (Throwable e) {
            throw new ExcelWriterException(this.curSheetIndex, this.curRowIndex, this.curColIndex, "", "\u5199\u5165\u6570\u636e\u5931\u8d25", e);
        }
        finally {
            this.logger.debug("finish write data! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void afterCallback() {
        super.afterCallback();
    }
}

