/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.executor;

import cn.chenzw.excel.magic.core.context.ExcelWriterContext;
import cn.chenzw.excel.magic.core.exception.ExcelException;
import cn.chenzw.excel.magic.core.exception.ExcelWriterException;
import cn.chenzw.excel.magic.core.executor.ExcelExecutor;
import cn.chenzw.excel.magic.core.lifecycle.ExcelWriterLifecycle;
import cn.chenzw.excel.magic.core.meta.annotation.CellRange;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelComplexHeader;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelDataFormat;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelExportColumn;
import cn.chenzw.excel.magic.core.meta.annotation.datavalidation.ExcelDataValidation;
import cn.chenzw.excel.magic.core.meta.model.ExcelSheetDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelWriterSheetDefinition;
import cn.chenzw.excel.magic.core.meta.style.CellStyleBuilder;
import cn.chenzw.excel.magic.core.support.dataconstraint.ExcelDataValidationConstraint;
import cn.chenzw.excel.magic.core.util.ExcelFieldUtils;
import cn.chenzw.excel.magic.core.util.ListUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelWriterExecutor
implements ExcelExecutor,
ExcelWriterLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExcelWriterExecutor.class);
    protected int curSheetIndex;
    protected int curRowIndex;
    protected int curColIndex;
    private ExcelWriterContext writerContext;
    private CellStyleCache cellStyleCache;
    private SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(new XSSFWorkbook(), 1000);
    private Map<Integer, ExcelSheetDefinition> sheetDefinitions;

    public AbstractExcelWriterExecutor(ExcelWriterContext writerContext) {
        this.sxssfWorkbook.setCompressTempFiles(true);
        this.writerContext = writerContext;
        this.cellStyleCache = new CellStyleCache();
    }

    @Override
    public void beforeCallback() {
    }

    @Override
    public void sheetPaging() {
        ArrayList sheetSegments = new ArrayList();
        for (Map.Entry<Integer, ExcelSheetDefinition> sheetDefinitionEntry : this.sheetDefinitions.entrySet()) {
            ExcelWriterSheetDefinition sheetDefinition = (ExcelWriterSheetDefinition)sheetDefinitionEntry.getValue();
            this.curSheetIndex = sheetDefinitionEntry.getKey();
            List<List<?>> segments = ListUtils.split(sheetDefinition.getRowDatas(), sheetDefinition.getMaxRowsPerSheet());
            if (segments.size() <= 1) continue;
            sheetSegments.addAll(segments);
            this.writerContext.removeSheet(sheetDefinitionEntry.getKey());
        }
        this.writerContext.addData(sheetSegments);
    }

    @Override
    public void handleComplexHeader() {
        for (Map.Entry<Integer, ExcelSheetDefinition> sheetDefinitionEntry : this.sheetDefinitions.entrySet()) {
            CellRange[] cellRanges;
            this.curSheetIndex = sheetDefinitionEntry.getKey();
            ExcelWriterSheetDefinition sheetDefinition = (ExcelWriterSheetDefinition)sheetDefinitionEntry.getValue();
            Sheet sheet = this.createSheet(sheetDefinitionEntry.getKey(), sheetDefinition.getSheetName());
            ExcelComplexHeader ExcelComplexHeader2 = sheetDefinition.getAnnotation(ExcelComplexHeader.class);
            if (ExcelComplexHeader2 == null) continue;
            for (CellRange cellRange : cellRanges = ExcelComplexHeader2.value()) {
                this.curRowIndex = cellRange.firstRow();
                this.curColIndex = cellRange.firstCol();
                int firstRow = cellRange.firstRow() - 1;
                int fristCol = cellRange.firstCol() - 1;
                int lastRow = cellRange.lastRow() - 1;
                int lastCol = cellRange.lastCol() - 1;
                Row row = sheet.getRow(firstRow);
                if (row == null) {
                    row = sheet.createRow(firstRow);
                }
                row.setHeightInPoints((float)cellRange.height());
                Cell cell = row.createCell(fristCol);
                cell.setCellValue(cellRange.title());
                CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, fristCol, lastCol);
                sheet.addMergedRegion(cellRangeAddress);
                CellStyleBuilder cellStyleBuilder = this.cellStyleCache.getCellStyleInstance(cellRange.cellStyleBuilder());
                cell.setCellStyle(cellStyleBuilder.build((Workbook)this.sxssfWorkbook, cell));
            }
        }
    }

    @Override
    public void addDataValidation() {
        for (Map.Entry<Integer, ExcelSheetDefinition> sheetDefinitionEntry : this.sheetDefinitions.entrySet()) {
            this.curSheetIndex = sheetDefinitionEntry.getKey();
            ExcelWriterSheetDefinition sheetDefinition = (ExcelWriterSheetDefinition)sheetDefinitionEntry.getValue();
            Sheet sheet = this.createSheet(sheetDefinitionEntry.getKey(), sheetDefinition.getSheetName());
            Map<Integer, Field> columnFields = sheetDefinition.getColumnFields();
            for (Map.Entry<Integer, Field> columnFieldEntry : columnFields.entrySet()) {
                Field field = columnFieldEntry.getValue();
                this.curColIndex = columnFieldEntry.getKey();
                int colIndex = this.curColIndex;
                if (colIndex < 1) {
                    throw new IllegalArgumentException(field.getName() + "' colIndex less than 1");
                }
                Object[] dataValidationConstraintList = this.getDataValidationConstraint(field);
                if (dataValidationConstraintList == null) continue;
                DataValidationHelper helper = sheet.getDataValidationHelper();
                DataValidationConstraint dataConstraint = helper.createExplicitListConstraint((String[])dataValidationConstraintList);
                dataConstraint.setExplicitListValues((String[])dataValidationConstraintList);
                CellRangeAddressList regions = new CellRangeAddressList(sheetDefinition.getFirstDataRow(), 999, colIndex - 1, colIndex - 1);
                DataValidation dataValidation = helper.createValidation(dataConstraint, regions);
                dataValidation.setSuppressDropDownArrow(true);
                dataValidation.createPromptBox("\u63d0\u793a", "\u53ef\u9009\u503c:" + Arrays.toString(dataValidationConstraintList));
                dataValidation.createErrorBox("\u9519\u8bef\u63d0\u793a", "\u60a8\u7684\u8f93\u5165\u6709\u8bef, \u53ef\u9009\u503c:" + Arrays.toString(dataValidationConstraintList));
                dataValidation.setShowPromptBox(true);
                dataValidation.setShowErrorBox(true);
                sheet.addValidationData(dataValidation);
            }
        }
    }

    @Override
    public void initHeadTitle() {
        for (Map.Entry<Integer, ExcelSheetDefinition> sheetDefinitionEntry : this.sheetDefinitions.entrySet()) {
            this.curSheetIndex = sheetDefinitionEntry.getKey();
            ExcelWriterSheetDefinition sheetDefinition = (ExcelWriterSheetDefinition)sheetDefinitionEntry.getValue();
            Sheet sheet = this.createSheet(sheetDefinitionEntry.getKey(), sheetDefinition.getSheetName());
            Row row = sheet.createRow(sheetDefinition.getFirstDataRow() - 1);
            row.setHeightInPoints((float)sheetDefinition.getTitleRowHeight());
            this.curRowIndex = row.getRowNum() + 1;
            Map<Integer, Field> columnFields = sheetDefinition.getColumnFields();
            for (Map.Entry<Integer, Field> columnFieldEntry : columnFields.entrySet()) {
                Field field = columnFieldEntry.getValue();
                this.curColIndex = columnFieldEntry.getKey();
                int colIndex = this.curColIndex;
                if (colIndex < 1) {
                    throw new IllegalArgumentException(field.getName() + "' colIndex less than 1");
                }
                ExcelExportColumn exportColumn = field.getAnnotation(ExcelExportColumn.class);
                Cell cell = row.createCell(colIndex - 1);
                cell.setCellValue(exportColumn.title());
                cell.setCellType(CellType.STRING);
                CellStyleBuilder cellStyleBuilder = this.cellStyleCache.getCellStyleInstance(exportColumn.titleCellStyleBuilder());
                CellStyle cellStyle = cellStyleBuilder.build((Workbook)this.sxssfWorkbook, cell);
                cell.setCellStyle(cellStyle);
                if (exportColumn.autoWidth()) continue;
                sheet.setColumnWidth(colIndex - 1, exportColumn.colWidth() * 256);
            }
        }
    }

    @Override
    public void initData() {
        for (Map.Entry<Integer, ExcelSheetDefinition> sheetDefinitionEntry : this.sheetDefinitions.entrySet()) {
            this.curSheetIndex = sheetDefinitionEntry.getKey();
            ExcelWriterSheetDefinition sheetDefinition = (ExcelWriterSheetDefinition)sheetDefinitionEntry.getValue();
            Sheet sheet = this.createSheet(sheetDefinitionEntry.getKey(), sheetDefinition.getSheetName());
            Map<Integer, Field> columnFields = sheetDefinition.getColumnFields();
            List<?> rowDatas = sheetDefinition.getRowDatas();
            for (int rowIndex = 0; rowIndex < rowDatas.size(); ++rowIndex) {
                Row row = sheet.createRow(rowIndex + sheetDefinition.getFirstDataRow());
                row.setHeightInPoints((float)sheetDefinition.getDataRowHeight());
                this.curRowIndex = row.getRowNum() + 1;
                Object rowData = rowDatas.get(rowIndex);
                for (Map.Entry<Integer, Field> columnFieldEntry : columnFields.entrySet()) {
                    this.curColIndex = columnFieldEntry.getKey();
                    Field field = columnFieldEntry.getValue();
                    Cell cell = row.createCell(columnFieldEntry.getKey() - 1);
                    ExcelExportColumn exportColumn = field.getAnnotation(ExcelExportColumn.class);
                    cell.setCellType(exportColumn.cellType());
                    CellStyleBuilder cellStyleBuilder = this.cellStyleCache.getCellStyleInstance(exportColumn.dataCellStyleBuilder());
                    CellStyle cellStyle = cellStyleBuilder.build((Workbook)this.sxssfWorkbook, cell);
                    ExcelDataFormat excelDataFormat = exportColumn.dataFormat();
                    if (!StringUtils.isBlank((CharSequence)excelDataFormat.value())) {
                        DataFormat dataFormat = this.sxssfWorkbook.createDataFormat();
                        cellStyle.setDataFormat(dataFormat.getFormat(excelDataFormat.value()));
                    }
                    if (sheetDefinition.isRowStriped() && rowIndex % 2 == 0) {
                        ((XSSFCellStyle)cellStyle).setFillForegroundColor(new XSSFColor(sheetDefinition.getRowStripeColor()));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    cell.setCellStyle(cellStyle);
                    try {
                        ExcelFieldUtils.setCellValue(cell, rowData, field);
                    }
                    catch (IllegalAccessException e) {
                        throw new ExcelWriterException("", e);
                    }
                }
            }
            if (!(sheet instanceof SXSSFSheet)) continue;
            SXSSFSheet sxssfSheet = (SXSSFSheet)sheet;
            sxssfSheet.trackAllColumnsForAutoSizing();
            for (Map.Entry<Integer, Field> columnFieldEntry : columnFields.entrySet()) {
                Field field = columnFieldEntry.getValue();
                ExcelExportColumn exportColumn = field.getAnnotation(ExcelExportColumn.class);
                if (!exportColumn.autoWidth()) continue;
                sxssfSheet.autoSizeColumn(columnFieldEntry.getKey().intValue());
            }
        }
    }

    @Override
    public void afterCallback() {
    }

    @Override
    public <T> List<T> executeRead() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c!");
    }

    @Override
    public Workbook executeWrite() {
        logger.debug("start write!");
        long startTimeMillis = System.currentTimeMillis();
        this.sheetDefinitions = this.writerContext.getSheetDefinitions();
        this.sheetPaging();
        this.handleComplexHeader();
        this.addDataValidation();
        this.initHeadTitle();
        this.initData();
        logger.debug("finish write![total cost {}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        return this.sxssfWorkbook;
    }

    private String[] getDataValidationConstraint(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getAnnotations()) {
            Class<? extends Annotation> aClass = annotation.annotationType();
            if (!aClass.isAnnotationPresent(ExcelDataValidation.class)) continue;
            ExcelDataValidation dataValidation = aClass.getAnnotation(ExcelDataValidation.class);
            ExcelDataValidationConstraint dataValidationConstraint = null;
            try {
                dataValidationConstraint = dataValidation.dataConstraint().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelException("\u5b9e\u4f8b\u5316\u4e0b\u62c9\u503c\u7ea6\u675f[" + dataValidation.dataConstraint() + "]\u65f6\u5931\u8d25!", e);
            }
            dataValidationConstraint.initialize(annotation);
            return dataValidationConstraint.generate();
        }
        return null;
    }

    private Sheet createSheet(int sheetIndex, String sheetName) {
        SXSSFSheet sheet = null;
        sheet = sheetIndex >= this.sxssfWorkbook.getNumberOfSheets() ? this.sxssfWorkbook.createSheet(sheetName) : this.sxssfWorkbook.getSheetAt(sheetIndex);
        return sheet;
    }

    private static class CellStyleCache {
        private Map<Class<?>, CellStyleBuilder> cellStyleCacheMap = new HashMap();

        public void addCache(Class<?> clazz, CellStyleBuilder cellStyleBuilder) {
            this.cellStyleCacheMap.put(clazz, cellStyleBuilder);
        }

        public CellStyleBuilder getCellStyleInstance(Class<?> clazz) {
            CellStyleBuilder cellStyleBuilder = this.getCache(clazz);
            if (cellStyleBuilder == null) {
                try {
                    if (CellStyleBuilder.class.isAssignableFrom(clazz)) {
                        cellStyleBuilder = (CellStyleBuilder)clazz.newInstance();
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                this.addCache(clazz, cellStyleBuilder);
            }
            return cellStyleBuilder;
        }

        public CellStyleBuilder getCache(Class<?> clazz) {
            return this.cellStyleCacheMap.get(clazz);
        }

        public void removeCache(Class<?> clazz) {
            this.cellStyleCacheMap.remove(clazz);
        }
    }
}

