/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.executor;

import cn.chenzw.excel.magic.core.analysis.XlsxAnalysisHandler;
import cn.chenzw.excel.magic.core.context.ExcelReaderContext;
import cn.chenzw.excel.magic.core.exception.ExcelException;
import cn.chenzw.excel.magic.core.executor.ExcelExecutor;
import cn.chenzw.excel.magic.core.executor.ExcelReaderExecutor;
import cn.chenzw.excel.magic.core.lifecycle.ExcelReaderLifecycle;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelImportColumn;
import cn.chenzw.excel.magic.core.meta.annotation.converter.ExcelConverter;
import cn.chenzw.excel.magic.core.meta.annotation.validation.ConstraintValidator;
import cn.chenzw.excel.magic.core.meta.model.ExcelCellDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelRowDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelSheetDefinition;
import cn.chenzw.excel.magic.core.processor.ExcelPerRowProcessor;
import cn.chenzw.excel.magic.core.support.converter.AbstractExcelColumnConverter;
import cn.chenzw.excel.magic.core.support.converter.ExcelDefaultConverter;
import cn.chenzw.excel.magic.core.support.validator.AbstractExcelColumnValidator;
import cn.chenzw.excel.magic.core.support.validator.ExcelDefaultValidator;
import cn.chenzw.excel.magic.core.util.ExcelFieldUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractExcelReaderExecutor<T>
implements ExcelReaderLifecycle,
ExcelExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ExcelReaderExecutor.class);
    protected int curSheetIndex = 0;
    protected int curRowIndex;
    protected int curColIndex;
    protected int totalRows;
    protected ExcelReaderContext readerContext;
    protected ExcelSheetDefinition curSheet;
    private XSSFReader xssfReader;
    private List<T> datas = new ArrayList<T>();
    private Cache<String, List<AbstractExcelColumnValidator>> columnValidatorCache;
    private Cache<String, List<AbstractExcelColumnConverter>> columnConverterCache;

    public AbstractExcelReaderExecutor(ExcelReaderContext readerContext) {
        this.readerContext = readerContext;
        this.columnValidatorCache = CacheBuilder.newBuilder().build();
        this.columnConverterCache = CacheBuilder.newBuilder().build();
    }

    private void init() {
    }

    protected abstract ExcelPerRowProcessor getExcelRowProcess();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> executeRead() {
        Map<Integer, ExcelSheetDefinition> sheetdefinitions = this.readerContext.getSheetDefinitions();
        ZipSecureFile.setMinInflateRatio((double)-1.0);
        try (OPCPackage pkg = OPCPackage.open((InputStream)this.readerContext.getInputStream());){
            this.xssfReader = new XSSFReader(pkg);
            XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            XlsxAnalysisHandler xlsxAnalysisHandler = new XlsxAnalysisHandler(this.xssfReader.getStylesTable(), this.xssfReader.getSharedStringsTable(), this.getExcelRowProcess());
            parser.setContentHandler(xlsxAnalysisHandler);
            Iterator sheets = this.xssfReader.getSheetsData();
            while (sheets.hasNext()) {
                InputStream sheet = (InputStream)sheets.next();
                if (sheetdefinitions.containsKey(this.curSheetIndex + 1)) {
                    ++this.curSheetIndex;
                    InputSource sheetSource = new InputSource(sheet);
                    parser.parse(sheetSource);
                }
                sheet.close();
            }
            List<T> list = this.datas;
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (OpenXML4JException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Workbook executeWrite() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8c03\u7528\u6b64\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean isEmptyRow(ExcelRowDefinition row) {
        List<ExcelCellDefinition> excelCells = row.getExcelCells();
        for (ExcelCellDefinition excelCell : excelCells) {
            if (StringUtils.isBlank((CharSequence)excelCell.getCellValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(ExcelRowDefinition row) {
        List<ExcelCellDefinition> excelCells = row.getExcelCells();
        Map<Integer, Field> columnFields = this.curSheet.getColumnFields();
        for (Map.Entry<Integer, Field> columnFieldEntity : columnFields.entrySet()) {
            ExcelImportColumn importColumn;
            this.curColIndex = columnFieldEntity.getKey();
            Field field = columnFieldEntity.getValue();
            ExcelCellDefinition cell = this.getCell(excelCells, columnFieldEntity.getKey());
            if (StringUtils.isBlank((CharSequence)cell.getCellValue()) && !(importColumn = field.getAnnotation(ExcelImportColumn.class)).allowBlank()) {
                throw new ExcelException("\u8be5\u5b57\u6bb5\u503c\u4e3a\u7a7a!");
            }
            List<AbstractExcelColumnValidator> columnValidators = (List<AbstractExcelColumnValidator>)this.columnValidatorCache.getIfPresent((Object)field.getName());
            if (columnValidators == null) {
                columnValidators = this.findColumnValidators(field);
                this.columnValidatorCache.put((Object)field.getName(), columnValidators);
            }
            for (AbstractExcelColumnValidator columnValidator : columnValidators) {
                if (columnValidator.validate(cell.getCellValue())) continue;
                throw new ExcelException("\u8be5\u5b57\u6bb5\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7!");
            }
        }
        return true;
    }

    @Override
    public void format(ExcelRowDefinition row) {
        Map<Integer, Field> columnFields = this.curSheet.getColumnFields();
        List<ExcelCellDefinition> excelCells = row.getExcelCells();
        Object instance = null;
        try {
            instance = this.curSheet.getBindingModel().newInstance();
        }
        catch (InstantiationException e) {
            throw new ExcelException("\u5b9e\u4f8b\u5316\u5bf9\u8c61" + this.curSheet.getBindingModel() + "\u5931\u8d25!");
        }
        catch (IllegalAccessException e) {
            throw new ExcelException("\u5b9e\u4f8b\u5316\u5bf9\u8c61" + this.curSheet.getBindingModel() + "\u5931\u8d25!");
        }
        for (int i = 0; i < excelCells.size(); ++i) {
            this.curColIndex = i + 1;
            ExcelCellDefinition cell = excelCells.get(i);
            if (StringUtils.isBlank((CharSequence)cell.getCellValue())) continue;
            Field field = columnFields.get(cell.getColIndex());
            String cellValue = cell.getCellValue();
            List<AbstractExcelColumnConverter> columnConverters = (List<AbstractExcelColumnConverter>)this.columnConverterCache.getIfPresent((Object)field.getName());
            if (columnConverters == null) {
                columnConverters = this.findColumnConverter(field);
                this.columnConverterCache.put((Object)field.getName(), columnConverters);
            }
            for (AbstractExcelColumnConverter columnConverter : columnConverters) {
                cellValue = columnConverter.convert(cellValue);
            }
            try {
                ExcelFieldUtils.setFieldValue(field, instance, cellValue, field.getAnnotation(ExcelImportColumn.class).dateFormat());
                continue;
            }
            catch (ParseException e) {
                throw new ExcelException("\u5b57\u6bb5\u503c[ " + cellValue + " ]\u8f6c\u6362\u5931\u8d25!");
            }
            catch (IllegalAccessException e) {
                throw new ExcelException("\u5b57\u6bb5\u8d4b\u503c\u5931\u8d25!");
            }
        }
        this.datas.add(instance);
    }

    protected boolean isTitleRow(ExcelRowDefinition row) {
        return row.getRowIndex() < this.curSheet.getFirstDataRow();
    }

    private ExcelCellDefinition getCell(List<ExcelCellDefinition> excelCells, int colIndex) {
        for (ExcelCellDefinition excelCell : excelCells) {
            if (excelCell.getColIndex() != colIndex) continue;
            return excelCell;
        }
        return new ExcelCellDefinition();
    }

    private List<AbstractExcelColumnValidator> findColumnValidators(Field field) {
        Annotation[] annotations;
        List columnValidators = new ArrayList<AbstractExcelColumnValidator>();
        for (Annotation annotation : annotations = field.getAnnotations()) {
            Class<? extends Annotation> aClass = annotation.annotationType();
            if (!aClass.isAnnotationPresent(ConstraintValidator.class)) continue;
            ConstraintValidator constraintValidator = aClass.getAnnotation(ConstraintValidator.class);
            try {
                AbstractExcelColumnValidator columnValidator = constraintValidator.validator().newInstance();
                columnValidator.initialize(annotation);
                columnValidators.add(columnValidator);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelException("\u5b9e\u4f8b\u5316\u6821\u9a8c\u5668[" + constraintValidator.validator() + "]\u65f6\u5931\u8d25!", e);
            }
        }
        if (columnValidators.size() == 0) {
            columnValidators = Collections.singletonList(new ExcelDefaultValidator());
        }
        return columnValidators;
    }

    private List<AbstractExcelColumnConverter> findColumnConverter(Field field) {
        Annotation[] annotations;
        List columnConverters = new ArrayList<AbstractExcelColumnConverter>();
        for (Annotation annotation : annotations = field.getAnnotations()) {
            Class<? extends Annotation> aClass = annotation.annotationType();
            if (!aClass.isAnnotationPresent(ExcelConverter.class)) continue;
            ExcelConverter excelConverter = aClass.getAnnotation(ExcelConverter.class);
            try {
                AbstractExcelColumnConverter columnConverter = excelConverter.convertBy().newInstance();
                columnConverter.initialize(annotation);
                columnConverters.add(columnConverter);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelException("\u5b9e\u4f8b\u5316\u8f6c\u6362\u5668[" + excelConverter.convertBy() + "]\u65f6\u5931\u8d25!", e);
            }
        }
        if (columnConverters.size() == 0) {
            columnConverters = Collections.singletonList(new ExcelDefaultConverter());
        }
        return columnConverters;
    }
}

