/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.exception;

import cn.chenzw.excel.magic.core.exception.ExcelException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExcelReaderException
extends ExcelException {
    private int sheetIndex;
    private int rowIndex;
    private int colIndex;
    private String abcPosition;
    private String cellValue;
    private String message;
    private Throwable cause;

    public ExcelReaderException(int sheetIndex, int rowIndex, int colIndex, String cellValue, String message) {
        this.sheetIndex = sheetIndex;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.cellValue = cellValue;
        this.message = message;
    }

    public ExcelReaderException(int sheetIndex, int rowIndex, int colIndex, String cellValue, String message, Throwable cause) {
        this.sheetIndex = sheetIndex;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.cellValue = cellValue;
        this.message = message;
        this.cause = cause;
    }

    public ExcelReaderException(String message) {
        super(message);
        this.message = message;
    }

    public ExcelReaderException(String message, Throwable cause) {
        super(message, cause);
    }

    public ExcelReaderException(Throwable cause) {
        super(cause);
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public String getAbcPosition() {
        return this.abcPosition;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getShortMessage() {
        return String.format("sheet:[ %d ], row:[ %d ], col:[ %d ], cellValue: [ %s ], message:[ %s ]", this.sheetIndex, this.rowIndex, this.colIndex, this.cellValue, this.message);
    }

    public String getHumaneMessage() {
        return String.format("\u7b2c %d \u4e2aSheet\u9875 \u7684\u7b2c %d \u884c\u7b2c %d \u5217\u7684\u6570\u636e[%s]\u8bfb\u53d6\u5f02\u5e38! \u53ef\u80fd\u539f\u56e0:[%s]! \n \u8be6\u7ec6\u5806\u6808\u4fe1\u606f: [%s] ", this.sheetIndex, this.rowIndex, this.colIndex, this.cellValue, this.message, this.cause == null ? "" : ExceptionUtils.getStackTrace((Throwable)this.cause));
    }

    @Override
    public String toString() {
        return String.format("\u7b2c %d \u4e2aSheet\u9875\u7684\u7b2c %d \u884c\u7b2c %d \u5217\u7684\u6570\u636e[ %s ]\u8bfb\u53d6\u5f02\u5e38! \u53ef\u80fd\u539f\u56e0:[%s]! \n \u8be6\u7ec6\u5806\u6808\u4fe1\u606f: [%s] ", this.sheetIndex, this.rowIndex, this.colIndex, this.cellValue, this.message, this.cause == null ? "" : ExceptionUtils.getStackTrace((Throwable)this.cause));
    }
}

