/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.context;

import cn.chenzw.excel.magic.core.context.ExcelWriterContext;
import cn.chenzw.excel.magic.core.executor.ExcelExecutor;
import cn.chenzw.excel.magic.core.executor.ExcelWriterExecutor;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelExport;
import cn.chenzw.excel.magic.core.meta.model.AnnotationExcelWriterSheetDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelSheetDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelWriterSheetDefinition;
import cn.chenzw.excel.magic.core.util.ListUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class AnnotationExcelWriterContext
implements ExcelWriterContext {
    private List<ExcelWriterSheetDefinition> sheetDefinitions = new ArrayList<ExcelWriterSheetDefinition>();
    private Map<Integer, ExcelSheetDefinition> sheetDefinitionMap = new TreeMap<Integer, ExcelSheetDefinition>();
    private ExcelExecutor excelExecutor;
    private LoadingCache<String, Integer> sheetNameCache = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<String, Integer>(){

        public Integer load(String key) throws Exception {
            return 1;
        }
    });

    public AnnotationExcelWriterContext() {
        this.excelExecutor = new ExcelWriterExecutor(this);
    }

    @Override
    public Map<Integer, ExcelSheetDefinition> getSheetDefinitions() {
        return this.sheetDefinitionMap;
    }

    @Override
    public ExcelExecutor getExecutor() {
        return this.excelExecutor;
    }

    @Override
    public void addData(List<?> ... datas) {
        this.addData(Arrays.asList(datas));
    }

    @Override
    public void addData(List<List<?>> datas) {
        for (List<?> data : datas) {
            this.sheetDefinitions.add(new AnnotationExcelWriterSheetDefinition(ListUtils.getGenericClass(data), data));
        }
        Collections.sort(this.sheetDefinitions);
        this.buildSheetDefinitionMap();
    }

    @Override
    public void addModel(Class<?> ... clazzs) {
        for (Class<?> clazz : clazzs) {
            this.sheetDefinitions.add(new AnnotationExcelWriterSheetDefinition(clazz, Collections.emptyList()));
        }
        Collections.sort(this.sheetDefinitions);
        this.buildSheetDefinitionMap();
    }

    @Override
    public void removeSheet(int index) {
        this.sheetDefinitions.remove(index);
    }

    private String getOrignalSheetName(ExcelSheetDefinition sheetDefinition) {
        ExcelExport excelExport = sheetDefinition.getAnnotation(ExcelExport.class);
        return excelExport.sheetName();
    }

    private String buildUniqueSheetName(String sheetName) {
        try {
            int cnt = (Integer)this.sheetNameCache.get((Object)sheetName);
            this.sheetNameCache.put((Object)sheetName, (Object)(cnt + 1));
            if (cnt > 1) {
                return sheetName + "_" + cnt;
            }
            return sheetName;
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
            return "\u6570\u636e";
        }
    }

    private void buildSheetDefinitionMap() {
        this.sheetDefinitionMap.clear();
        this.sheetNameCache.invalidateAll();
        for (int i = 0; i < this.sheetDefinitions.size(); ++i) {
            ExcelWriterSheetDefinition tSheetDefinition = this.sheetDefinitions.get(i);
            String orignalSheetName = this.getOrignalSheetName(tSheetDefinition);
            tSheetDefinition.setSheetName(this.buildUniqueSheetName(orignalSheetName));
            this.sheetDefinitionMap.put(i, tSheetDefinition);
        }
    }
}

