/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.analysis;

import cn.chenzw.excel.magic.core.meta.model.ExcelCellDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelRowDefinition;
import cn.chenzw.excel.magic.core.processor.ExcelPerRowProcessor;
import cn.chenzw.excel.magic.core.util.ExcelXmlCodecUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxAnalysisHandler
extends DefaultHandler {
    private StylesTable stylesTable;
    private SharedStringsTable sst;
    private ExcelPerRowProcessor perRowProcessor;
    private int totalRow = 0;
    private String tagValue;
    private ExcelRowDefinition curExcelRow;
    private ExcelCellDefinition curExcelCell;
    private List<ExcelCellDefinition.ExcelCellType> excelCellTypes = new ArrayList<ExcelCellDefinition.ExcelCellType>();

    public XlsxAnalysisHandler(StylesTable stylesTable, SharedStringsTable sst, ExcelPerRowProcessor perRowProcessor) {
        this.sst = sst;
        this.stylesTable = stylesTable;
        this.perRowProcessor = perRowProcessor;
        this.registerExcelCellTypes();
    }

    private void registerExcelCellTypes() {
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelStringCellType(this.sst));
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelNumbericCellType(this.stylesTable));
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelDateCellType(this.stylesTable));
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelBooleanCellType());
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelInlinStrCellType());
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelErrorCellType());
        this.excelCellTypes.add(new ExcelCellDefinition.ExcelNullCellType());
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("dimension".equals(name)) {
            String refAttr = attributes.getValue("ref");
            this.totalRow = ExcelXmlCodecUtils.getTotalRow(refAttr);
            return;
        }
        if ("row".equals(name)) {
            this.curExcelRow = new ExcelRowDefinition();
            this.curExcelRow.setRowIndex(Integer.valueOf(attributes.getValue("r")));
        }
        if ("c".equals(name)) {
            this.curExcelCell = new ExcelCellDefinition();
            String abcColIndex = attributes.getValue("r");
            this.curExcelCell.setColIndex(ExcelXmlCodecUtils.getColIndex(abcColIndex));
            this.curExcelCell.setRowIndex(this.curExcelRow.getRowIndex());
            for (ExcelCellDefinition.ExcelCellType excelCellType : this.excelCellTypes) {
                if (!excelCellType.matches(name, attributes)) continue;
                this.curExcelCell.setCellType(excelCellType);
                break;
            }
        }
        this.tagValue = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("dimension".equals(name)) {
            this.perRowProcessor.processTotalRow(this.totalRow);
        }
        if ("row".equals(name)) {
            this.perRowProcessor.processPerRow(this.curExcelRow);
        }
        if ("c".equals(name)) {
            this.curExcelCell.setCellValue(StringUtils.trim((String)this.curExcelCell.getCellType().getValue(this.tagValue)));
            this.curExcelRow.addExceCell(this.curExcelCell);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.tagValue = this.tagValue + new String(ch, start, length);
    }
}

