/*
 * Copyright 2017-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.chenlc.qcloud.sdk.common.exceptions;

import cn.chenlc.qcloud.sdk.common.JsonResult;
import com.alibaba.fastjson.JSONObject;

/**
 * Qcloud SDK异常封装
 *
 * @author chenlc
 * @version 1.0
 * @since 2017/4/17
 */
public class QcloudSdkException extends Exception{

    private int code;

    public QcloudSdkException(int code, String message) {
        super(message);
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public String toString() {
        return JsonResult.failed(this.code, this.getMessage()).toString();
    }
}
