/*
 * Decompiled with CFR 0.152.
 */
package cn.chenjy.yums.http.template;

import cn.chenjy.yums.http.template.HttpTemplate;
import com.google.gson.Gson;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OkHttpTemplate
implements HttpTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpTemplate.class);
    private static final String TAG = "OkHttpTemplate";
    @Autowired
    OkHttpClient okHttpClient;

    @Override
    public String get(String url) {
        return this.get(url, null);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        Request request = this.getGetRquest(url, params);
        String responseStr = this.execRequest(request);
        return responseStr;
    }

    @Override
    public String post(String url) {
        return this.postByForm(url, null);
    }

    @Override
    public String postByForm(String url, Map<String, String> params) {
        Request request = this.getPostFormRequest(url, params);
        String responseStr = this.execRequest(request);
        return responseStr;
    }

    @Override
    public String postByJson(String url, Map<String, Object> params) {
        Request request = this.getPostJsonRequest(url, params);
        String responseStr = this.execRequest(request);
        return responseStr;
    }

    private String execRequest(Request request) {
        try (Response response = null;){
            response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
        }
        return null;
    }

    private String getQueryUrlString(String url, Map<String, String> params) {
        StringBuilder urlSb = new StringBuilder(url);
        if (params != null && params.keySet().size() > 0) {
            urlSb.append("?");
            for (Map.Entry<String, String> item : params.entrySet()) {
                urlSb.append(item.getKey()).append("=").append(item.getValue()).append("&");
            }
            urlSb.deleteCharAt(urlSb.lastIndexOf("&"));
        }
        return urlSb.toString();
    }

    private Request getGetRquest(String url, Map<String, String> params) {
        return new Request.Builder().url(this.getQueryUrlString(url, params)).build();
    }

    private Request getPostFormRequest(String url, Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        return request;
    }

    private Request getPostJsonRequest(String url, Map<String, Object> params) {
        Gson gson = new Gson();
        String jsonParams = gson.toJson(params);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return request;
    }
}

