/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.writer;

import cn.chenhuanming.octopus.config.ConfigFactory;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.util.CellUtils;
import cn.chenhuanming.octopus.writer.AbstractSheetWriter;
import cn.chenhuanming.octopus.writer.DefaultHeaderWriter;
import cn.chenhuanming.octopus.writer.HeaderWriter;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class DefaultSheetWriter<T>
extends AbstractSheetWriter<T> {
    public DefaultSheetWriter(ConfigFactory configFactory, HeaderWriter headerWriter, CellPosition startPoint) {
        super(configFactory, headerWriter, startPoint);
    }

    public DefaultSheetWriter(ConfigFactory configFactory) {
        this(configFactory, new DefaultHeaderWriter(), CellUtils.POSITION_ZERO_ZERO);
    }

    @Override
    public CellPosition write(Sheet sheet, Collection<T> data) {
        CellPosition end = super.write(sheet, data);
        this.adjustColumnWidth(sheet, end);
        return end;
    }

    private void adjustColumnWidth(Sheet sheet, CellPosition end) {
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        for (int col = this.getStartColumn(); col <= end.getCol(); ++col) {
            sheet.autoSizeColumn(col, true);
        }
    }
}

