/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.writer;

import cn.chenhuanming.octopus.config.Field;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.model.DefaultCellPosition;
import cn.chenhuanming.octopus.model.WorkbookContext;
import cn.chenhuanming.octopus.util.CellUtils;
import cn.chenhuanming.octopus.writer.HeaderWriter;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;

public class DefaultHeaderWriter
implements HeaderWriter {
    @Override
    public CellPosition drawHeader(Sheet sheet, CellPosition startPoint, List<Field> fields) {
        Field fake = new Field(fields);
        SupportField supportField = new SupportField(fake);
        int row = startPoint.getRow() - 1;
        int col = startPoint.getCol();
        int lastRow = row + supportField.getHeight() - 1;
        int lastCol = col + supportField.getWidth() - 1;
        WorkbookContext bookResource = new WorkbookContext(sheet.getWorkbook());
        this.drawHeaderImpl(sheet, row, lastRow, col, lastCol, supportField, bookResource);
        return new DefaultCellPosition(lastRow, lastCol);
    }

    private Cost drawHeaderImpl(Sheet sheet, int row, int lastRow, int col, int lastCol, SupportField header, WorkbookContext bookResource) {
        Field field = header.getField();
        CellStyle style = bookResource.getHeaderStyle(field);
        if (field.isLeaf()) {
            if (header.getHeight() == 1) {
                CellUtils.setCellValue(sheet, lastRow, col, field.getDescription(), style);
            } else {
                CellUtils.setCellValue(sheet, lastRow - header.getHeight() + 1, col, field.getDescription(), style);
                CellUtils.setMergeRegion(sheet, lastRow - header.getHeight() + 1, lastRow, col, col, style);
            }
            return new Cost(header.getHeight(), 1);
        }
        int costRow = 0;
        int c = col;
        for (SupportField headerChildren : header.getHeaderChildren()) {
            Cost cost = this.drawHeaderImpl(sheet, row + 1, lastRow, c, col + header.getWidth() - 1, headerChildren, bookResource);
            c += cost.getColNum();
            costRow = cost.getRowNum();
        }
        if (row >= 0) {
            CellUtils.setMergeRegionValue(sheet, row, lastRow - costRow, col, col + header.getWidth() - 1, field.getDescription(), style);
        }
        return new Cost(header.getHeight(), header.getWidth());
    }

    public static class SupportField {
        private Field field;
        private int height;
        private int width;
        private List<SupportField> headerChildren;

        public SupportField(Field field) {
            this.field = field;
            this.headerChildren = new ArrayList<SupportField>(field.getChildren().size());
            if (field.isLeaf()) {
                this.height = 1;
                this.width = 1;
                return;
            }
            int h = 1;
            int w = 0;
            for (Field field2 : field.getChildren()) {
                SupportField header = new SupportField(field2);
                h = Math.max(h, header.getHeight());
                w += header.width;
                this.headerChildren.add(header);
            }
            for (SupportField supportField : this.headerChildren) {
                supportField.setHeight(h);
            }
            this.height = h + 1;
            this.width = w;
        }

        public Field getField() {
            return this.field;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public List<SupportField> getHeaderChildren() {
            return this.headerChildren;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeaderChildren(List<SupportField> headerChildren) {
            this.headerChildren = headerChildren;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SupportField)) {
                return false;
            }
            SupportField other = (SupportField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            List<SupportField> this$headerChildren = this.getHeaderChildren();
            List<SupportField> other$headerChildren = other.getHeaderChildren();
            return !(this$headerChildren == null ? other$headerChildren != null : !((Object)this$headerChildren).equals(other$headerChildren));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SupportField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getWidth();
            List<SupportField> $headerChildren = this.getHeaderChildren();
            result = result * 59 + ($headerChildren == null ? 43 : ((Object)$headerChildren).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultHeaderWriter.SupportField(field=" + this.getField() + ", height=" + this.getHeight() + ", width=" + this.getWidth() + ", headerChildren=" + this.getHeaderChildren() + ")";
        }
    }

    private class Cost {
        private int rowNum;
        private int colNum;

        public int getRowNum() {
            return this.rowNum;
        }

        public int getColNum() {
            return this.colNum;
        }

        public void setRowNum(int rowNum) {
            this.rowNum = rowNum;
        }

        public void setColNum(int colNum) {
            this.colNum = colNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cost)) {
                return false;
            }
            Cost other = (Cost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRowNum() != other.getRowNum()) {
                return false;
            }
            return this.getColNum() == other.getColNum();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cost;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowNum();
            result = result * 59 + this.getColNum();
            return result;
        }

        public String toString() {
            return "DefaultHeaderWriter.Cost(rowNum=" + this.getRowNum() + ", colNum=" + this.getColNum() + ")";
        }

        @ConstructorProperties(value={"rowNum", "colNum"})
        public Cost(int rowNum, int colNum) {
            this.rowNum = rowNum;
            this.colNum = colNum;
        }
    }
}

