/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.writer;

import cn.chenhuanming.octopus.writer.ExcelWriter;
import cn.chenhuanming.octopus.writer.SheetWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DefaultExcelWriter
implements ExcelWriter {
    private final Workbook workbook;
    private final OutputStream os;

    public DefaultExcelWriter(OutputStream os) {
        this((Workbook)new XSSFWorkbook(), os);
    }

    public DefaultExcelWriter(Workbook workbook, OutputStream os) {
        this.workbook = workbook;
        this.os = os;
    }

    @Override
    public <T> ExcelWriter write(String sheetName, SheetWriter<T> sheetWriter, Collection<T> collection) {
        Sheet sheet = this.workbook.createSheet(sheetName);
        sheetWriter.write(sheet, collection);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.workbook.write(this.os);
    }
}

