/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.writer;

import cn.chenhuanming.octopus.config.Config;
import cn.chenhuanming.octopus.config.ConfigFactory;
import cn.chenhuanming.octopus.config.Field;
import cn.chenhuanming.octopus.formatter.Formatter;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.model.DefaultCellPosition;
import cn.chenhuanming.octopus.model.WorkbookContext;
import cn.chenhuanming.octopus.util.CellUtils;
import cn.chenhuanming.octopus.util.ReflectionUtils;
import cn.chenhuanming.octopus.util.StringUtils;
import cn.chenhuanming.octopus.writer.HeaderWriter;
import cn.chenhuanming.octopus.writer.SheetWriter;
import java.util.Collection;
import java.util.Date;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSheetWriter<T>
implements SheetWriter<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSheetWriter.class);
    protected ConfigFactory configFactory;
    protected HeaderWriter headerWriter;
    protected CellPosition startPoint;

    public AbstractSheetWriter(ConfigFactory configFactory, HeaderWriter headerWriter, CellPosition startPoint) {
        this.configFactory = configFactory;
        this.headerWriter = headerWriter;
        this.startPoint = startPoint;
    }

    @Override
    public CellPosition write(Sheet sheet, Collection<T> data) {
        if (!this.canWrite(sheet, data)) {
            return CellUtils.POSITION_ZERO_ZERO;
        }
        Config config = this.configFactory.getConfig();
        Class<?> dataType = data.iterator().next().getClass();
        if (config.getClassType() != dataType) {
            throw new IllegalArgumentException("class of config is " + config.getClassType().getName() + " but type of data is " + dataType.getName());
        }
        CellPosition end = this.headerWriter.drawHeader(sheet, this.startPoint, config.getFields());
        int row = end.getRow() + 1;
        int col = this.getStartColumn();
        WorkbookContext bookResource = new WorkbookContext(sheet.getWorkbook());
        for (T t : data) {
            for (Field field : config.getFields()) {
                col = this.draw(sheet, row, col, field, t, bookResource);
            }
            col = this.getStartColumn();
            ++row;
        }
        return new DefaultCellPosition(row, end.getCol());
    }

    protected int getStartColumn() {
        return 0;
    }

    private int draw(Sheet sheet, int row, int col, Field field, Object o, WorkbookContext bookResource) {
        if (field.isLeaf()) {
            return this.drawColumn(sheet, row, col, field, o, bookResource);
        }
        Object p = null;
        if (o != null) {
            p = ReflectionUtils.invokeReadMethod(field.getPicker(), o);
        }
        int c = col;
        for (Field child : field.getChildren()) {
            c = this.draw(sheet, row, c, child, p, bookResource);
        }
        return c;
    }

    protected int drawColumn(Sheet sheet, int row, int col, Field field, Object o, WorkbookContext bookResource) {
        if (o == null) {
            return col + 1;
        }
        if (field.getFormatter() != null) {
            String value = field.getFormatter().format(ReflectionUtils.invokeReadMethod(field.getPicker(), o));
            CellUtils.setCellValue(sheet, row, col, value, bookResource.getCellStyle(field));
            return col + 1;
        }
        Formatter<?> formatter = this.configFactory.getConfig().getFormatterContainer().get(field.getPicker().getReturnType());
        if (field.getPicker().getReturnType() == String.class || formatter == null) {
            String value = ReflectionUtils.invokeReadMethod(field.getPicker(), o, field.getDefaultValue());
            CellUtils.setCellValue(sheet, row, col, value, bookResource.getCellStyle(field));
            return col + 1;
        }
        String value = field.getPicker().getReturnType() == Date.class && field.getDateFormat() != null ? field.getDateFormat().format((Date)ReflectionUtils.invokeReadMethod(field.getPicker(), o)) : formatter.format(ReflectionUtils.invokeReadMethod(field.getPicker(), o));
        if (StringUtils.isEmpty(value)) {
            value = field.getDefaultValue();
        }
        CellUtils.setCellValue(sheet, row, col, value, bookResource.getCellStyle(field));
        return col + 1;
    }

    protected boolean canWrite(Sheet sheet, Collection<T> collection) {
        return collection != null && collection.size() > 0;
    }
}

