/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static String invokeReadMethod(Method method, Object o, String defaultValue) {
        if (method == null || o == null) {
            return defaultValue;
        }
        String value = defaultValue;
        Object o1 = ReflectionUtils.invokeReadMethod(method, o);
        if (o1 != null) {
            value = String.valueOf(o1);
        }
        return value;
    }

    public static Object invokeReadMethod(Method method, Object o) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            log.debug("failed to invoke " + method.getClass() + "#" + method.getName(), (Throwable)e);
            return null;
        }
    }

    public static Method readMethod(Class clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            return new PropertyDescriptor(fieldName, clazz).getReadMethod();
        }
        catch (Exception e) {
            log.debug("failed to fetch getter method for field " + fieldName, (Throwable)e);
            return null;
        }
    }

    public static Method writeMethod(Class clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            return new PropertyDescriptor(fieldName, clazz).getWriteMethod();
        }
        catch (Exception e) {
            log.debug("failed to fetch setter method for field " + fieldName, (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.error("can not new instance through default constructor:" + clazz.getName());
            return null;
        }
    }
}

