/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.util;

import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.model.DefaultCellPosition;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class CellUtils {
    public static final CellPosition POSITION_ZERO_ZERO = new DefaultCellPosition(0, 0);

    public static void setCellValue(Sheet sheet, int row, int col, String value, CellStyle cellStyle) {
        Cell cell;
        Row sheetRow = sheet.getRow(row);
        if (sheetRow == null) {
            sheetRow = sheet.createRow(row);
        }
        if ((cell = sheetRow.getCell(col)) == null) {
            cell = sheetRow.createCell(col);
        }
        cell.setCellValue(value);
        cell.setCellStyle(cellStyle);
    }

    public static void setMergeRegionValue(Sheet sheet, int row, int lastRow, int col, int lastCol, String value, CellStyle cellStyle) {
        if (row == lastRow && col == lastCol) {
            CellUtils.setCellValue(sheet, row, col, value, cellStyle);
        } else {
            CellUtils.setCellValue(sheet, lastRow, col, value, cellStyle);
            CellUtils.setMergeRegion(sheet, row, lastRow, col, lastCol, cellStyle);
        }
    }

    public static void setMergeRegion(Sheet sheet, int row, int lastRow, int col, int lastCol, CellStyle cellStyle) {
        int i = sheet.addMergedRegion(new CellRangeAddress(row, lastRow, col, lastCol));
        CellRangeAddress region = sheet.getMergedRegion(sheet instanceof XSSFSheet || sheet instanceof SXSSFSheet ? i - 1 : i);
        RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTopEnum(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeftEnum(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottomEnum(), (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRightEnum(), (CellRangeAddress)region, (Sheet)sheet);
    }

    public static String getCellValue(Sheet sheet, int row, int col, String defaultValue) {
        Cell cell = sheet.getRow(row).getCell(col);
        if (cell == null) {
            return defaultValue;
        }
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case FORMULA: 
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
        }
        return defaultValue;
    }

    public static boolean isDate(Cell cell) {
        try {
            return DateUtil.isCellDateFormatted((Cell)cell);
        }
        catch (Exception e) {
            return false;
        }
    }
}

