/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.reader;

import cn.chenhuanming.octopus.config.ConfigFactory;
import cn.chenhuanming.octopus.config.Field;
import cn.chenhuanming.octopus.exception.ParseException;
import cn.chenhuanming.octopus.formatter.Formatter;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.reader.AbstractSheetReader;
import cn.chenhuanming.octopus.util.CellUtils;
import cn.chenhuanming.octopus.util.ReflectionUtils;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSheetReader<T>
extends AbstractSheetReader<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSheetReader.class);

    public DefaultSheetReader(Sheet sheet, ConfigFactory configFactory, CellPosition startPoint) {
        super(sheet, configFactory, startPoint);
    }

    @Override
    int read(int row, int col, Field field, Object o) {
        if (field.isLeaf()) {
            try {
                String str;
                Cell cell = this.sheet.getRow(row).getCell(col);
                if (CellUtils.isDate(cell)) {
                    Formatter<Date> dateFormatter = this.configFactory.getConfig().getFormatterContainer().get(Date.class);
                    str = dateFormatter.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                } else {
                    str = CellUtils.getCellValue(this.sheet, row, col, field.getDefaultValue());
                }
                this.setValue(str, field, o);
            }
            catch (ParseException e) {
                this.failWhenParse(row, col, field, e);
            }
            return col + 1;
        }
        Object instance = ReflectionUtils.newInstance(field.getPusher().getParameterTypes()[0]);
        for (Field child : field.getChildren()) {
            if (instance == null) continue;
            col = this.read(row, col, child, instance);
            try {
                field.getPusher().invoke(o, instance);
            }
            catch (Exception e) {
                log.error("failed to set " + instance + " into " + o, (Throwable)e);
            }
        }
        return col;
    }

    protected void failWhenParse(int row, int col, Field field, ParseException e) {
        log.error("failed to read value from " + field.getName() + " in excel(" + (row + 1) + "," + col + ")", (Throwable)e);
    }
}

