/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.reader;

import cn.chenhuanming.octopus.config.ConfigFactory;
import cn.chenhuanming.octopus.exception.SheetNotFoundException;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.reader.DefaultSheetReader;
import cn.chenhuanming.octopus.reader.ExcelReader;
import cn.chenhuanming.octopus.reader.SheetReader;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class DefaultExcelReader<T>
implements ExcelReader<T> {
    protected Workbook workbook;

    public DefaultExcelReader(Workbook workbook) {
        if (workbook == null) {
            throw new NullPointerException("workbook can not be null");
        }
        this.workbook = workbook;
    }

    @Override
    public SheetReader<T> get(int index, ConfigFactory configFactory, CellPosition startPoint) {
        return new DefaultSheetReader(this.workbook.getSheetAt(index), configFactory, startPoint);
    }

    @Override
    public SheetReader<T> get(String sheetName, ConfigFactory configFactory, CellPosition startPoint) throws SheetNotFoundException {
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            if (!sheet.getSheetName().equals(sheetName)) continue;
            return this.get(i, configFactory, startPoint);
        }
        throw new SheetNotFoundException("not found:" + sheetName);
    }
}

