/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.reader;

import cn.chenhuanming.octopus.config.ConfigFactory;
import cn.chenhuanming.octopus.config.Field;
import cn.chenhuanming.octopus.exception.ParseException;
import cn.chenhuanming.octopus.formatter.Formatter;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.reader.SheetReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSheetReader<T>
implements SheetReader<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSheetReader.class);
    protected Sheet sheet;
    protected ConfigFactory configFactory;
    protected CellPosition startPoint;

    public AbstractSheetReader(Sheet sheet, ConfigFactory configFactory, CellPosition startPoint) {
        if (sheet == null || configFactory == null || startPoint == null) {
            throw new NullPointerException();
        }
        this.sheet = sheet;
        this.configFactory = configFactory;
        this.startPoint = startPoint;
    }

    @Override
    public T get(int i) {
        T t = this.newInstance(this.configFactory.getConfig().getClassType());
        int col = this.startPoint.getCol();
        for (Field field : this.configFactory.getConfig().getFields()) {
            col = this.read(this.startPoint.getRow() + i, col, field, t);
        }
        return t;
    }

    protected void setValue(String str, Field field, Object o) throws ParseException {
        Formatter<?> globalFormatter;
        Method pusher = field.getPusher();
        Object value = null;
        value = field.getFormatter() != null ? (Object)field.getFormatter().parse(str) : ((globalFormatter = this.configFactory.getConfig().getFormatterContainer().get(pusher.getParameterTypes()[0])) != null ? globalFormatter.parse(str) : str);
        try {
            if (value != null) {
                pusher.invoke(o, value);
            }
        }
        catch (Exception e) {
            log.error("can not set value:" + field.getName(), (Throwable)e);
            throw new ParseException("invoke method failed", e);
        }
    }

    protected T newInstance(Class classType) {
        try {
            return this.configFactory.getConfig().getClassType().newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("wrong type or no default constructor", e);
        }
    }

    @Override
    public int size() {
        return this.sheet.getLastRowNum() + 1;
    }

    abstract int read(int var1, int var2, Field var3, Object var4);

    @Override
    public Iterator<T> iterator() {
        return new RowIterator(this.sheet.getLastRowNum() - this.startPoint.getRow(), 0);
    }

    private class RowIterator<T>
    implements Iterator<T> {
        private int last;
        private int cursor;

        public RowIterator(int last, int cursor) {
            this.last = last;
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor <= this.last;
        }

        @Override
        public T next() {
            return AbstractSheetReader.this.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

