/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.config;

import cn.chenhuanming.octopus.config.AbstractXMLConfigFactory;
import cn.chenhuanming.octopus.config.Config;
import cn.chenhuanming.octopus.config.Field;
import cn.chenhuanming.octopus.config.FieldCellStyle;
import cn.chenhuanming.octopus.config.ImportValidation;
import cn.chenhuanming.octopus.formatter.DateFormatter;
import cn.chenhuanming.octopus.formatter.DefaultFormatterContainer;
import cn.chenhuanming.octopus.formatter.Formatter;
import cn.chenhuanming.octopus.formatter.FormatterContainer;
import cn.chenhuanming.octopus.util.ColorUtils;
import cn.chenhuanming.octopus.util.ReflectionUtils;
import cn.chenhuanming.octopus.util.StringUtils;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigFactory
extends AbstractXMLConfigFactory {
    private static final Logger log = LoggerFactory.getLogger(XmlConfigFactory.class);

    public XmlConfigFactory(InputStream is) {
        super(is);
    }

    @Override
    protected Config readConfig() {
        Document document;
        try {
            this.validateXML(new StreamSource(this.is));
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("xml file is not valid", e);
        }
        Element root = document.getDocumentElement();
        Config config = new Config();
        if (!"Root".equals(root.getTagName())) {
            throw new IllegalArgumentException("xml config file: must has a root tag named Root");
        }
        String className = root.getAttribute("class");
        if (StringUtils.isEmpty(className)) {
            throw new IllegalArgumentException("xml config file: tag Rootmust has class attribute");
        }
        Class<?> classType = null;
        try {
            classType = Class.forName(className);
            config.setClassType(classType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        Node formattersNode = root.getElementsByTagName("Formatters").item(0);
        config.setFormatterContainer(this.readFormatter(formattersNode));
        Field field = this.getField(root, classType);
        config.setFields(field.getChildren());
        return config;
    }

    private FormatterContainer readFormatter(Node formatNode) {
        DefaultFormatterContainer container = new DefaultFormatterContainer();
        String dateFormat = this.getAttribute(formatNode, "date-format");
        if (StringUtils.isEmpty(dateFormat)) {
            container.addFormat(Date.class, new DateFormatter("yyyy-MM-dd HH:mm:ss"));
        } else {
            container.addFormat(Date.class, new DateFormatter(dateFormat));
        }
        if (formatNode != null && formatNode.hasChildNodes()) {
            NodeList children = formatNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node item = children.item(i);
                if (item.getNodeType() == 1 || !item.getNodeName().equals("Formatter")) continue;
                String targetClass = this.getAttribute(item, "target");
                String formatClass = this.getAttribute(item, "class");
                try {
                    Class<?> target = Class.forName(targetClass);
                    Class<?> format = Class.forName(formatClass);
                    container.addFormat(target, (Formatter)format.newInstance());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return container;
    }

    private Field getField(Node node, Class classType) {
        Field field = new Field();
        this.setBaseConfig(field, node);
        this.setCellStyleConfig(field, node);
        this.setHeaderCellStyleConfig(field, node);
        this.setInvoker(field, classType);
        if (node.getNodeName().equals("Field")) {
            this.setImportValidation(field, node);
        }
        NodeList children = node.getChildNodes();
        Class<?> headerType = node.getNodeName().equals("Root") ? classType : (field.getPicker() != null ? field.getPicker().getReturnType() : null);
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (item.getNodeType() != 1 || !item.getNodeName().equals("Field") && !item.getNodeName().equals("Header")) continue;
            field.addChildren(this.getField(children.item(i), headerType));
        }
        return field;
    }

    private void setBaseConfig(Field field, Node node) {
        String formatterStr;
        String dateFormat;
        String desc;
        String name = this.getAttribute(node, "name");
        if (!StringUtils.isEmpty(name)) {
            field.setName(name);
        }
        if (!StringUtils.isEmpty(desc = this.getAttribute(node, "description"))) {
            field.setDescription(desc);
        }
        if (!StringUtils.isEmpty(dateFormat = this.getAttribute(node, "date-format"))) {
            field.setDateFormat(new DateFormatter(dateFormat));
        }
        if (!StringUtils.isEmpty(formatterStr = this.getAttribute(node, "formatter"))) {
            try {
                Class<?> formatterClass = Class.forName(formatterStr);
                if (!Formatter.class.isAssignableFrom(formatterClass)) {
                    log.error(formatterStr + " is not subclass of cn.chenhuanming.octopus.formatter.Formatters");
                } else {
                    field.setFormatter((Formatter)formatterClass.newInstance());
                }
            }
            catch (Exception e) {
                log.warn(formatterStr + " may not have a default constructor");
            }
        }
    }

    private void setCellStyleConfig(Field field, Node node) {
        FieldCellStyle.FieldCellStyleBuilder builder = FieldCellStyle.builder();
        String fontSize = this.getAttribute(node, "font-size");
        builder.fontSize(Short.parseShort(StringUtils.defaultIfEmpty(fontSize, "14")));
        String color = this.getAttribute(node, "color");
        builder.color(ColorUtils.hex2Rgb(StringUtils.defaultIfEmpty(color, "#000000")));
        String isBold = this.getAttribute(node, "is-bold");
        builder.bold(Boolean.parseBoolean(StringUtils.defaultIfEmpty(isBold, "false")));
        String foregroundColor = this.getAttribute(node, "foreground-color");
        builder.foregroundColor(ColorUtils.hex2Rgb(StringUtils.defaultIfEmpty(foregroundColor, null)));
        String border = this.getAttribute(node, "border");
        builder.border(this.convertBorder(StringUtils.defaultIfEmpty(border, "0,0,0,0")));
        String borderColor = this.getAttribute(node, "border-color");
        builder.borderColor(this.convertBorderColor(StringUtils.defaultIfEmpty(borderColor, "#000000,#000000,#000000,#000000")));
        field.setFieldCellStyle(builder.build());
    }

    private void setHeaderCellStyleConfig(Field field, Node node) {
        FieldCellStyle.FieldCellStyleBuilder builder = FieldCellStyle.builder();
        String fontSize = this.getAttribute(node, "header-font-size");
        builder.fontSize(Short.parseShort(StringUtils.defaultIfEmpty(fontSize, "15")));
        String color = this.getAttribute(node, "header-color");
        builder.color(ColorUtils.hex2Rgb(StringUtils.defaultIfEmpty(color, "#000000")));
        String isBold = this.getAttribute(node, "header-is-bold");
        builder.bold(Boolean.parseBoolean(StringUtils.defaultIfEmpty(isBold, "true")));
        String foregroundColor = this.getAttribute(node, "header-foreground-color");
        builder.foregroundColor(ColorUtils.hex2Rgb(StringUtils.defaultIfEmpty(foregroundColor, "#FFFFFF")));
        String border = this.getAttribute(node, "header-border");
        builder.border(this.convertBorder(StringUtils.defaultIfEmpty(border, "1,1,1,1")));
        String borderColor = this.getAttribute(node, "header-border-color");
        builder.borderColor(this.convertBorderColor(StringUtils.defaultIfEmpty(borderColor, "#000000,#000000,#000000,#000000")));
        field.setHeaderFieldCellStyle(builder.build());
    }

    private void setInvoker(Field field, Class classType) {
        if (classType == null || StringUtils.isEmpty(field.getName())) {
            return;
        }
        Method picker = ReflectionUtils.readMethod(classType, field.getName());
        field.setPicker(picker);
        Method pusher = ReflectionUtils.writeMethod(classType, field.getName());
        field.setPusher(pusher);
    }

    private void setImportValidation(Field field, Node node) {
        String options;
        String regex;
        ImportValidation validation = new ImportValidation();
        String isBlankable = this.getAttribute(node, "is-blankable");
        if (!StringUtils.isEmpty(isBlankable)) {
            validation.setBlankable(Boolean.parseBoolean(isBlankable));
        }
        if (!StringUtils.isEmpty(regex = this.getAttribute(node, "regex"))) {
            validation.setRegex(Pattern.compile(regex));
        }
        if (!StringUtils.isEmpty(options = this.getAttribute(node, "options")) && options.length() >= 2) {
            String[] split = options.split("\\|");
            validation.setOptions(Arrays.asList(split));
        }
        field.setImportValidation(validation);
    }
}

