/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.config;

import java.awt.Color;
import java.util.Arrays;
import org.apache.poi.ss.usermodel.BorderStyle;

public class FieldCellStyle {
    private short fontSize;
    private Color color;
    private boolean bold;
    private Color foregroundColor;
    private BorderStyle[] border;
    private Color[] borderColor;

    public static FieldCellStyle defaultCellStyle() {
        return FieldCellStyle.builder().fontSize((short)14).color(Color.BLACK).bold(false).foregroundColor(null).border(null).borderColor(null).build();
    }

    public static FieldCellStyle defaultHeaderCellStyle() {
        return FieldCellStyle.builder().fontSize((short)15).color(Color.BLACK).bold(true).foregroundColor(null).border(new BorderStyle[]{BorderStyle.THIN, BorderStyle.THIN, BorderStyle.THIN, BorderStyle.THIN}).borderColor(null).build();
    }

    FieldCellStyle(short fontSize, Color color, boolean bold, Color foregroundColor, BorderStyle[] border, Color[] borderColor) {
        this.fontSize = fontSize;
        this.color = color;
        this.bold = bold;
        this.foregroundColor = foregroundColor;
        this.border = border;
        this.borderColor = borderColor;
    }

    public static FieldCellStyleBuilder builder() {
        return new FieldCellStyleBuilder();
    }

    public short getFontSize() {
        return this.fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public BorderStyle[] getBorder() {
        return this.border;
    }

    public Color[] getBorderColor() {
        return this.borderColor;
    }

    public void setFontSize(short fontSize) {
        this.fontSize = fontSize;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setBorder(BorderStyle[] border) {
        this.border = border;
    }

    public void setBorderColor(Color[] borderColor) {
        this.borderColor = borderColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldCellStyle)) {
            return false;
        }
        FieldCellStyle other = (FieldCellStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        if (this.isBold() != other.isBold()) {
            return false;
        }
        Color this$foregroundColor = this.getForegroundColor();
        Color other$foregroundColor = other.getForegroundColor();
        if (this$foregroundColor == null ? other$foregroundColor != null : !((Object)this$foregroundColor).equals(other$foregroundColor)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBorder(), other.getBorder())) {
            return false;
        }
        return Arrays.deepEquals(this.getBorderColor(), other.getBorderColor());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldCellStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFontSize();
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        result = result * 59 + (this.isBold() ? 79 : 97);
        Color $foregroundColor = this.getForegroundColor();
        result = result * 59 + ($foregroundColor == null ? 43 : ((Object)$foregroundColor).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBorder());
        result = result * 59 + Arrays.deepHashCode(this.getBorderColor());
        return result;
    }

    public String toString() {
        return "FieldCellStyle(fontSize=" + this.getFontSize() + ", color=" + this.getColor() + ", bold=" + this.isBold() + ", foregroundColor=" + this.getForegroundColor() + ", border=" + Arrays.deepToString(this.getBorder()) + ", borderColor=" + Arrays.deepToString(this.getBorderColor()) + ")";
    }

    public static class FieldCellStyleBuilder {
        private short fontSize;
        private Color color;
        private boolean bold;
        private Color foregroundColor;
        private BorderStyle[] border;
        private Color[] borderColor;

        FieldCellStyleBuilder() {
        }

        public FieldCellStyleBuilder fontSize(short fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public FieldCellStyleBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public FieldCellStyleBuilder bold(boolean bold) {
            this.bold = bold;
            return this;
        }

        public FieldCellStyleBuilder foregroundColor(Color foregroundColor) {
            this.foregroundColor = foregroundColor;
            return this;
        }

        public FieldCellStyleBuilder border(BorderStyle[] border) {
            this.border = border;
            return this;
        }

        public FieldCellStyleBuilder borderColor(Color[] borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public FieldCellStyle build() {
            return new FieldCellStyle(this.fontSize, this.color, this.bold, this.foregroundColor, this.border, this.borderColor);
        }

        public String toString() {
            return "FieldCellStyle.FieldCellStyleBuilder(fontSize=" + this.fontSize + ", color=" + this.color + ", bold=" + this.bold + ", foregroundColor=" + this.foregroundColor + ", border=" + Arrays.deepToString(this.border) + ", borderColor=" + Arrays.deepToString(this.borderColor) + ")";
        }
    }
}

