/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus.config;

import cn.chenhuanming.octopus.config.CachedConfigFactory;
import cn.chenhuanming.octopus.util.ColorUtils;
import cn.chenhuanming.octopus.util.StringUtils;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractXMLConfigFactory
extends CachedConfigFactory {
    protected final ByteArrayInputStream is;
    protected static final String SPLITTER = "\\|";
    private static final String SCHEMA_URI = "https://raw.githubusercontent.com/zerouwar/my-maven-repo/master/cn/chenhuanming/octopus/1.1.0/octopus.xsd";

    public AbstractXMLConfigFactory(InputStream is) {
        try {
            this.is = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)is));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void validateXML(Source source) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL(SCHEMA_URI));
        Validator validator = schema.newValidator();
        validator.validate(source);
        this.is.reset();
    }

    protected String getAttribute(Node node, String name) {
        if (node == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        Node item = attributes.getNamedItem(name);
        if (item == null) {
            return null;
        }
        return item.getNodeValue();
    }

    protected BorderStyle[] convertBorder(String border) {
        BorderStyle[] result = new BorderStyle[4];
        String[] split = border.split(",");
        for (int i = 0; i < split.length; ++i) {
            BorderStyle style;
            short val = Short.parseShort(split[i]);
            result[i] = style = BorderStyle.valueOf((short)val);
        }
        return result;
    }

    protected Color[] convertBorderColor(String borderColor) {
        Color[] result = new Color[4];
        String[] split = borderColor.split(",");
        for (int i = 0; i < split.length; ++i) {
            Color color;
            String c = split[i];
            result[i] = color = ColorUtils.hex2Rgb(StringUtils.isEmpty(c) ? "#000000" : c);
        }
        return result;
    }

    protected static interface XMLConstant {

        public static interface Formatters {
            public static final String name = "Formatters";

            public static interface Attribute {
                public static final String DATE_FORMAT = "date-format";
            }

            public static interface Formatter {
                public static final String name = "Formatter";

                public static interface Attribute {
                    public static final String TARGET = "target";
                    public static final String CLASS = "class";
                }
            }
        }

        public static interface Field {
            public static final String name = "Field";

            public static interface Attribute
            extends Header.Attribute {
                public static final String FONT_SIZE = "font-size";
                public static final String COLOR = "color";
                public static final String IS_BOLD = "is-bold";
                public static final String FOREGROUND_COLOR = "foreground-color";
                public static final String BORDER = "border";
                public static final String BORDER_COLOR = "border-color";
                public static final String DATE_FORMAT = "date-format";
                public static final String FORMATTER = "formatter";
                public static final String IS_BLANKABLE = "is-blankable";
                public static final String REGEX = "regex";
                public static final String OPTIONS = "options";
            }
        }

        public static interface Header {
            public static final String name = "Header";

            public static interface Attribute {
                public static final String NAME = "name";
                public static final String DESCRIPTION = "description";
                public static final String HEADER_FONT_SIZE = "header-font-size";
                public static final String HEADER_COLOR = "header-color";
                public static final String IS_HEADER_BOLD = "header-is-bold";
                public static final String HEADER_FOREGROUND_COLOR = "header-foreground-color";
                public static final String HEADER_BORDER = "header-border";
                public static final String HEADER_BORDER_COLOR = "header-border-color";
            }
        }

        public static interface Root {
            public static final String name = "Root";

            public static interface Attribute {
                public static final String CLASS = "class";
            }
        }
    }
}

