/*
 * Decompiled with CFR 0.152.
 */
package cn.chenhuanming.octopus;

import cn.chenhuanming.octopus.config.ConfigFactory;
import cn.chenhuanming.octopus.config.XmlConfigFactory;
import cn.chenhuanming.octopus.exception.SheetNotFoundException;
import cn.chenhuanming.octopus.model.CellPosition;
import cn.chenhuanming.octopus.model.CheckedData;
import cn.chenhuanming.octopus.reader.CheckedExcelReader;
import cn.chenhuanming.octopus.reader.DefaultExcelReader;
import cn.chenhuanming.octopus.reader.SheetReader;
import cn.chenhuanming.octopus.writer.DefaultExcelWriter;
import cn.chenhuanming.octopus.writer.DefaultSheetWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class Octopus {
    public static ConfigFactory getXMLConfigFactory(InputStream is) {
        return new XmlConfigFactory(is);
    }

    public static <T> void writeOneSheet(OutputStream os, ConfigFactory configFactory, String sheetName, Collection<T> data) throws IOException {
        DefaultExcelWriter writer = new DefaultExcelWriter((Workbook)new SXSSFWorkbook(), os);
        writer.write(sheetName, new DefaultSheetWriter(configFactory), data);
        writer.close();
    }

    public static <T> SheetReader<T> readFirstSheet(InputStream is, ConfigFactory configFactory, CellPosition startPosition) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return Octopus.readOneSheet(is, 0, configFactory, startPosition);
    }

    public static <T> SheetReader<T> readOneSheet(InputStream is, int index, ConfigFactory configFactory, CellPosition startPosition) throws IOException, InvalidFormatException, EncryptedDocumentException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return new DefaultExcelReader(workbook).get(index, configFactory, startPosition);
    }

    public static <T> SheetReader<T> readBySheetName(InputStream is, String sheetName, ConfigFactory configFactory, CellPosition startPosition) throws IOException, InvalidFormatException, EncryptedDocumentException, SheetNotFoundException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return new DefaultExcelReader(workbook).get(sheetName, configFactory, startPosition);
    }

    public static <T> SheetReader<CheckedData<T>> readFirstSheetWithValidation(InputStream is, ConfigFactory configFactory, CellPosition startPosition) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return Octopus.readOneSheetWithValidation(is, 0, configFactory, startPosition);
    }

    public static <T> SheetReader<CheckedData<T>> readOneSheetWithValidation(InputStream is, int index, ConfigFactory configFactory, CellPosition startPosition) throws IOException, InvalidFormatException, EncryptedDocumentException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return new CheckedExcelReader(workbook).get(index, configFactory, startPosition);
    }

    public static <T> SheetReader<CheckedData<T>> readBySheetNameWithValidation(InputStream is, String sheetName, ConfigFactory configFactory, CellPosition startPosition) throws IOException, InvalidFormatException, EncryptedDocumentException, SheetNotFoundException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        return new CheckedExcelReader(workbook).get(sheetName, configFactory, startPosition);
    }
}

