/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.utils;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.GroupInfo;
import cn.chahuyun.entity.GroupList;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.enums.Mate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.ConcurrencyKind;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.EventPriority;
import net.mamoe.mirai.event.GlobalEventChannel;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.SingleMessage;
import org.jetbrains.annotations.NotNull;

public class ShareUtils {
    private static final Map<String, Integer> map = new HashMap<String, Integer>();
    public static final String DYNAMIC_MESSAGE_PATTERN = String.format("\\%s\\w+\\((\\S+?)\\)", ConfigData.INSTANCE.getVariableSymbol());

    private ShareUtils() {
    }

    public static boolean isQuit(MessageEvent event) {
        String messagePattern = "^!!!|^\uff01\uff01\uff01";
        Pattern pattern = Pattern.compile(messagePattern);
        Matcher matcher = pattern.matcher(event.getMessage().serializeToMiraiCode());
        return matcher.find();
    }

    public static void spotPause(MessageEvent event) {
        MessageChain message = event.getMessage();
        String contentToString = message.contentToString();
        Contact subject = event.getSubject();
        Bot thisBot = event.getBot();
        User sender = event.getSender();
        long botQq = 0L;
        for (SingleMessage singleMessage : message) {
            if (!(singleMessage instanceof At)) continue;
            botQq = ((At)singleMessage).getTarget();
        }
        Bot bot = Bot.getInstance((long)botQq);
        if (bot != thisBot) {
            return;
        }
        String[] split = contentToString.split(" +");
        int num = 1;
        if (split.length == 3) {
            num = Integer.parseInt(split[2]);
        }
        String mark = botQq + "." + sender.getId();
        map.put(mark, num);
        subject.sendMessage(bot.getNick() + "(" + botQq + ")\u5f00\u59cb\u5ffd\u7565\u63a5\u4e0b\u6765\u4f60\u7684 " + num + " \u6761\u6d88\u606f");
    }

    public static boolean isPause(MessageEvent event) {
        Bot bot = event.getBot();
        User sender = event.getSender();
        String mark = bot.getId() + "." + sender.getId();
        if (map.containsKey(mark)) {
            Integer integer = map.get(mark);
            HuYanSession.log.info("integer-" + integer);
            if (integer > 0) {
                map.put(mark, integer - 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean mateScope(MessageEvent event, Scope scope) {
        Bot bot = event.getBot();
        long group = event.getSubject().getId();
        Map<Integer, GroupList> groupListMap = StaticData.getGroupListMap(bot);
        if (scope.getGroupInfo()) {
            GroupList groupList = groupListMap.get(scope.getListId());
            List<GroupInfo> groupNumbers = groupList.getGroups();
            for (GroupInfo aLong : groupNumbers) {
                if (group != aLong.getGroupId()) continue;
                return true;
            }
        } else {
            if (scope.getGlobal()) {
                return true;
            }
            long l = scope.getGroupNumber();
            return l == group;
        }
        return false;
    }

    public static boolean mateScope(Bot bot, Group group, Scope scope) {
        Map<Integer, GroupList> groupListMap = StaticData.getGroupListMap(bot);
        if (scope.getGroupInfo()) {
            GroupList groupList = groupListMap.get(scope.getListId());
            List<GroupInfo> groupNumbers = groupList.getGroups();
            for (GroupInfo aLong : groupNumbers) {
                if (group.getId() != aLong.getGroupId()) continue;
                return true;
            }
        } else {
            if (scope.getGlobal()) {
                return true;
            }
            long l = scope.getGroupNumber();
            return l == group.getId();
        }
        return false;
    }

    public static boolean mateMate(String code, Mate mate, String key) {
        switch (mate) {
            case ACCURATE: {
                if (!code.equals(key)) break;
                return true;
            }
            case VAGUE: {
                if (!code.contains(key)) break;
                return true;
            }
            case START: {
                if (!code.startsWith(key)) break;
                return true;
            }
            case END: {
                if (!code.endsWith(key)) break;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static MessageEvent getNextMessageEventFromUser(User user) {
        EventChannel channel = GlobalEventChannel.INSTANCE.parentScope((CoroutineScope)HuYanSession.INSTANCE).filterIsInstance(MessageEvent.class).filter(event -> event.getSender().getId() == user.getId());
        CompletableFuture future = new CompletableFuture();
        channel.subscribeOnce(MessageEvent.class, (CoroutineContext)EmptyCoroutineContext.INSTANCE, ConcurrencyKind.LOCKED, EventPriority.HIGH, event -> {
            event.intercept();
            future.complete(event);
        });
        MessageEvent event2 = null;
        try {
            event2 = (MessageEvent)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            HuYanSession.log.error("\u83b7\u53d6\u4e0b\u4e00\u6761\u6d88\u606f\u51fa\u9519!", (Throwable)e);
        }
        assert (event2 != null);
        return event2;
    }

    @NotNull
    public static Mate getMate(int mateType) {
        switch (mateType) {
            case 2: {
                return Mate.VAGUE;
            }
            case 3: {
                return Mate.START;
            }
            case 4: {
                return Mate.END;
            }
        }
        return Mate.ACCURATE;
    }
}

