/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.entity;

import cn.chahuyun.entity.Scope;
import cn.chahuyun.enums.Mate;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;

@Entity
@Table(name="Session")
public class SessionInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private long bot;
    private int type;
    private boolean dynamic;
    private String term;
    @Column(length=10240)
    private String reply;
    private int mateInter;
    private String scopeMark;
    @Transient
    private Mate mate;
    @Transient
    private Scope scope;

    public SessionInfo() {
    }

    public SessionInfo(long bot, int type, String term, String reply, Mate mate, Scope scope, boolean dynamic) {
        this.bot = bot;
        this.type = type;
        this.term = term;
        this.reply = reply;
        this.mateInter = mate.getMateType();
        this.mate = mate;
        this.scope = scope;
        this.dynamic = dynamic;
        this.scopeMark = bot + "." + scope.isGlobal() + "." + scope.isGroupInfo() + "." + scope.getGroupNumber() + "." + scope.getListId();
    }

    public SessionInfo(int id, long bot, int type, String term, String reply, Mate mate, Scope scope) {
        this.id = id;
        this.bot = bot;
        this.type = type;
        this.term = term;
        this.mateInter = mate.getMateType();
        this.reply = reply;
        this.mate = mate;
        this.scope = scope;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getBot() {
        return this.bot;
    }

    public void setBot(long bot) {
        this.bot = bot;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getReply() {
        return this.reply;
    }

    public void setReply(String reply) {
        this.reply = reply;
    }

    public String getScopeMark() {
        return this.scopeMark;
    }

    public void setScopeMark(String scopeMark) {
        this.scopeMark = scopeMark;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Mate getMate() {
        return ShareUtils.getMate(this.mateInter);
    }

    public void setMate(Mate mate) {
        this.mate = mate;
        this.mateInter = mate.getMateType();
    }

    public Scope getScope() {
        return ScopeUtil.getScope(this.scopeMark);
    }

    public void setScope(Scope scope) {
        this.scopeMark = this.bot + "." + scope.isGlobal() + "." + scope.isGroupInfo() + "." + scope.getGroupNumber() + "." + scope.getListId();
        this.scope = scope;
    }

    public int getMateInter() {
        return this.mateInter;
    }

    public void setMateInter(int mateInter) {
        this.mateInter = mateInter;
    }

    public String toString() {
        return "Session{id=" + this.id + ", bot=" + this.bot + ", type=" + this.type + ", key='" + this.term + "', reply='" + this.reply + "', mate=" + this.mate + ", scope=" + this.scope + "}";
    }
}

