/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.entity;

import cn.chahuyun.entity.ManySession;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.utils.ScopeUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="QuartzInfo")
public class QuartzInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private long bot;
    private String name;
    private String cronString;
    private boolean dynamic;
    private boolean other;
    @Column(length=10240)
    private String reply;
    private boolean status;
    private boolean polling;
    private boolean random;
    private int pollingNumber;
    private String scopeMark;
    @Transient
    private Scope scope;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=ManySession.class)
    @JoinColumn(name="QuartzMessage_ID")
    private List<ManySession> manySessions = new ArrayList<ManySession>();

    public QuartzInfo() {
    }

    public QuartzInfo(long bot, String name, String cronString, boolean dynamic, boolean other, String reply, boolean polling, boolean random, Scope scope) {
        this.bot = bot;
        this.name = name;
        this.cronString = cronString;
        this.dynamic = dynamic;
        this.other = other;
        this.reply = reply;
        this.polling = polling;
        this.random = random;
        this.pollingNumber = 0;
        this.status = false;
        this.scopeMark = bot + "." + scope.isGlobal() + "." + scope.isGroupInfo() + "." + scope.getGroupNumber() + "." + scope.getListId();
        this.scope = scope;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getBot() {
        return this.bot;
    }

    public void setBot(long bot) {
        this.bot = bot;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCronString() {
        return this.cronString;
    }

    public boolean isPolling() {
        return this.polling;
    }

    public void setPolling(boolean polling) {
        this.polling = polling;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public int getPollingNumber() {
        return this.pollingNumber;
    }

    public void setPollingNumber(int pollingNumber) {
        this.pollingNumber = pollingNumber;
    }

    public void setCronString(String cronString) {
        this.cronString = cronString;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isOther() {
        return this.other;
    }

    public void setOther(boolean other) {
        this.other = other;
    }

    public String getReply() {
        return this.reply;
    }

    public void setReply(String reply) {
        this.reply = reply;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getScopeMark() {
        return this.scopeMark;
    }

    public void setScopeMark(String mark) {
        this.scopeMark = mark;
    }

    public Scope getScope() {
        return ScopeUtil.getScope(this.scopeMark);
    }

    public void setScope(Scope scope) {
        this.scopeMark = this.bot + "." + scope.isGlobal() + "." + scope.isGroupInfo() + "." + scope.getGroupNumber() + "." + scope.getListId();
        this.scope = scope;
    }

    public List<ManySession> getManySessions() {
        return this.manySessions;
    }

    public void setManySessions(List<ManySession> manySessions) {
        this.manySessions = manySessions;
    }
}

