/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.entity;

import cn.chahuyun.entity.ManySession;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.enums.Mate;
import cn.chahuyun.utils.MateUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="ManySessionInfo")
public class ManySessionInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private long bot;
    private boolean random;
    private int pollingNumber;
    private String trigger;
    private int mateType;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=ManySession.class)
    @JoinColumn(name="ManySession_ID")
    private List<ManySession> manySessions = new ArrayList<ManySession>();
    private String scopeMark;
    @Transient
    private Mate mate;
    @Transient
    private Scope scope;

    public ManySessionInfo() {
    }

    public ManySessionInfo(long bot, boolean random, int pollingNumber, String trigger, int mateType, Scope scopeInfo) {
        this.bot = bot;
        this.random = random;
        this.pollingNumber = pollingNumber;
        this.trigger = trigger;
        this.mateType = mateType;
        this.mate = MateUtil.getMate(mateType);
        this.scopeMark = bot + "." + scopeInfo.isGlobal() + "." + scopeInfo.isGroupInfo() + "." + scopeInfo.getGroupNumber() + "." + scopeInfo.getListId();
        this.scope = scopeInfo;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getBot() {
        return this.bot;
    }

    public void setBot(long bot) {
        this.bot = bot;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public int getPollingNumber() {
        return this.pollingNumber;
    }

    public void setPollingNumber(int pollingNumber) {
        this.pollingNumber = pollingNumber;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public int getMateType() {
        return this.mateType;
    }

    public void setMateType(int mateType) {
        this.mateType = mateType;
    }

    public List<ManySession> getManySessions() {
        return this.manySessions;
    }

    public void setManySessions(List<ManySession> manySessions) {
        this.manySessions = manySessions;
    }

    public String getScopeMark() {
        return this.scopeMark;
    }

    public void setScopeMark(String scopeMark) {
        this.scopeMark = scopeMark;
    }

    public Mate getMate() {
        return ShareUtils.getMate(this.mateType);
    }

    public void setMate(Mate mate) {
        this.mate = mate;
        this.mateType = mate.getMateType();
    }

    public Scope getScope() {
        return ScopeUtil.getScope(this.scopeMark);
    }

    public void setScope(Scope scopeInfo) {
        this.scopeMark = this.bot + "." + scopeInfo.isGlobal() + "." + scopeInfo.isGroupInfo() + "." + scopeInfo.getGroupNumber() + "." + scopeInfo.getListId();
        this.scope = scopeInfo;
    }
}

