/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.entity;

import cn.chahuyun.entity.Scope;
import cn.chahuyun.entity.WelcomeMessage;
import cn.chahuyun.utils.ScopeUtil;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="GroupWelcomeInfo")
public class GroupWelcomeInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private long bot;
    private boolean random;
    private int pollingNumber;
    private int randomMark;
    private String scopeMark;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=WelcomeMessage.class)
    @JoinColumn(name="WelcomeMessage_id")
    private List<WelcomeMessage> welcomeMessages = new ArrayList<WelcomeMessage>();
    @Transient
    private Scope scope;

    public GroupWelcomeInfo() {
    }

    public GroupWelcomeInfo(long bot, boolean random, int pollingNumber, int randomMark, Scope scopeInfo) {
        this.bot = bot;
        this.random = random;
        this.pollingNumber = pollingNumber;
        this.randomMark = randomMark;
        this.scopeMark = bot + "." + scopeInfo.isGlobal() + "." + scopeInfo.isGroupInfo() + "." + scopeInfo.getGroupNumber() + "." + scopeInfo.getListId();
        this.scope = scopeInfo;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getBot() {
        return this.bot;
    }

    public void setBot(long bot) {
        this.bot = bot;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public int getPollingNumber() {
        return this.pollingNumber;
    }

    public void setPollingNumber(int pollingNumber) {
        this.pollingNumber = pollingNumber;
    }

    public String getScopeMark() {
        return this.scopeMark;
    }

    public void setScopeMark(String scopeMark) {
        this.scopeMark = scopeMark;
    }

    public List<WelcomeMessage> getWelcomeMessages() {
        return this.welcomeMessages;
    }

    public void setWelcomeMessages(List<WelcomeMessage> welcomeMessages) {
        this.welcomeMessages = welcomeMessages;
    }

    public int getRandomMark() {
        return this.randomMark;
    }

    public void setRandomMark(int randomMark) {
        this.randomMark = randomMark;
    }

    public Scope getScope() {
        return ScopeUtil.getScope(this.scopeMark);
    }

    public void setScope(Scope scopeInfo) {
        this.scopeMark = this.bot + "." + scopeInfo.isGlobal() + "." + scopeInfo.isGroupInfo() + "." + scopeInfo.getGroupNumber() + "." + scopeInfo.getListId();
        this.scope = scopeInfo;
    }
}

