/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.dialogue;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.controller.GroupWelcomeInfoAction;
import cn.chahuyun.controller.ManySessionAction;
import cn.chahuyun.entity.GroupWelcomeInfo;
import cn.chahuyun.entity.ManySession;
import cn.chahuyun.entity.ManySessionInfo;
import cn.chahuyun.entity.SessionInfo;
import cn.chahuyun.entity.WelcomeMessage;
import cn.chahuyun.manage.GroupManager;
import cn.chahuyun.utils.DynamicMessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import net.mamoe.mirai.contact.BotIsBeingMutedException;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MessageTooLargeException;
import net.mamoe.mirai.event.events.EventCancelledException;
import net.mamoe.mirai.event.events.GroupEvent;
import net.mamoe.mirai.event.events.MemberJoinEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.SingleMessage;

public class Dialogue {
    public static final Dialogue INSTANCE = new Dialogue();

    private Dialogue() {
    }

    private void test(MessageEvent event) {
        Image image;
        for (SingleMessage singleMessage : event.getMessage()) {
            if (!(singleMessage instanceof Image)) continue;
            byte[] byArray = ((Image)singleMessage).getMd5();
        }
        try {
            image = Contact.uploadImage((Contact)event.getSubject(), (InputStream)new URL("").openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        event.getSubject().sendMessage((Message)image);
    }

    public void dialogueSession(MessageEvent event, SessionInfo sessionInfo) {
        Contact subject = event.getSubject();
        if (sessionInfo.getType() == 5) {
            subject.sendMessage((Message)MessageChain.deserializeFromJsonString((String)sessionInfo.getReply()));
        } else if (sessionInfo.isDynamic()) {
            MessageChain messages = DynamicMessageUtil.parseMessageParameter(event, sessionInfo.getReply(), sessionInfo);
            if (messages == null) {
                return;
            }
            subject.sendMessage((Message)messages);
        } else {
            subject.sendMessage((Message)MiraiCode.deserializeMiraiCode((String)sessionInfo.getReply()));
        }
    }

    public void dialogueSession(MessageEvent event, ManySessionInfo session) {
        int pollingNumber;
        Contact subject = event.getSubject();
        List<ManySession> manySessions = session.getManySessions();
        int size = manySessions.size();
        ManySession reply = session.isRandom() ? manySessions.get((int)(Math.random() * (double)size)) : manySessions.get((pollingNumber = session.getPollingNumber()) < size ? pollingNumber : pollingNumber % size);
        if (reply.isOther()) {
            subject.sendMessage((Message)MessageChain.deserializeFromJsonString((String)reply.getReply()));
        } else if (reply.isDynamic()) {
            MessageChain messages = DynamicMessageUtil.parseMessageParameter(event, reply.getReply(), session);
            if (messages == null) {
                return;
            }
            subject.sendMessage((Message)messages);
        } else {
            subject.sendMessage((Message)MiraiCode.deserializeMiraiCode((String)reply.getReply()));
        }
        ManySessionAction.increase(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dialogueSession(MemberJoinEvent group, GroupWelcomeInfo welcomeInfo) {
        Group subject = group.getGroup();
        String mark = group.getGroup().getId() + "." + group.getMember().getId();
        try {
            WelcomeMessage welcomeMessage;
            List<WelcomeMessage> welcomeMessages = welcomeInfo.getWelcomeMessages();
            int size = welcomeMessages.size();
            if (welcomeInfo.isRandom()) {
                int index = (int)(Math.random() * (double)size);
                welcomeMessage = welcomeMessages.get(index);
            } else {
                int pollingNumber = welcomeInfo.getPollingNumber();
                welcomeMessage = welcomeMessages.get(pollingNumber < size ? pollingNumber : pollingNumber % size);
                GroupWelcomeInfoAction.increase(welcomeInfo);
            }
            switch (welcomeMessage.getType()) {
                case 0: {
                    subject.sendMessage((Message)MiraiCode.deserializeMiraiCode((String)welcomeMessage.getWelcomeMessage()));
                    return;
                }
                case 1: {
                    MessageChain messages = DynamicMessageUtil.parseMessageParameter((GroupEvent)group, welcomeMessage.getWelcomeMessage(), welcomeInfo, GroupManager.map.get(mark));
                    assert (messages != null);
                    subject.sendMessage((Message)messages);
                    return;
                }
                case 2: {
                    subject.sendMessage((Message)MessageChain.deserializeFromJsonString((String)welcomeMessage.getWelcomeMessage()));
                    return;
                }
            }
            return;
        }
        catch (EventCancelledException e) {
            HuYanSession.log.error("\u53d1\u9001\u6d88\u606f\u88ab\u53d6\u6d88:", (Throwable)e);
            return;
        }
        catch (BotIsBeingMutedException e) {
            HuYanSession.log.error("\u4f60\u7684\u673a\u5668\u4eba\u88ab\u7981\u8a00:", (Throwable)e);
            return;
        }
        catch (MessageTooLargeException e) {
            HuYanSession.log.error("\u53d1\u9001\u6d88\u606f\u8fc7\u957f:", (Throwable)e);
            return;
        }
        catch (IllegalArgumentException e) {
            HuYanSession.log.error("\u53d1\u9001\u6d88\u606f\u4e3a\u7a7a:", (Throwable)e);
            return;
        }
        catch (Exception e) {
            HuYanSession.log.error("\u53d1\u9001\u6d88\u606f\u9519\u8bef!!!!:", (Throwable)e);
            return;
        }
        finally {
            GroupManager.map.remove(mark);
        }
    }
}

