/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.ManySession;
import cn.chahuyun.entity.ManySessionInfo;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.enums.Mate;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ListUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.ForwardMessage;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageKey;
import net.mamoe.mirai.message.data.PlainText;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class ManySessionAction {
    public static void init(boolean type) {
        List manySessionInfos;
        block7: {
            manySessionInfos = null;
            try {
                manySessionInfos = (List)HibernateUtil.factory.fromTransaction(session -> {
                    HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                    JpaCriteriaQuery query = builder.createQuery(ManySessionInfo.class);
                    JpaRoot from = query.from(ManySessionInfo.class);
                    query.select((Selection)from);
                    return session.createQuery((CriteriaQuery)query).list();
                });
            }
            catch (Exception e) {
                if (!type) break block7;
                HuYanSession.log.warning("\u591a\u8bcd\u6761\u52a0\u8f7d\u6d88\u606f\u51fa\u9519!", (Throwable)e);
                return;
            }
        }
        HashMap<Long, Map<String, ManySessionInfo>> map = null;
        assert (manySessionInfos != null);
        for (final ManySessionInfo manySessionInfo : manySessionInfos) {
            if (map == null) {
                map = new HashMap<Long, Map<String, ManySessionInfo>>(){
                    {
                        this.put(manySessionInfo.getBot(), new HashMap<String, ManySessionInfo>(){
                            {
                                this.put(manySessionInfo.getTrigger(), manySessionInfo);
                            }
                        });
                    }
                };
            }
            if (!map.containsKey(manySessionInfo.getBot())) continue;
            ((Map)map.get(manySessionInfo.getBot())).put(manySessionInfo.getTrigger(), manySessionInfo);
        }
        StaticData.setManySession(map);
        if (type) {
            HuYanSession.log.info("\u591a\u8bcd\u6761\u6d88\u606f\u521d\u59cb\u5316\u6210\u529f!");
        }
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            HuYanSession.log.info("\u591a\u8bcd\u6761\u6570\u636e\u66f4\u65b0\u6210\u529f!");
        }
    }

    public void addManySession(MessageEvent event) {
        String[] split;
        boolean isRandom;
        Mate mate;
        Scope scope;
        Bot bot = event.getBot();
        Contact subject = event.getSubject();
        User user = event.getSender();
        subject.sendMessage("\u8bf7\u53d1\u9001\u591a\u8bcd\u6761\u7684\u89e6\u53d1\u8bcd\uff1a");
        MessageEvent triggerEvent = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(triggerEvent)) {
            return;
        }
        String code = triggerEvent.getMessage().serializeToMiraiCode();
        boolean editOrAdd = StaticData.getManySession(bot).containsKey(code);
        ManySessionInfo manySessionInfo = null;
        if (editOrAdd) {
            manySessionInfo = StaticData.getManySession(bot).get(code);
            scope = manySessionInfo.getScope();
            mate = manySessionInfo.getMate();
            isRandom = manySessionInfo.isRandom();
        } else {
            scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), -1);
            mate = Mate.ACCURATE;
            isRandom = false;
        }
        subject.sendMessage("\u8bf7\u53d1\u9001\u53c2\u6570(\u4e2d\u95f4\u4ee5\u7a7a\u683c\u9694\u5f00)");
        MessageEvent paramEvent = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(paramEvent)) {
            return;
        }
        String[] stringArray = split = paramEvent.getMessage().serializeToMiraiCode().split(" +");
        int n = stringArray.length;
        block30: for (int i = 0; i < n; ++i) {
            String param;
            switch (param = stringArray[i]) {
                case "-1": 
                case "\u5f53\u524d": {
                    scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), -1);
                    continue block30;
                }
                case "0": 
                case "\u5168\u5c40": {
                    scope = new Scope(bot.getId(), "\u5168\u5c40", true, false, subject.getId(), -1);
                    continue block30;
                }
                case "1": 
                case "\u7cbe\u51c6": {
                    mate = Mate.ACCURATE;
                    continue block30;
                }
                case "2": 
                case "\u6a21\u7cca": {
                    mate = Mate.VAGUE;
                    continue block30;
                }
                case "3": 
                case "\u5934\u90e8": {
                    mate = Mate.START;
                    continue block30;
                }
                case "4": 
                case "\u7ed3\u5c3e": {
                    mate = Mate.END;
                    continue block30;
                }
                case "sj": 
                case "\u968f\u673a": {
                    isRandom = true;
                    continue block30;
                }
                case "lx": 
                case "\u8f6e\u8be2": {
                    isRandom = false;
                    continue block30;
                }
                default: {
                    String listPattern = "gr\\d+|\u7fa4\u7ec4\\d+";
                    if (!Pattern.matches(listPattern, param)) continue block30;
                    int listId = Integer.parseInt(param.substring(2));
                    if (ListUtil.isContainsList(bot, listId)) {
                        subject.sendMessage("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728!");
                        return;
                    }
                    scope = new Scope(bot.getId(), "\u7fa4\u7ec4" + listId, false, true, subject.getId(), listId);
                }
            }
        }
        if (editOrAdd) {
            manySessionInfo.setScope(scope);
            manySessionInfo.setMate(mate);
            manySessionInfo.setRandom(isRandom);
        } else {
            manySessionInfo = new ManySessionInfo(bot.getId(), isRandom, 0, code, mate.getMateType(), scope);
        }
        List<ManySession> sessionList = manySessionInfo.getManySessions();
        boolean isQuit = false;
        while (!isQuit) {
            subject.sendMessage("\u8bf7\u53d1\u9001\u591a\u8bcd\u6761\u56de\u590d\u6d88\u606f:");
            MessageEvent nextEvent = ShareUtils.getNextMessageEventFromUser(user);
            if (ShareUtils.isQuit(nextEvent)) {
                return;
            }
            MessageChain nextEventMessage = nextEvent.getMessage();
            String miraiCode = nextEventMessage.serializeToMiraiCode();
            if (miraiCode.equals("\uff01\uff01") || miraiCode.equals("!!")) {
                isQuit = true;
                continue;
            }
            if ((miraiCode.equals("\uff01") || miraiCode.equals("!")) && sessionList.size() > 2) {
                sessionList.remove(sessionList.size() - 1);
                subject.sendMessage("\u5220\u9664\u4e0a\u4e00\u6761\u56de\u590d\u6d88\u606f\u6210\u529f\uff01");
                continue;
            }
            boolean dynamic = false;
            Pattern compile = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
            if (compile.matcher(miraiCode).find() || compile.matcher(miraiCode).find()) {
                dynamic = true;
            }
            boolean other = false;
            if (nextEventMessage.contains((MessageKey)ForwardMessage.Key) || nextEventMessage.contains((MessageKey)Audio.Key)) {
                dynamic = false;
                other = true;
                miraiCode = MessageChain.serializeToJsonString((MessageChain)nextEventMessage);
            }
            ManySession manySession = new ManySession(bot.getId(), dynamic, other, miraiCode);
            sessionList.add(manySession);
            subject.sendMessage("\u6dfb\u52a0\u6210\u529f!");
        }
        try {
            Scope finalScope = scope;
            ManySessionInfo finalManySessionInfo = manySessionInfo;
            HibernateUtil.factory.fromTransaction(session -> {
                if (ScopeUtil.isScopeEmpty(finalScope)) {
                    session.persist((Object)finalScope);
                }
                session.merge((Object)finalManySessionInfo);
                return 0;
            });
        }
        catch (Exception e) {
            if (editOrAdd) {
                subject.sendMessage("\u591a\u8bcd\u6761\u4fee\u6539\u5931\u8d25!");
            } else {
                subject.sendMessage("\u591a\u8bcd\u6761\u4fdd\u5b58\u5931\u8d25!");
            }
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return;
        }
        if (editOrAdd) {
            subject.sendMessage("\u591a\u8bcd\u6761\u4fee\u6539\u6210\u529f!");
        } else {
            subject.sendMessage("\u591a\u8bcd\u6761\u4fdd\u5b58\u6210\u529f!");
        }
        ManySessionAction.init(false);
    }

    public void queryManySession(MessageEvent event) {
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        ManySessionAction.init(false);
        Map<String, ManySessionInfo> manySession = StaticData.getManySession(bot);
        if (manySession == null || manySession.isEmpty()) {
            subject.sendMessage("\u6ca1\u6709\u591a\u8bcd\u6761\u6d88\u606f!");
            return;
        }
        ForwardMessageBuilder builder = new ForwardMessageBuilder(subject);
        builder.add((UserOrBot)bot, (Message)new PlainText("\u4ee5\u4e0b\u662f\u6240\u6709\u591a\u8bcd\u6761\u6d88\u606f\u2193"));
        for (ManySessionInfo value : manySession.values()) {
            List<ManySession> manySessions = value.getManySessions();
            MessageChainBuilder messages = new MessageChainBuilder();
            messages.add(String.format("\u591a\u8bcd\u6761\u7f16\u53f7:%d%n\u89e6\u53d1\u65b9\u5f0f:%s%n\u89e6\u53d1\u5185\u5bb9:%s%n", value.getId(), value.getMate().getMateName(), value.getTrigger()));
            messages.add(String.format("\u4f5c\u7528\u57df:%s%n", value.getScope().getScopeName()));
            messages.add(String.format("\u5f53\u524d\u7fa4\u662f\u5426\u89e6\u53d1:%s", ShareUtils.mateScope(event, value.getScope()) ? "\u662f" : "\u5426"));
            builder.add((UserOrBot)bot, (Message)messages.build());
            ForwardMessageBuilder messageBuilder = new ForwardMessageBuilder(subject);
            for (ManySession session : manySessions) {
                if (session.isOther()) {
                    messageBuilder.add((UserOrBot)bot, (Message)new PlainText(String.format("\u7f16\u53f7:%s", session.getId())));
                    MessageChain singleMessages = MessageChain.deserializeFromJsonString((String)session.getReply());
                    messageBuilder.add((UserOrBot)bot, (Message)singleMessages);
                    continue;
                }
                MessageChainBuilder messageChainBuilder = new MessageChainBuilder();
                messageChainBuilder.add(String.format("\u7f16\u53f7:%s%n", session.getId()));
                messageChainBuilder.add((Message)MiraiCode.deserializeMiraiCode((String)session.getReply()));
                messageBuilder.add((UserOrBot)bot, (Message)messageChainBuilder.build());
            }
            builder.add((UserOrBot)bot, (Message)messageBuilder.build());
        }
        subject.sendMessage((Message)builder.build());
    }

    public void deleteManySession(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        ManySessionAction.init(false);
        String[] split = code.split("[\uff1a:]")[1].split(" +");
        int keyId = Integer.parseInt(split[0]);
        Map<String, ManySessionInfo> manySession = StaticData.getManySession(bot);
        ManySessionInfo manySessionInfo = null;
        for (ManySessionInfo value : manySession.values()) {
            if (value.getId() != keyId) continue;
            manySessionInfo = value;
        }
        if (manySessionInfo == null) {
            subject.sendMessage("\u6c92\u6709\u627e\u5230\u5bf9\u5e94\u7684\u591a\u8bcd\u6761!");
            return;
        }
        boolean deleteType = split.length == 1;
        List<ManySession> manySessions = manySessionInfo.getManySessions();
        List<ManySession> manySessionList = manySessionInfo.getManySessions();
        if (split.length > 1) {
            for (String value : split) {
                int s = 0;
                try {
                    s = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    HuYanSession.log.warning("\u5220\u9664\u591a\u8bcd\u6761-id\u4e2d\u542b\u6709\u4e0d\u662f\u6570\u503c\u7684\u5b57\u7b26!");
                }
                int finalS = s;
                manySessionList = manySessionList.stream().filter(it -> it.getId() != finalS).collect(Collectors.toList());
            }
        }
        boolean deleteMessageType = manySessions.size() > manySessionList.size();
        ManySessionInfo finalManySessionInfo = manySessionInfo;
        List<ManySession> finalManySessionList = manySessionList;
        HibernateUtil.factory.fromTransaction(session -> {
            if (deleteType) {
                session.remove((Object)finalManySessionInfo);
            } else if (deleteMessageType) {
                finalManySessionInfo.setManySessions(finalManySessionList);
                session.merge((Object)finalManySessionInfo);
            }
            return 0;
        });
        if (deleteType) {
            subject.sendMessage(String.format("\u5220\u9664\u591a\u8bcd\u6761 %s \u6210\u529f\uff01", manySessionInfo.getTrigger()));
        } else if (deleteMessageType) {
            subject.sendMessage(String.format("\u5220\u9664\u591a\u8bcd\u6761 %s \u4e0b\u7684\u56de\u590d\u6210\u529f!", manySessionInfo.getTrigger()));
        } else {
            subject.sendMessage("\u6ca1\u6709\u627e\u5230\u8981\u5220\u9664\u7684\u591a\u8bcd\u6761\u56de\u590d\uff01");
        }
        ManySessionAction.init(false);
    }

    public static void increase(ManySessionInfo sessionInfo) {
        sessionInfo.setPollingNumber(sessionInfo.getPollingNumber() + 1);
        HibernateUtil.factory.fromTransaction(session -> (ManySessionInfo)session.merge((Object)sessionInfo));
    }
}

