/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.entity.GroupWelcomeInfo;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.entity.WelcomeMessage;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ListUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.ForwardMessage;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageKey;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class GroupWelcomeInfoAction {
    public void addGroupWelcomeInfo(MessageEvent event) {
        GroupWelcomeInfo groupWelcomeInfo;
        String[] split;
        Contact subject = event.getSubject();
        User user = event.getSender();
        Bot bot = event.getBot();
        subject.sendMessage("\u8bf7\u8f93\u5165\u6b22\u8fce\u6d88\u606f:");
        MessageEvent nextMessageEventFromUser = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextMessageEventFromUser)) {
            return;
        }
        MessageChain message = nextMessageEventFromUser.getMessage();
        String value = message.serializeToMiraiCode();
        int type = 0;
        Pattern compile = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
        if (compile.matcher(value).find()) {
            type = 1;
        }
        if (message.contains((MessageKey)ForwardMessage.Key) || message.contains((MessageKey)Audio.Key)) {
            type = 2;
            value = MessageChain.serializeToJsonString((MessageChain)message);
        }
        int randomMark = (int)(Math.random() * 100.0);
        boolean random = false;
        subject.sendMessage("\u8bf7\u53d1\u9001\u53c2\u6570(\u4e00\u6b21\u53d1\u9001\uff0c\u591a\u53c2\u6570\u4e2d\u95f4\u9694\u5f00):");
        MessageEvent nextParamMessageEventFromUser = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextParamMessageEventFromUser)) {
            return;
        }
        String param = nextParamMessageEventFromUser.getMessage().serializeToMiraiCode();
        Scope scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), 0);
        String[] stringArray = split = param.split(" +");
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "sj": 
                case "\u968f\u673a": {
                    random = true;
                    continue block14;
                }
                case "0": 
                case "\u5168\u5c40": {
                    scope = new Scope(bot.getId(), "\u5168\u5c40", true, false, subject.getId(), -1);
                    continue block14;
                }
                default: {
                    String listPattern = "gr\\d+|\u7fa4\u7ec4\\d+";
                    if (!Pattern.matches(listPattern, s)) continue block14;
                    int listId = Integer.parseInt(s.substring(2));
                    if (ListUtil.isContainsList(bot, listId)) {
                        subject.sendMessage("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728!");
                        return;
                    }
                    scope = new Scope(bot.getId(), "\u7fa4\u7ec4" + listId, false, true, subject.getId(), listId);
                }
            }
        }
        List welcomeInfoList = null;
        try {
            welcomeInfoList = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(GroupWelcomeInfo.class);
                JpaRoot from = query.from(GroupWelcomeInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566!", (Throwable)e);
        }
        if (welcomeInfoList == null || welcomeInfoList.isEmpty()) {
            groupWelcomeInfo = new GroupWelcomeInfo(bot.getId(), random, 0, randomMark, scope);
        } else {
            Scope finalScope1 = scope;
            Optional<GroupWelcomeInfo> optional = welcomeInfoList.stream().filter(it -> it.getScopeMark().equals(finalScope1.getId())).findFirst();
            groupWelcomeInfo = optional.isPresent() ? optional.get() : new GroupWelcomeInfo(bot.getId(), random, 0, randomMark, scope);
        }
        List<WelcomeMessage> welcomeMessages = groupWelcomeInfo.getWelcomeMessages();
        WelcomeMessage welcomeMessage = new WelcomeMessage(bot.getId(), randomMark, type, value);
        if (welcomeMessages.contains(welcomeMessage)) {
            subject.sendMessage("\u8fd9\u6761\u6b22\u8fce\u6d88\u606f\u5df2\u7ecf\u5b58\u5728");
            return;
        }
        welcomeMessages.add(welcomeMessage);
        groupWelcomeInfo.setWelcomeMessages(welcomeMessages);
        groupWelcomeInfo.setScope(scope);
        try {
            Scope finalScope = scope;
            HibernateUtil.factory.fromTransaction(session -> {
                if (ScopeUtil.isScopeEmpty(finalScope)) {
                    session.persist((Object)finalScope);
                }
                session.merge((Object)groupWelcomeInfo);
                return 0;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566\uff01", (Throwable)e);
            subject.sendMessage("\u6b22\u8fce\u8bcd\u4fdd\u5b58\u5931\u8d25!");
            return;
        }
        subject.sendMessage("\u6b22\u8fce\u8bcd\u4fdd\u5b58\u6210\u529f!");
    }

    public void queryGroupWelcomeInfo(MessageEvent event) {
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        List welcomeInfoList = null;
        try {
            welcomeInfoList = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(GroupWelcomeInfo.class);
                JpaRoot from = query.from(GroupWelcomeInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                List list = session.createQuery((CriteriaQuery)query).list();
                for (GroupWelcomeInfo info : list) {
                    if (info.getScope() != null) continue;
                    info.setScope(Objects.requireNonNull(ScopeUtil.getScope(info.getScopeMark())));
                }
                return list;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566!", (Throwable)e);
        }
        if (welcomeInfoList == null || welcomeInfoList.isEmpty()) {
            subject.sendMessage("\u6b22\u8fce\u8bcd\u4e3a\u7a7a");
            return;
        }
        ForwardMessageBuilder builder = new ForwardMessageBuilder(subject);
        builder.add((UserOrBot)bot, (Message)new PlainText("\u4ee5\u4e0b\u672c\u662fbot\u6240\u6709\u7fa4\u6b22\u8fce\u8bcd\u2193"));
        for (GroupWelcomeInfo welcomeInfo : welcomeInfoList) {
            List<WelcomeMessage> welcomeMessages = welcomeInfo.getWelcomeMessages();
            Scope scope = welcomeInfo.getScope();
            MessageChainBuilder messages = new MessageChainBuilder();
            messages.add((SingleMessage)new PlainText("\u6b22\u8fce\u8bcd\u96c6\u5408\u7f16\u53f7:" + welcomeInfo.getRandomMark()));
            messages.add((SingleMessage)new PlainText("\n\u4f5c\u7528\u65b9\u5f0f:" + scope.getScopeName()));
            if (scope.isGroupInfo()) {
                messages.add((SingleMessage)new PlainText("\n\u7fa4\u7ec4\u7f16\u53f7:" + scope.getListId()));
            } else if (!scope.isGlobal()) {
                messages.add((SingleMessage)new PlainText("\n\u7fa4\u53f7:" + scope.getGroupNumber()));
            }
            messages.add((SingleMessage)new PlainText("\n\u89e6\u53d1\u65b9\u5f0f:" + (welcomeInfo.isRandom() ? "\u968f\u673a" : "\u8f6e\u8be2")));
            builder.add((UserOrBot)bot, (Message)messages.build());
            ForwardMessageBuilder forwardMsgBuilder = new ForwardMessageBuilder(subject);
            for (WelcomeMessage welcomeMessage : welcomeMessages) {
                forwardMsgBuilder.add((UserOrBot)bot, (Message)new PlainText("id:" + welcomeMessage.getId() + "\n==>").plus(MiraiCode.deserializeMiraiCode((String)welcomeMessage.getWelcomeMessage())));
            }
            builder.add((UserOrBot)bot, (Message)forwardMsgBuilder.build());
        }
        subject.sendMessage((Message)builder.build());
    }

    public void deleteGroupWelcomeInfo(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        String[] split = code.split("[:\uff1a]")[1].split(" +");
        int key = Integer.parseInt(split[0]);
        int toKey = 0;
        if (split.length > 1) {
            toKey = Integer.parseInt(split[1]);
        }
        GroupWelcomeInfo groupWelcomeInfo = null;
        try {
            groupWelcomeInfo = (GroupWelcomeInfo)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(GroupWelcomeInfo.class);
                JpaRoot from = query.from(GroupWelcomeInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                query.where((Expression)builder.equal((Expression)from.get("randomMark"), (Object)key));
                return (GroupWelcomeInfo)session.createQuery((CriteriaQuery)query).getSingleResult();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566!", (Throwable)e);
        }
        if (groupWelcomeInfo == null) {
            subject.sendMessage("\u6ca1\u6709\u8981\u5220\u9664\u7684\u6b22\u8fce\u8bcd!");
            return;
        }
        if (toKey != 0) {
            List<WelcomeMessage> welcomeMessages = groupWelcomeInfo.getWelcomeMessages();
            int finalToKey = toKey;
            Optional<WelcomeMessage> first = welcomeMessages.stream().filter(it -> it.getId() == finalToKey).findFirst();
            if (first.isPresent()) {
                WelcomeMessage welcomeMessage = first.get();
                welcomeMessages.remove(welcomeMessage);
            }
            GroupWelcomeInfo finalGroupWelcomeInfos = groupWelcomeInfo;
            try {
                HibernateUtil.factory.fromTransaction(session -> {
                    session.merge((Object)finalGroupWelcomeInfos);
                    return 0;
                });
            }
            catch (Exception e) {
                subject.sendMessage("\u6b22\u8fce\u8bcd\u5220\u9664\u5931\u8d25!");
                HuYanSession.log.error("\u6b22\u8fce\u8bcd\u5220\u9664\u5931\u8d25!", (Throwable)e);
                return;
            }
            subject.sendMessage("\u6b22\u8fce\u8bcd\u5220\u9664\u6210\u529f!");
        } else {
            try {
                GroupWelcomeInfo finalGroupWelcomeInfo = groupWelcomeInfo;
                HibernateUtil.factory.fromTransaction(session -> {
                    session.remove((Object)finalGroupWelcomeInfo);
                    return 0;
                });
            }
            catch (Exception e) {
                subject.sendMessage("\u6b22\u8fce\u8bcd\u96c6\u5408\u5220\u9664\u5931\u8d25!");
                HuYanSession.log.error("\u6b22\u8fce\u8bcd\u96c6\u5408\u5220\u9664\u5931\u8d25!", (Throwable)e);
                return;
            }
            subject.sendMessage("\u6b22\u8fce\u8bcd\u96c6\u5408\u5220\u9664\u6210\u529f!");
        }
    }

    public static void increase(GroupWelcomeInfo welcomeInfo) {
        welcomeInfo.setPollingNumber(welcomeInfo.getPollingNumber() + 1);
        HibernateUtil.factory.fromTransaction(session -> (GroupWelcomeInfo)session.merge((Object)welcomeInfo));
    }
}

