/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.GroupProhibited;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageUtils;
import net.mamoe.mirai.message.data.PlainText;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class GroupProhibitedAction {
    public static void init(boolean type) {
        List groupProhibits = null;
        try {
            groupProhibits = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(GroupProhibited.class);
                JpaRoot from = query.from(GroupProhibited.class);
                query.select((Selection)from);
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u6570\u636e\u5e93\u8fdd\u7981\u8bcd\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25!", (Throwable)e);
        }
        StaticData.setProhibitedMap(GroupProhibitedAction.parseList(groupProhibits));
        if (ConfigData.INSTANCE.getDebugSwitch() && type) {
            HuYanSession.log.info("\u6570\u636e\u5e93\u8fdd\u7981\u8bcd\u4fe1\u606f\u521d\u59cb\u5316\u6210\u529f!");
            return;
        }
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            HuYanSession.log.info("\u8fdd\u7981\u8bcd\u6570\u636e\u66f4\u65b0\u6210\u529f!");
        }
    }

    public void addProhibited(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        User user = event.getSender();
        Map<Scope, List<GroupProhibited>> prohibitedMap = StaticData.getProhibitedMap(bot);
        code = code.replaceFirst("[:\uff1a]", " ");
        String[] strings = code.split(" +");
        String key = strings[1];
        Scope scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), -1);
        GroupProhibited groupProhibited = new GroupProhibited(bot.getId(), key, ConfigData.INSTANCE.getVariableSymbol() + "at(this)\u89e6\u53d1\u5929\u6761," + ConfigData.INSTANCE.getVariableSymbol() + "message(prohibitString)", 60, "1m", true, true, false, 0, scope);
        if (strings.length > 2) {
            block36: for (int i = 2; i < strings.length; ++i) {
                String string;
                switch (string = strings[i]) {
                    case "ch": {
                        groupProhibited.setWithdraw(false);
                        continue block36;
                    }
                    case "jy": {
                        groupProhibited.setProhibit(false);
                        continue block36;
                    }
                    case "\u7cbe\u51c6": 
                    case "1": {
                        groupProhibited.setMateType(1);
                        continue block36;
                    }
                    case "\u5934\u90e8": 
                    case "3": {
                        groupProhibited.setMateType(3);
                        continue block36;
                    }
                    case "\u7ed3\u5c3e": 
                    case "4": {
                        groupProhibited.setMateType(4);
                        continue block36;
                    }
                    case "0": 
                    case "\u5168\u5c40": {
                        scope.setScopeName("\u5168\u5c40");
                        scope.setGlobal(true);
                        groupProhibited.setScopeInfo(scope);
                        continue block36;
                    }
                    case "%": {
                        subject.sendMessage("\u8bf7\u8f93\u5165\u89e6\u53d1\u8fdd\u7981\u8bcd\u56de\u590d\u5185\u5bb9:");
                        String reply = ShareUtils.getNextMessageEventFromUser(user).getMessage().serializeToMiraiCode();
                        groupProhibited.setReply(reply);
                        continue block36;
                    }
                    default: {
                        if (Pattern.matches("\\d+[smhd]", string)) {
                            int time;
                            int timeParam = Integer.parseInt(string.substring(0, string.length() - 1));
                            String type = string.substring(string.length() - 1);
                            Object messages = "";
                            switch (type) {
                                case "s": {
                                    time = timeParam;
                                    messages = (String)messages + "\u7981\u8a00:" + timeParam + "\u79d2";
                                    break;
                                }
                                case "m": {
                                    time = timeParam * 60;
                                    messages = (String)messages + "\u7981\u8a00:" + timeParam + "\u5206\u949f";
                                    break;
                                }
                                case "h": {
                                    time = timeParam * 60 * 60;
                                    messages = (String)messages + "\u7981\u8a00:" + timeParam + "\u5c0f\u65f6";
                                    break;
                                }
                                case "d": {
                                    time = timeParam * 60 * 60 * 24;
                                    messages = (String)messages + "\u7981\u8a00:" + timeParam + "\u5929";
                                    break;
                                }
                                default: {
                                    subject.sendMessage("\u7981\u8a00\u65f6\u95f4\u683c\u5f0f\u9519\u8bef!");
                                    return;
                                }
                            }
                            groupProhibited.setProhibitTime(time);
                            groupProhibited.setProhibitString((String)messages);
                            continue block36;
                        }
                        if (Pattern.matches("gr\\d+", string)) {
                            scope.setScopeName("\u7fa4\u7ec4" + string.substring(1));
                            scope.setGroupInfo(true);
                            scope.setListId(Integer.parseInt(string.substring(1)));
                            groupProhibited.setScopeInfo(scope);
                            continue block36;
                        }
                        if (!Pattern.matches("hmd\\d+", string)) continue block36;
                        int number = Integer.parseInt(string.substring(3));
                        groupProhibited.setAccumulate(true);
                        groupProhibited.setAccumulateNumber(number);
                    }
                }
            }
        }
        if (prohibitedMap.containsKey(scope)) {
            List<GroupProhibited> prohibitedList = prohibitedMap.get(scope);
            for (GroupProhibited prohibited : prohibitedList) {
                if (!prohibited.getTrigger().equals(groupProhibited.getTrigger())) continue;
                groupProhibited.setId(prohibited.getId());
            }
        }
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                if (ScopeUtil.isScopeEmpty(scope)) {
                    session.persist((Object)scope);
                }
                session.merge((Object)groupProhibited);
                return 0;
            });
        }
        catch (Exception e) {
            subject.sendMessage("\u8fdd\u7981\u8bcd\u6dfb\u52a0\u5931\u8d25!");
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return;
        }
        subject.sendMessage((Message)MessageUtils.newChain((Message[])new Message[0]).plus("\u8fdd\u7981\u8bcd ").plus(MiraiCode.deserializeMiraiCode((String)key).plus(" \u6dfb\u52a0\u6210\u529f\uff01")));
        GroupProhibitedAction.init(false);
    }

    public void queryGroupProhibited(MessageEvent event) {
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        GroupProhibitedAction.init(false);
        ForwardMessageBuilder builder = new ForwardMessageBuilder(subject);
        builder.add((UserOrBot)bot, (Message)new PlainText("\u4ee5\u4e0b\u662f\u672c\u7fa4\u89e6\u53d1\u7684\u6240\u6709\u8fdd\u7981\u8bcd\u2193"));
        Map<Scope, List<GroupProhibited>> prohibitedMap = StaticData.getProhibitedMap(bot);
        for (Scope scope : prohibitedMap.keySet()) {
            if (!ShareUtils.mateScope(event, scope)) continue;
            List<GroupProhibited> prohibitedList = prohibitedMap.get(scope);
            for (GroupProhibited prohibited : prohibitedList) {
                builder.add((UserOrBot)bot, singleMessages -> {
                    singleMessages.add("\u8fdd\u7981\u8bcd\u7f16\u53f7:" + prohibited.getId() + "\n\u8fdd\u7981\u8bcd\u89e6\u53d1\u8bcd:" + prohibited.getTrigger() + "\n\u8fdd\u7981\u8bcd\u56de\u590d\u8bcd:" + prohibited.getReply() + "\n\u662f\u5426\u64a4\u56de:" + (prohibited.isWithdraw() ? "\u662f" : "\u5426") + "\n\u662f\u5426\u7981\u8a00:" + (prohibited.isProhibit() ? "\u662f" : "\u5426") + "\n\u662f\u5426\u7d2f\u8ba1\u9ed1\u540d\u5355\u6b21\u6570:" + (prohibited.isAccumulate() ? "\u662f" : "\u5426"));
                    if (prohibited.isAccumulate()) {
                        singleMessages.add("\n\u6b21\u6570\u4e0a\u9650:" + prohibited.getAccumulateNumber());
                    }
                    return null;
                });
            }
        }
        subject.sendMessage((Message)builder.build());
    }

    public void deleteProhibited(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        int key = Integer.parseInt(code.split("[:\uff1a]")[1]);
        Map<Scope, List<GroupProhibited>> prohibitedMap = StaticData.getProhibitedMap(bot);
        GroupProhibited groupProhibited = null;
        for (Scope scope : prohibitedMap.keySet()) {
            if (!ShareUtils.mateScope(event, scope)) continue;
            List<GroupProhibited> prohibitedList = prohibitedMap.get(scope);
            for (GroupProhibited prohibited : prohibitedList) {
                if (prohibited.getId() != key) continue;
                groupProhibited = prohibited;
            }
        }
        if (groupProhibited == null) {
            subject.sendMessage("\u6ca1\u6709\u627e\u5230\u4f60\u8981\u5220\u9664\u7684\u8fdd\u7981\u8bcd");
            return;
        }
        try {
            GroupProhibited finalGroupProhibited = groupProhibited;
            HibernateUtil.factory.fromTransaction(session -> {
                session.remove((Object)finalGroupProhibited);
                return 0;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            subject.sendMessage("\u8fdd\u7981\u8bcd " + MiraiCode.deserializeMiraiCode((String)groupProhibited.getTrigger()) + " \u5220\u9664\u5931\u8d25");
            return;
        }
        subject.sendMessage("\u8fdd\u7981\u8bcd " + MiraiCode.deserializeMiraiCode((String)groupProhibited.getTrigger()) + " \u5220\u9664\u6210\u529f");
        GroupProhibitedAction.init(false);
    }

    private static Map<Long, Map<Scope, List<GroupProhibited>>> parseList(List<GroupProhibited> prohibitedList) {
        if (prohibitedList == null || prohibitedList.isEmpty()) {
            return null;
        }
        HashMap<Long, Map<Scope, List<GroupProhibited>>> listMap = new HashMap<Long, Map<Scope, List<GroupProhibited>>>();
        for (final GroupProhibited entity : prohibitedList) {
            long bot = entity.getBot();
            final Scope scope = entity.getScopeInfo();
            if (!listMap.containsKey(bot)) {
                listMap.put(bot, (Map<Scope, List<GroupProhibited>>)new HashMap<Scope, List<GroupProhibited>>(){
                    {
                        this.put(scope, new ArrayList<GroupProhibited>(){
                            {
                                this.add(entity);
                            }
                        });
                    }
                });
                continue;
            }
            if (!((Map)listMap.get(bot)).containsKey(scope)) {
                ((Map)listMap.get(bot)).put(scope, new ArrayList<GroupProhibited>(){
                    {
                        this.add(entity);
                    }
                });
                continue;
            }
            ((List)((Map)listMap.get(bot)).get(scope)).add(entity);
        }
        return listMap;
    }
}

