/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.utils;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.ApplyClusterInfo;
import cn.chahuyun.entity.GroupProhibited;
import cn.chahuyun.entity.GroupWelcomeInfo;
import cn.chahuyun.utils.ShareUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.events.GroupEvent;
import net.mamoe.mirai.event.events.MemberJoinEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.PlainText;
import org.jetbrains.annotations.NotNull;

public class DynamicMessageUtil {
    public static MessageChain parseMessageParameter(MessageEvent event, String message, Object ... object) {
        if (message.contains(ConfigData.INSTANCE.getVariableSymbol() + "message(null)")) {
            return null;
        }
        Pattern pattern = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
        Matcher matcher = pattern.matcher(message);
        MessageChainBuilder builder = new MessageChainBuilder();
        int index = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String group = matcher.group();
            String[] split = group.split("\\(");
            String valueType = split[0].substring(1);
            String value = split[1].substring(0, split[1].length() - 1);
            Message messages = null;
            try {
                messages = DynamicMessageUtil.parseMessage(event, value, valueType, object);
            }
            catch (IOException e) {
                HuYanSession.log.error("\u8f6c\u6362\u52a8\u6001\u6d88\u606f\u51fa\u9519!", (Throwable)e);
            }
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)message.substring(index, start))).append(messages);
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                HuYanSession.log.info("\u52a8\u6001\u6d88\u606f-" + group + "->" + messages);
            }
            index = end;
        }
        if (index < message.length()) {
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)message.substring(index)));
        }
        return builder.build();
    }

    public static MessageChain parseMessageParameter(GroupEvent event, String message, Object ... object) {
        if (message.contains(ConfigData.INSTANCE.getVariableSymbol() + "message(null)")) {
            return null;
        }
        Pattern pattern = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
        Matcher matcher = pattern.matcher(message);
        MessageChainBuilder builder = new MessageChainBuilder();
        int index = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String group = matcher.group();
            String[] split = group.split("\\(");
            String valueType = split[0].substring(1);
            String value = split[1].substring(0, split[1].length() - 1);
            Message messages = null;
            try {
                messages = DynamicMessageUtil.parseMessage((MemberJoinEvent)event, value, valueType, object);
            }
            catch (IOException e) {
                HuYanSession.log.error("\u8f6c\u6362\u52a8\u6001\u6d88\u606f\u51fa\u9519!", (Throwable)e);
            }
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)message.substring(index, start))).append(messages);
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                HuYanSession.log.info("\u52a8\u6001\u6d88\u606f-" + group + "->" + messages);
            }
            index = end;
        }
        if (index < message.length()) {
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)message.substring(index)));
        }
        return builder.build();
    }

    public static MessageChain parseMessageParameter(String message, Object ... object) {
        if (message.contains(ConfigData.INSTANCE.getVariableSymbol() + "message(null)")) {
            return null;
        }
        Pattern pattern = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
        Matcher matcher = pattern.matcher(message);
        MessageChainBuilder builder = new MessageChainBuilder();
        int index = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String group = matcher.group();
            String[] split = group.split("\\(");
            String valueType = split[0].substring(1);
            String value = split[1].substring(0, split[1].length() - 1);
            Message messages = null;
            try {
                messages = DynamicMessageUtil.parseMessage(value, valueType, object);
            }
            catch (IOException e) {
                HuYanSession.log.error("\u8f6c\u6362\u52a8\u6001\u6d88\u606f\u51fa\u9519!", (Throwable)e);
            }
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)message.substring(index, start))).append(messages);
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                HuYanSession.log.info("\u52a8\u6001\u6d88\u606f-" + group + "->" + messages);
            }
            index = end;
        }
        if (index < message.length()) {
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)message.substring(index)));
        }
        return builder.build();
    }

    private static Message parseMessage(MessageEvent event, String value, String valueType, Object ... object) throws IOException {
        switch (valueType) {
            case "at": {
                NormalMember member;
                Contact subject;
                if (value.equals("this")) {
                    return new At(event.getSender().getId());
                }
                if (Pattern.matches("\\d+", value) && (subject = event.getSubject()) instanceof Group && (member = ((Group)subject).get(Long.parseLong(value))) != null) {
                    return new At(member.getId());
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "message": {
                switch (value) {
                    case "prohibitString": 
                    case "jyString": {
                        for (Object o : object) {
                            if (!(o instanceof GroupProhibited)) continue;
                            return new PlainText(((GroupProhibited)o).getProhibitString());
                        }
                    }
                    case "this": {
                        return event.getMessage();
                    }
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "user": {
                switch (value) {
                    case "name": {
                        return new PlainText(event.getSender().getNick());
                    }
                    case "id": {
                        return new PlainText("" + event.getSender().getId());
                    }
                    case "avatar": {
                        return Contact.uploadImage((Contact)event.getSubject(), (InputStream)new URL(event.getSender().getAvatarUrl()).openConnection().getInputStream());
                    }
                    case "title": {
                        String specialTitle = ((NormalMember)event.getSender()).getSpecialTitle();
                        if (specialTitle != null) {
                            return new PlainText(specialTitle);
                        }
                        ((NormalMember)event.getSender()).getSpecialTitle();
                    }
                    case "info": {
                        return new PlainText(event.getSender().queryProfile().toString());
                    }
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "time": {
                return DynamicMessageUtil.getDynamicTimeMessage(value, valueType);
            }
        }
        return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
    }

    private static Message parseMessage(MemberJoinEvent event, String value, String valueType, Object ... object) throws IOException {
        GroupWelcomeInfo welcomeMessage = (GroupWelcomeInfo)object[0];
        ApplyClusterInfo applyClusterInfo = (ApplyClusterInfo)object[1];
        switch (valueType) {
            case "at": {
                NormalMember member;
                switch (value) {
                    case "this": {
                        return new At(event.getMember().getId());
                    }
                    case "that": {
                        try {
                            NormalMember invitor = applyClusterInfo.getJoinRequestEvent().getInvitor();
                            if (invitor != null) {
                                return new At(invitor.getId());
                            }
                            User sender = applyClusterInfo.getMessageEvent().getSender();
                            return new At(sender.getId());
                        }
                        catch (Exception e) {
                            return new PlainText("\u52a8\u6001\u6d88\u606f\u65e0\u6548!-\u6279\u51c6\u4eba\u6216\u9080\u8bf7\u4eba");
                        }
                    }
                }
                if (Pattern.matches("\\d+", value) && (member = event.getGroup().get(Long.parseLong(value))) != null) {
                    return new At(member.getId());
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "message": {
                switch (value) {
                    case "apply": {
                        if (applyClusterInfo.getJoinRequestEvent() == null) {
                            return new PlainText("\u6211\u662f\u88ab\u522b\u4eba\u9886\u8fdb\u6765\u7684...");
                        }
                        String message = applyClusterInfo.getJoinRequestEvent().getMessage();
                        return new PlainText(message.isEmpty() ? "\u8fd9\u4e2a\u4eba\u4ec0\u4e48\u90fd\u6ca1\u8bf4..." : message);
                    }
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "user": {
                switch (value) {
                    case "name": {
                        return new PlainText(event.getMember().getNick());
                    }
                    case "id": {
                        return new PlainText("" + event.getMember().getId());
                    }
                    case "avatar": {
                        return Contact.uploadImage((Contact)event.getMember(), (InputStream)new URL(event.getMember().getAvatarUrl()).openConnection().getInputStream());
                    }
                    case "title": {
                        return new PlainText("\u7fa4\u6b22\u8fce\u8bcd\u4e0d\u652f\u6301\u7684\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
                    }
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "time": {
                return DynamicMessageUtil.getDynamicTimeMessage(value, valueType);
            }
        }
        return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
    }

    private static Message parseMessage(String value, String valueType, Object ... object) throws IOException {
        Group group = (Group)object[0];
        switch (valueType) {
            case "at": {
                NormalMember member;
                switch (value) {
                    case "this": 
                    case "that": {
                        return new PlainText("\u52a8\u6001\u6d88\u606f\u65e0\u6548!-\u5b9a\u65f6\u5668\u4e0d\u652f\u6301");
                    }
                }
                if (Pattern.matches("\\d+", value) && (member = group.get(Long.parseLong(value))) != null) {
                    return new At(member.getId());
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "message": {
                switch (value) {
                    case "apply": {
                        return new PlainText("\u52a8\u6001\u6d88\u606f\u65e0\u6548!-\u5b9a\u65f6\u5668\u4e0d\u652f\u6301");
                    }
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "user": {
                switch (value) {
                    case "name": 
                    case "id": 
                    case "avatar": 
                    case "title": {
                        return new PlainText("\u52a8\u6001\u6d88\u606f\u65e0\u6548!-\u5b9a\u65f6\u5668\u4e0d\u652f\u6301");
                    }
                }
                return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
            }
            case "time": {
                return DynamicMessageUtil.getDynamicTimeMessage(value, valueType);
            }
        }
        return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
    }

    @NotNull
    private static Message getDynamicTimeMessage(String value, String valueType) {
        String userFormat;
        if ("now".equals(value)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String format = simpleDateFormat.format(new Date());
            return new PlainText(format);
        }
        try {
            SimpleDateFormat userSimpleDateFormat = new SimpleDateFormat(value);
            userFormat = userSimpleDateFormat.format(new Date());
        }
        catch (Exception e) {
            HuYanSession.log.warning("\u52a8\u6001\u6d88\u606f-\u65f6\u95f4\u683c\u5f0f\u5316\u51fa\u9519!", (Throwable)e);
            return new PlainText("\u672a\u8bc6\u522b\u52a8\u6001\u6d88\u606f:" + ConfigData.INSTANCE.getVariableSymbol() + valueType + "(" + value + ")");
        }
        String trim = userFormat.replace("\\", "").trim();
        return new PlainText(trim);
    }
}

