/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.manage;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.QuartzInfo;
import cn.chahuyun.job.TimingJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;

public class QuartzManager {
    public static final QuartzManager INSTANCE = new QuartzManager();
    private static Scheduler scheduler = null;

    public static boolean addSchedulerJob(QuartzInfo quartzInfo) {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("data", (Object)quartzInfo);
            jobDataMap.put("logger", (Object)HuYanSession.log);
            jobDataMap.put("groupList", StaticData.getGroupListMap(quartzInfo.getBot()));
            JobDetail job = JobBuilder.newJob(TimingJob.class).withIdentity(String.valueOf(quartzInfo.getId())).usingJobData(jobDataMap).build();
            Trigger trigger = quartzInfo.getCronString() == null ? TriggerBuilder.newTrigger().withIdentity(String.valueOf(quartzInfo.getId())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)100).withRepeatCount(quartzInfo.getPollingNumber())).startNow().build() : TriggerBuilder.newTrigger().withIdentity(String.valueOf(quartzInfo.getId())).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)quartzInfo.getCronString())).startNow().build();
            scheduler.scheduleJob(job, trigger);
            return true;
        }
        catch (Exception e) {
            HuYanSession.log.error("\u5b9a\u65f6\u4efb\u52a1\u8c03\u5ea6\u5668\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static boolean deleteSchedulerJob(QuartzInfo quartzInfo) {
        CronTriggerImpl trigger;
        TriggerKey triggerKey = new TriggerKey(String.valueOf(quartzInfo.getId()));
        try {
            trigger = (CronTriggerImpl)scheduler.getTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            HuYanSession.log.warning("\u4e0d\u5b58\u5728\u8be5\u5b9a\u65f6\u4efb\u52a1", (Throwable)e);
            return false;
        }
        if (trigger != null) {
            try {
                scheduler.unscheduleJob(triggerKey);
                return true;
            }
            catch (SchedulerException e) {
                HuYanSession.log.error("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u5931\u8d25", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    static {
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            HuYanSession.log.error("\u5b9a\u65f6\u4efb\u52a1\u8c03\u5ea6\u5668\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
    }
}

