/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.manage;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.BlackListData;
import cn.chahuyun.controller.BlackHouseAction;
import cn.chahuyun.controller.BlackListAction;
import cn.chahuyun.data.ApplyClusterInfo;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.dialogue.Dialogue;
import cn.chahuyun.entity.BlackHouse;
import cn.chahuyun.entity.Blacklist;
import cn.chahuyun.entity.GroupProhibited;
import cn.chahuyun.entity.GroupWelcomeInfo;
import cn.chahuyun.entity.Power;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.enums.Mate;
import cn.chahuyun.utils.DynamicMessageUtil;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.Member;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.PermissionDeniedException;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.ConcurrencyKind;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.EventPriority;
import net.mamoe.mirai.event.GlobalEventChannel;
import net.mamoe.mirai.event.ListeningStatus;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MemberJoinEvent;
import net.mamoe.mirai.event.events.MemberJoinRequestEvent;
import net.mamoe.mirai.event.events.MemberLeaveEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageUtils;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;
import xyz.cssxsh.mirai.hibernate.MiraiHibernateRecorder;
import xyz.cssxsh.mirai.hibernate.entry.MessageRecord;

public class GroupManager {
    public static final GroupManager INSTANCE = new GroupManager();
    public static final Map<String, ApplyClusterInfo> map = new HashMap<String, ApplyClusterInfo>();
    private static int doorNumber = 0;

    public void prohibit(MessageEvent event) {
        boolean botIsAdmin;
        Contact subject = event.getSubject();
        String code = event.getMessage().serializeToMiraiCode();
        Bot bot = event.getBot();
        Group group = (Group)subject;
        boolean bl = botIsAdmin = group.getBotPermission() == MemberPermission.MEMBER;
        if (botIsAdmin) {
            subject.sendMessage("\u4eba\u5bb6\u8fd8\u4e0d\u662f\u7ba1\u7406\u5458\u54e6~");
            return;
        }
        Long qq = null;
        for (SingleMessage s : event.getMessage()) {
            if (!(s instanceof At)) continue;
            qq = ((At)s).getTarget();
        }
        if (qq == null) {
            subject.sendMessage("\u7981\u8a00\u5931\u8d25\uff0c\u6ca1\u6709\u8fd9\u4e2a\u4eba\u5462\uff01");
            return;
        }
        NormalMember member = Objects.requireNonNull(bot.getGroup(event.getSubject().getId())).get(qq.longValue());
        String[] split = code.split(" ");
        String param = split[1];
        String type = param.substring(param.length() - 1);
        int timeParam = Integer.parseInt(param.substring(0, param.length() - 1));
        if (timeParam == 0) {
            assert (member != null);
            member.unmute();
            subject.sendMessage("\u89e3\u7981\u6210\u529f\uff01");
            return;
        }
        int time = 0;
        MessageChainBuilder messages = new MessageChainBuilder().append((CharSequence)"\u7981\u8a00\u6210\u529f!");
        switch (type) {
            case "s": {
                time = timeParam;
                messages.append((CharSequence)"\u7981\u8a00:").append((CharSequence)String.valueOf(timeParam)).append((CharSequence)"\u79d2");
                break;
            }
            case "m": {
                time = timeParam * 60;
                messages.append((CharSequence)"\u7981\u8a00:").append((CharSequence)String.valueOf(timeParam)).append((CharSequence)"\u5206\u949f");
                break;
            }
            case "h": {
                time = timeParam * 60 * 60;
                messages.append((CharSequence)"\u7981\u8a00:").append((CharSequence)String.valueOf(timeParam)).append((CharSequence)"\u5c0f\u65f6");
                break;
            }
            case "d": {
                time = timeParam * 60 * 60 * 24;
                messages.append((CharSequence)"\u7981\u8a00:").append((CharSequence)String.valueOf(timeParam)).append((CharSequence)"\u5929");
                break;
            }
        }
        assert (member != null);
        member.mute(time);
        subject.sendMessage((Message)messages.build());
    }

    public void recall(MessageEvent event) {
        boolean botIsAdmin;
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        if (!(subject instanceof Group)) {
            return;
        }
        Group group = (Group)subject;
        boolean bl = botIsAdmin = group.getBotPermission() == MemberPermission.MEMBER;
        if (botIsAdmin) {
            return;
        }
        List records = MiraiHibernateRecorder.INSTANCE.get(group).collect(Collectors.toList());
        String[] split = code.split(" +");
        if (split.length == 1) {
            records = records.subList(1, 2);
        } else if (split.length == 2) {
            String string = split[1];
            if (string.contains("-") || string.contains("~")) {
                String[] strings = string.split("[~-]");
                int start = Integer.parseInt(strings[0]);
                int end = Integer.parseInt(strings[1]);
                HuYanSession.log.info("s-" + start + " e-" + end);
                records = records.subList(start, end);
            } else {
                int end = Integer.parseInt(split[1]);
                records = records.subList(1, end);
            }
        }
        for (MessageRecord record : records) {
            try {
                MessageSource.recall((MessageSource)record.toMessageSource());
            }
            catch (PermissionDeniedException e) {
                HuYanSession.log.warning("\u6d88\u606f\u64a4\u56de\u51b2\u7a81-\u65e0\u6743\u64cd\u4f5c");
            }
            catch (IllegalStateException e) {
                HuYanSession.log.warning("\u6d88\u606f\u64a4\u56de\u51b2\u7a81-\u5df2\u88ab\u64a4\u56de \u6216 \u6d88\u606f\u672a\u627e\u5230");
            }
            catch (Exception e) {
                subject.sendMessage("\u6d88\u606f\u64a4\u56de\u5931\u8d25!");
                HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            }
        }
    }

    public void editUserTitle(MessageEvent event) {
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        Group group = bot.getGroup(subject.getId());
        long userId = 0L;
        for (SingleMessage singleMessage : message) {
            if (!(singleMessage instanceof At)) continue;
            userId = ((At)singleMessage).getTarget();
        }
        if (userId == 0L) {
            subject.sendMessage("\u6ca1\u6709\u8fd9\u4e2a\u4eba");
            return;
        }
        String title = code.split(" +")[1];
        if (group == null) {
            subject.sendMessage("\u6ca1\u6709\u8fd9\u4e2a\u7fa4");
            return;
        }
        NormalMember normalMember = group.get(userId);
        if (normalMember == null) {
            subject.sendMessage("\u6ca1\u6709\u8fd9\u4e2a\u4eba");
            return;
        }
        if (group.getBotPermission() != MemberPermission.OWNER) {
            subject.sendMessage("\u4f60\u7684\u673a\u5668\u4eba\u4e0d\u662f\u7fa4\u4e3b\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\uff01");
            return;
        }
        normalMember.setSpecialTitle(title);
        subject.sendMessage("\u4fee\u6539\u5934\u8854\u6210\u529f\uff01");
    }

    public boolean isProhibited(MessageEvent event) throws IOException {
        MessageChain messages;
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        User sender = event.getSender();
        Bot bot = event.getBot();
        if (!(subject instanceof Group)) {
            return false;
        }
        Group group = (Group)subject;
        MemberPermission botPermission = group.getBotPermission();
        if (botPermission == MemberPermission.MEMBER) {
            return false;
        }
        GroupProhibited groupProhibited = null;
        Map<Scope, List<GroupProhibited>> prohibitedMap = StaticData.getProhibitedMap(bot);
        for (Scope scope : prohibitedMap.keySet()) {
            if (!ShareUtils.mateScope(event, scope)) continue;
            List<GroupProhibited> groupProhibits = prohibitedMap.get(scope);
            for (GroupProhibited prohibited : groupProhibits) {
                int mateType = prohibited.getMateType();
                Mate mate = Mate.VAGUE;
                String trigger = prohibited.getTrigger();
                if (mateType == 1) {
                    mate = Mate.ACCURATE;
                } else if (mateType == 3) {
                    mate = Mate.START;
                } else if (mateType == 4) {
                    mate = Mate.END;
                }
                if (!ShareUtils.mateMate(code, mate, trigger)) continue;
                groupProhibited = prohibited;
            }
        }
        if (groupProhibited == null) {
            return false;
        }
        if (groupProhibited.isWithdraw()) {
            try {
                MessageSource.recall((MessageChain)event.getMessage());
            }
            catch (PermissionDeniedException e) {
                HuYanSession.log.warning("\u8fdd\u7981\u8bcd\u64a4\u56de\u5931\u8d25-\u6743\u9650\u4e0d\u8db3");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (groupProhibited.isProhibit()) {
            Member member = (Member)sender;
            if (groupProhibited.getProhibitTime() > 0) {
                member.mute(groupProhibited.getProhibitTime());
            }
        }
        BlackHouseAction blackHouseAction = new BlackHouseAction();
        if (groupProhibited.isAccumulate()) {
            BlackHouse blackHouse = blackHouseAction.getBlackHouse(bot, sender.getId());
            if (blackHouse == null) {
                blackHouse = new BlackHouse(bot.getId(), sender.getId(), groupProhibited.getId(), 1);
            } else {
                blackHouse.setNumber(blackHouse.getNumber() + 1);
            }
            if (blackHouse.getNumber() >= groupProhibited.getAccumulateNumber()) {
                subject.sendMessage(sender.getNick() + "\u5df2\u7ecf\u5230\u8fbe\u8fdd\u7981\u8bcd\u89e6\u53d1\u6b21\u6570\uff0c\u5c06\u88ab\u8e22\u51fa\u672c\u7fa4!");
                bot.getGroup(subject.getId()).get(sender.getId()).kick(sender.getNick() + "\u5df2\u7ecf\u5230\u8fbe\u8fdd\u7981\u8bcd\u89e6\u53d1\u6b21\u6570\uff0c\u5c06\u88ab\u8e22\u51fa\u672c\u7fa4\uff01");
                return true;
            }
            subject.sendMessage((Message)MessageUtils.newChain((Message[])new Message[0]).plus((SingleMessage)new At(sender.getId())).plus((SingleMessage)new PlainText("\u4f60\u5df2\u7ecf\u8fdd\u89c4 " + blackHouse.getNumber() + " \u6b21\uff0c\u5f53\u8fdd\u89c4 " + groupProhibited.getAccumulateNumber() + " \u6b21\u5c31\u4f1a\u88ab\u8e22\u51fa!")));
            blackHouseAction.saveOrUpdate(blackHouse);
        }
        if ((messages = DynamicMessageUtil.parseMessageParameter(event, groupProhibited.getReply(), groupProhibited)) != null) {
            subject.sendMessage((Message)messages);
        }
        return true;
    }

    public static void userRequestGroup(final MemberJoinRequestEvent event) {
        Group group = event.getGroup();
        String fromNick = event.getFromNick();
        long fromId = event.getFromId();
        String message = event.getMessage();
        Long invitorId = event.getInvitorId();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(new Date());
        HashMap<Integer, Long> eventMap = new HashMap<Integer, Long>();
        eventMap.put(doorNumber, event.getEventId());
        MessageChainBuilder messageChain = new MessageChainBuilder();
        messageChain.append((SingleMessage)new PlainText("\u6765\u4eba\u5566~!\n\u95e8\u724c\u53f7:" + doorNumber++ + "\n\u65f6\u95f4:" + format + "\n\u6572\u95e8\u4eba:" + fromNick + "(" + fromId + ")"));
        if (message.isEmpty()) {
            messageChain.append((CharSequence)"\n\u6572\u95e8\u53e3\u4ee4:(\u8fd9\u4e2a\u4eba\u5565\u4e5f\u6ca1\u8bf4!)");
        } else {
            messageChain.append((CharSequence)"\n\u6572\u95e8\u53e3\u4ee4:").append((CharSequence)message);
        }
        try {
            if (invitorId != null) {
                messageChain.append((CharSequence)"\n\u6307\u8def\u4eba:").append((CharSequence)group.get(invitorId.longValue()).getNick()).append((CharSequence)"(").append((CharSequence)String.valueOf(invitorId)).append((CharSequence)")");
            }
        }
        catch (Exception e) {
            HuYanSession.log.warning("\u65b0\u4eba\u52a0\u7fa4\u7533\u8bf7-\u6b22\u8fce\u6d88\u606f\u6784\u9020\u5931\u8d25!");
        }
        assert (group != null);
        group.sendMessage((Message)messageChain.build());
        EventChannel channel = GlobalEventChannel.INSTANCE.parentScope((CoroutineScope)HuYanSession.INSTANCE).filterIsInstance(GroupMessageEvent.class).filter(nextGroup -> nextGroup.getGroup() == group).filter(nextEvent -> {
            String toString = nextEvent.getMessage().contentToString();
            return Pattern.matches("(\u540c\u610f|\u62d2\u7edd|\u5f00\u95e8|\u5173\u95e8) +(\\d+|all)|[!\uff01]\u7533\u8bf7\u5217\u8868", toString);
        });
        map.put(event.getGroupId() + "." + event.getFromId(), new ApplyClusterInfo(){
            {
                this.setJoinRequestEvent(event);
            }
        });
        channel.subscribe(GroupMessageEvent.class, (CoroutineContext)EmptyCoroutineContext.INSTANCE, ConcurrencyKind.LOCKED, EventPriority.HIGH, messageEvent -> GroupManager.AgreeOrRefuseToApply(event, messageEvent, eventMap));
    }

    public static void userJoinGroup(MemberJoinEvent event) {
        Bot bot = event.getBot();
        Group group = event.getGroup();
        List welcomeInfoList = null;
        try {
            welcomeInfoList = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(GroupWelcomeInfo.class);
                JpaRoot from = query.from(GroupWelcomeInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566!", (Throwable)e);
        }
        GroupWelcomeInfo groupWelcomeInfo = null;
        boolean next = true;
        for (GroupWelcomeInfo groupWelcome : welcomeInfoList) {
            Scope scope = ScopeUtil.getScope(groupWelcome.getScopeMark());
            assert (scope != null);
            if (!ShareUtils.mateScope(bot, group, scope)) continue;
            next = false;
            groupWelcomeInfo = groupWelcome;
            break;
        }
        if (next) {
            return;
        }
        String mark = group.getId() + "." + event.getMember().getId();
        if (map.containsKey(mark)) {
            map.get(mark).setJoinEvent(event);
        } else {
            ApplyClusterInfo applyClusterInfo = new ApplyClusterInfo();
            applyClusterInfo.setJoinEvent(event);
            map.put(mark, applyClusterInfo);
        }
        Dialogue.INSTANCE.dialogueSession(event, groupWelcomeInfo);
    }

    public static void kick(MessageEvent event) {
        String s;
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        Group group = null;
        if (subject instanceof Group) {
            group = (Group)subject;
        }
        long userId = 0L;
        for (SingleMessage singleMessage : message) {
            if (!(singleMessage instanceof At)) continue;
            userId = ((At)singleMessage).getTarget();
        }
        assert (group != null);
        NormalMember member = group.get(userId);
        if (member == null) {
            HuYanSession.log.warning("\u8be5\u7fa4\u5458\u4e0d\u5b58\u5728\uff01");
            return;
        }
        String[] split = code.split(" +");
        if (split.length > 1 && (s = split[1]).equals("hmd")) {
            member.kick("\u518d\u4e5f\u4e0d\u89c1\uff01", true);
            return;
        }
        member.kick("\u9001\u4f60\u98de\u673a\u7968~");
    }

    public static boolean detectBlackList(MemberJoinEvent event) {
        Group group = event.getGroup();
        NormalMember member = event.getMember();
        Bot bot = event.getBot();
        List blacklists = null;
        try {
            blacklists = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(Blacklist.class);
                JpaRoot from = query.from(Blacklist.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                query.where((Expression)builder.equal((Expression)from.get("blackQQ"), (Object)member.getId()));
                List list = session.createQuery((CriteriaQuery)query).list();
                for (Blacklist blacklist : list) {
                    if (blacklist.getScope() != null) continue;
                    blacklist.setScope(ScopeUtil.getScope(blacklist.getScopeMark()));
                }
                return list;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return false;
        }
        if (blacklists == null || blacklists.isEmpty()) {
            return false;
        }
        for (Blacklist blacklist : blacklists) {
            if (!ShareUtils.mateScope(bot, group, blacklist.getScope())) continue;
            group.sendMessage("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237: " + member.getId() + " ,\u5c01\u7981\u7406\u7531:" + blacklist.getReason());
            member.kick(blacklist.getReason());
            return true;
        }
        return false;
    }

    public static boolean detectBlackList(MemberJoinRequestEvent event) {
        Group group = event.getGroup();
        long member = event.getFromId();
        Bot bot = event.getBot();
        List blacklists = null;
        try {
            blacklists = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(Blacklist.class);
                JpaRoot from = query.from(Blacklist.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                query.where((Expression)builder.equal((Expression)from.get("blackQQ"), (Object)member));
                List list = session.createQuery((CriteriaQuery)query).list();
                for (Blacklist blacklist : list) {
                    if (blacklist.getScope() != null) continue;
                    blacklist.setScope(ScopeUtil.getScope(blacklist.getScopeMark()));
                }
                return list;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return false;
        }
        if (blacklists == null || blacklists.isEmpty()) {
            return false;
        }
        for (Blacklist blacklist : blacklists) {
            if (!ShareUtils.mateScope(bot, group, blacklist.getScope())) continue;
            group.sendMessage("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237: " + member + " ,\u5c01\u7981\u7406\u7531:" + blacklist.getReason());
            event.reject();
            return true;
        }
        return false;
    }

    public static void autoAddBlackList(MemberLeaveEvent event) {
        long botId = event.getBot().getId();
        Member member = event.getMember();
        long userId = member.getId();
        Group group = event.getGroup();
        long groupId = group.getId();
        Scope scope = new Scope(botId, "\u5f53\u524d", false, false, groupId, 0);
        Blacklist blacklist = new Blacklist(botId, userId, BlackListData.INSTANCE.getAutoBlackListReason(), scope);
        BlackListAction.saveBlackList(blacklist, scope);
        group.sendMessage(String.format("%s(%d) \u79bb\u5f00\u4e86\u6211\u4eec,\u5df2\u7ecf\u52a0\u5165\u9ed1\u540d\u5355!", member.getNick(), userId));
    }

    private static ListeningStatus AgreeOrRefuseToApply(MemberJoinRequestEvent apply, GroupMessageEvent event, Map<Integer, Long> numbers) {
        String content;
        Group group = event.getGroup();
        Member sender = event.getSender();
        Bot bot = event.getBot();
        String powerString = group.getId() + "." + sender.getId();
        Map<String, Power> powerMap = StaticData.getPowerMap(bot);
        MemberPermission permission = event.getGroup().get(event.getSender().getId()).getPermission();
        if (permission == MemberPermission.MEMBER) {
            if (!powerMap.containsKey(powerString)) {
                return ListeningStatus.LISTENING;
            }
            Power power = powerMap.get(powerString);
            if (!power.isAdmin() && !power.isGroupManage()) {
                return ListeningStatus.LISTENING;
            }
        }
        if (Pattern.matches("\u540c\u610f \\d+", content = event.getMessage().contentToString())) {
            int number = Integer.parseInt(content.substring(3));
            if (!numbers.containsKey(number)) {
                return ListeningStatus.LISTENING;
            }
            Long eventId = numbers.get(number);
            if (apply.getEventId() == eventId.longValue()) {
                apply.accept();
                map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            }
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u5f00\u95e8 \\d+", content)) {
            int number = Integer.parseInt(content.substring(3));
            if (!numbers.containsKey(number)) {
                return ListeningStatus.LISTENING;
            }
            Long eventId = numbers.get(number);
            if (apply.getEventId() == eventId.longValue()) {
                event.getSubject().sendMessage("\u597d\u7684\uff0c\u6211\u8fd9\u5c31\u5f00\u95e8");
                apply.accept();
                map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            }
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u5f00\u95e8 all", content)) {
            event.getSubject().sendMessage("\u5927\u95e8\u5f00\u7740\u7684\uff0c\u90fd\u8fdb\u6765\u4e86");
            apply.accept();
            map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u540c\u610f all", content)) {
            apply.accept();
            map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u62d2\u7edd \\d+", content)) {
            int number = Integer.parseInt(content.substring(3));
            if (!numbers.containsKey(number)) {
                return ListeningStatus.LISTENING;
            }
            Long eventId = numbers.get(number);
            if (apply.getEventId() == eventId.longValue()) {
                apply.reject();
                map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            }
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u5173\u95e8 \\d+", content)) {
            int number = Integer.parseInt(content.substring(3));
            if (!numbers.containsKey(number)) {
                return ListeningStatus.LISTENING;
            }
            Long eventId = numbers.get(number);
            if (apply.getEventId() == eventId.longValue()) {
                event.getSubject().sendMessage("\u95e8\u6211\u53cd\u9501\u4e86\uff01");
                apply.accept();
                map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            }
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u62d2\u7edd all", content)) {
            apply.accept();
            map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            return ListeningStatus.STOPPED;
        }
        if (Pattern.matches("\u9501\u5927\u95e8", content)) {
            event.getSubject().sendMessage("\u5927\u95e8\u6211\u4e0a\u9501\u4e86\uff01");
            apply.accept();
            map.get(apply.getGroupId() + "." + apply.getFromId()).setMessageEvent((MessageEvent)event);
            return ListeningStatus.STOPPED;
        }
        String fromNick = apply.getFromNick();
        long fromId = apply.getFromId();
        String message = apply.getMessage();
        Long invitorId = apply.getInvitorId();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(new Date());
        MessageChainBuilder messageChain = new MessageChainBuilder();
        messageChain.append((SingleMessage)new PlainText("\u95e8\u5916\u8fd8\u6709\u4eba\u5462!\n\u95e8\u724c\u53f7:" + doorNumber + "\n\u65f6\u95f4:" + format + "\n\u6572\u95e8\u4eba:" + fromNick + "(" + fromId + ")"));
        if (message.isEmpty()) {
            messageChain.append((CharSequence)"\n\u6572\u95e8\u53e3\u4ee4:(\u8fd9\u4e2a\u4eba\u5565\u4e5f\u6ca1\u8bf4!)");
        } else {
            messageChain.append((CharSequence)"\n\u6572\u95e8\u53e3\u4ee4:").append((CharSequence)message);
        }
        try {
            if (invitorId != null) {
                messageChain.append((CharSequence)"\n\u6307\u8def\u4eba:").append((CharSequence)group.get(invitorId.longValue()).getNick()).append((CharSequence)"(").append((CharSequence)String.valueOf(invitorId)).append((CharSequence)")");
            }
        }
        catch (Exception e) {
            HuYanSession.log.warning("\u65b0\u4eba\u52a0\u7fa4\u7533\u8bf7-\u6b22\u8fce\u6d88\u606f\u6784\u9020\u5931\u8d25!");
        }
        group.sendMessage((Message)messageChain.build());
        return ListeningStatus.LISTENING;
    }
}

