/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.job;

import cn.chahuyun.config.ConfigData;
import cn.chahuyun.controller.QuartzAction;
import cn.chahuyun.entity.GroupInfo;
import cn.chahuyun.entity.GroupList;
import cn.chahuyun.entity.ManySession;
import cn.chahuyun.entity.QuartzInfo;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.utils.DynamicMessageUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.ContactList;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.utils.MiraiLogger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class TimingJob
implements Job {
    public void execute(JobExecutionContext context) {
        block5: {
            Bot bot;
            Scope scope;
            MiraiLogger l;
            Map groupList;
            QuartzInfo base;
            block4: {
                JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
                base = (QuartzInfo)jobDataMap.get((Object)"data");
                groupList = (Map)jobDataMap.get((Object)"groupList");
                l = (MiraiLogger)jobDataMap.get((Object)"logger");
                scope = base.getScope();
                if (ConfigData.INSTANCE.getDebugSwitch()) {
                    l.info("\u5b9a\u65f6\u5668" + base.getId() + "-" + base.getName() + "\u6267\u884c!");
                }
                long botQq = base.getBot();
                bot = Bot.getInstance((long)botQq);
                if (!scope.isGlobal()) break block4;
                ContactList groups = bot.getGroups();
                for (Group group : groups) {
                    this.dialogue(base, group);
                }
                break block5;
            }
            if (!scope.isGroupInfo()) break block5;
            GroupList groupListInfo = (GroupList)groupList.get(scope.getListId());
            List<GroupInfo> groups = groupListInfo.getGroups();
            for (GroupInfo groupInfo : groups) {
                Group group = bot.getGroup(groupInfo.getGroupId());
                if (group == null) {
                    l.warning(String.format("\u7fa4 %d \u4e0d\u5b58\u5728\uff01", groupInfo.getGroupId()));
                    continue;
                }
                this.dialogue(base, group);
            }
        }
    }

    private void dialogue(QuartzInfo quartzInfo, Group group) {
        boolean random = quartzInfo.isRandom();
        boolean polling = quartzInfo.isPolling();
        List<ManySession> manySessions = quartzInfo.getManySessions();
        if (!random && !polling) {
            this.sendMessage(group, quartzInfo.isDynamic(), quartzInfo.isOther(), quartzInfo.getReply());
        } else {
            int size = manySessions.size();
            if (random) {
                ManySession manySession = manySessions.get((int)(Math.random() * (double)size - 1.0));
                this.sendMessage(group, manySession.isDynamic(), manySession.isOther(), manySession.getReply());
            } else {
                int pollingNumber = quartzInfo.getPollingNumber();
                ManySession manySession = manySessions.get(pollingNumber < size ? pollingNumber : pollingNumber % size);
                this.sendMessage(group, manySession.isDynamic(), manySession.isOther(), manySession.getReply());
                QuartzAction.increase(quartzInfo);
            }
        }
    }

    private void sendMessage(Group group, boolean dynamic, boolean other, String reply) {
        if (dynamic) {
            group.sendMessage((Message)Objects.requireNonNull(DynamicMessageUtil.parseMessageParameter(reply, group)));
        } else if (other) {
            group.sendMessage((Message)MessageChain.deserializeFromJsonString((String)reply));
        } else {
            group.sendMessage((Message)MiraiCode.deserializeMiraiCode((String)reply));
        }
    }
}

