/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.event;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.controller.BlackListAction;
import cn.chahuyun.controller.GroupProhibitedAction;
import cn.chahuyun.controller.GroupWelcomeInfoAction;
import cn.chahuyun.controller.ListAction;
import cn.chahuyun.controller.ManySessionAction;
import cn.chahuyun.controller.PowerAction;
import cn.chahuyun.controller.QuartzAction;
import cn.chahuyun.controller.RepeatMessageAction;
import cn.chahuyun.controller.SessionAction;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.dialogue.Dialogue;
import cn.chahuyun.entity.ManySessionInfo;
import cn.chahuyun.entity.Power;
import cn.chahuyun.entity.SessionInfo;
import cn.chahuyun.manage.GroupManager;
import cn.chahuyun.utils.ShareUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.coroutines.CoroutineContext;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.BotIsBeingMutedException;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.MessageTooLargeException;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.EventHandler;
import net.mamoe.mirai.event.SimpleListenerHost;
import net.mamoe.mirai.event.events.EventCancelledException;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

public class MessageEventListener
extends SimpleListenerHost {
    private static final MiraiLogger l = HuYanSession.INSTANCE.getLogger();

    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        if (exception instanceof EventCancelledException) {
            l.error("\u53d1\u9001\u6d88\u606f\u88ab\u53d6\u6d88:", exception);
        } else if (exception instanceof BotIsBeingMutedException) {
            l.error("\u4f60\u7684\u673a\u5668\u4eba\u88ab\u7981\u8a00:", exception);
        } else if (exception instanceof MessageTooLargeException) {
            l.error("\u53d1\u9001\u6d88\u606f\u8fc7\u957f:", exception);
        } else if (exception instanceof IllegalArgumentException) {
            l.error("\u53d1\u9001\u6d88\u606f\u4e3a\u7a7a:", exception);
        }
        l.error("\u51fa\u9519\u5566~", exception);
    }

    @EventHandler
    public void onMessage(@NotNull MessageEvent event) throws Exception {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        User sender = event.getSender();
        Bot bot = event.getBot();
        List instances = Bot.getInstances();
        for (Bot instance : instances) {
            if (instance.getId() != sender.getId()) continue;
            return;
        }
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            l.info("MiraiCode-> " + code);
        }
        boolean owner = ConfigData.INSTANCE.getOwner() == sender.getId();
        String powerString = subject.getId() + "." + sender.getId();
        Map<String, Power> powerMap = StaticData.getPowerMap(bot);
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            l.info("owner-" + owner + " power-" + powerMap.containsKey(powerString));
        }
        boolean powerUser = powerMap.containsKey(powerString);
        BlackListAction blackListAction = new BlackListAction();
        if (!owner) {
            blackListAction.isBlackUser(event);
            if (powerUser ? !powerMap.get(powerString).isGroupManage() && !powerMap.get(powerString).isGroupWjc() && GroupManager.INSTANCE.isProhibited(event) : GroupManager.INSTANCE.isProhibited(event)) {
                return;
            }
        }
        boolean isGroupAdmin = false;
        boolean isGroupOwner = false;
        if (subject instanceof Group) {
            if (RepeatMessageAction.isScreen(event)) {
                return;
            }
            Group group = (Group)subject;
            MemberPermission botPermission = group.getBotPermission();
            if (botPermission == MemberPermission.ADMINISTRATOR) {
                isGroupAdmin = true;
            } else if (botPermission == MemberPermission.OWNER) {
                isGroupOwner = true;
            }
        }
        if (!owner && !powerUser) {
            this.isSessionMessage(event);
            return;
        }
        Power power = powerMap.get(powerString);
        if (power == null) {
            power = new Power();
        }
        boolean admin = power.isAdmin();
        String pauseEventPattern = "^[!\uff01]pause +\\[mirai:at:\\d+]( +\\d+)?";
        if (ShareUtils.isPause(event)) {
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u672c" + bot.getNick() + "(Bot)\u8fd8\u4e0d\u662f\u5f88\u60f3\u7406\u4f60");
            }
            return;
        }
        if (Pattern.matches(pauseEventPattern, code)) {
            l.info("\u6dfb\u52a0\u5ffd\u7565\u6d88\u606f\u6307\u4ee4");
            ShareUtils.spotPause(event);
            return;
        }
        String addListPattern = "^\\+?gr\\\\?[:\uff1a]\\d+( +\\d+)+|^\u6dfb\u52a0\u7fa4\u7ec4\\\\?[:\uff1a]\\d+( +\\d+)+";
        String queryListPattern = "^gr\\\\?[:\uff1a](\\d+)?|^\u67e5\u8be2\u7fa4\u7ec4\\\\?[:\uff1a](\\d+)?";
        String deleteListPattern = "^-gr\\\\?[\uff1a:]\\d+( +\\d+)?|^\u5220\u9664\u7fa4\u7ec4\\\\?[:\uff1a]\\d+( +\\d+)?";
        if (owner || admin || power.isGroupList()) {
            ListAction listAction = new ListAction();
            if (Pattern.matches(addListPattern, code)) {
                l.info("\u6dfb\u52a0\u7fa4\u7ec4\u6307\u4ee4");
                listAction.addGroupListInfo(event);
                return;
            }
            if (Pattern.matches(queryListPattern, code)) {
                l.info("\u67e5\u8be2\u7fa4\u7ec4\u6307\u4ee4");
                listAction.queryGroupListInfo(event);
                return;
            }
            if (Pattern.matches(deleteListPattern, code)) {
                l.info("\u5220\u9664\u7fa4\u7ec4\u6307\u4ee4");
                listAction.deleteGroupListInfo(event);
                return;
            }
        }
        String addStudyPattern = "^xx( +\\S+){2,4}|^\u5b66\u4e60( +\\S+){2,4}";
        String queryStudyPattern = "^xx\\\\?[:\uff1a](\\S+)?|^\u67e5\u8be2( +\\S+)?";
        String addsStudyPattern = "^%xx|^\u5b66\u4e60\u5bf9\u8bdd";
        String deleteStudyPattern = "^-xx\\\\?[:\uff1a](\\S+)|^\u5220\u9664( +\\S+)";
        String deleteDialogueStudyPattern = "^-%xx|^\u5220\u9664\u5bf9\u8bdd";
        if (owner || admin || power.isSession() || power.isSessionX()) {
            SessionAction sessionAction = new SessionAction();
            if (Pattern.matches(addStudyPattern, code)) {
                l.info("\u5b66\u4e60\u4f1a\u8bdd\u6307\u4ee4");
                sessionAction.studySession(event);
                return;
            }
            if (Pattern.matches(queryStudyPattern, code)) {
                l.info("\u67e5\u8be2\u4f1a\u8bdd\u6307\u4ee4");
                sessionAction.querySession(event);
                return;
            }
            if (Pattern.matches(addsStudyPattern, code)) {
                l.info("\u6dfb\u52a0\u4f1a\u8bdd\u6307\u4ee4");
                sessionAction.studyDialogue(event);
                return;
            }
            if (Pattern.matches(deleteStudyPattern, code)) {
                l.info("\u5220\u9664\u4f1a\u8bdd\u6307\u4ee4");
                sessionAction.deleteSession(event);
                return;
            }
            if (Pattern.matches(deleteDialogueStudyPattern, code)) {
                l.info("\u5220\u9664\u4f1a\u8bdd\u6307\u4ee4");
                sessionAction.deleteInformationSession(event);
                return;
            }
        }
        String addPowerPattern = "^\\+\\[mirai:at:\\d+] +\\S+|^\u6dfb\u52a0\\[mirai:at:\\d+] +\\S+";
        String deletePowerPattern = "^-\\[mirai:at:\\d+] +\\S+|^\u5220\u9664\\[mirai:at:\\d+] +\\S+";
        String queryPowerPattern = "^[!\uff01]power( \\S+)?|^\u6743\u9650\u5217\u8868\\\\:( \\S+)?";
        if (owner || admin) {
            PowerAction powerAction = new PowerAction();
            if (Pattern.matches(addPowerPattern, code)) {
                l.info("\u6dfb\u52a0\u6743\u9650\u6307\u4ee4");
                powerAction.addOrUpdatePower(event, true);
                return;
            }
            if (Pattern.matches(deletePowerPattern, code)) {
                l.info("\u5220\u9664\u6743\u9650\u6307\u4ee4");
                powerAction.addOrUpdatePower(event, false);
                return;
            }
            if (Pattern.matches(queryPowerPattern, code)) {
                l.info("\u67e5\u8be2\u6743\u9650\u6307\u4ee4");
                powerAction.queryPower(event);
                return;
            }
        }
        String groupProhibitPattern = "^\\[mirai:at:\\d+] \\d+[sdhm]";
        if ((owner || admin || power.isGroupManage() || power.isGroupJy()) && (isGroupAdmin || isGroupOwner) && Pattern.matches(groupProhibitPattern, code)) {
            l.info("\u7981\u8a00\u6307\u4ee4");
            GroupManager.INSTANCE.prohibit(event);
            return;
        }
        String groupRecallPattern = "^[!\uff01]recall( +\\d+)?([-~]\\d+)?|^\u64a4\u56de( +\\d+)?(-\\d+)?";
        if ((owner || admin || power.isGroupManage() || power.isGroupCh()) && (isGroupAdmin || isGroupOwner) && Pattern.matches(groupRecallPattern, code)) {
            l.info("\u64a4\u56de\u6d88\u606f\u6307\u4ee4");
            GroupManager.INSTANCE.recall(event);
            return;
        }
        String kickPattern = "^tr?\\[mirai:at:\\d+] ?(hmd)?|^\u8e22\u4eba\\[mirai:at:\\d+] ?(hmd)?";
        if ((owner || admin || power.isGroupManage() || power.isGroupTr()) && (isGroupAdmin || isGroupOwner) && Pattern.matches(kickPattern, code)) {
            l.info("\u8e22\u4eba\u6307\u4ee4");
            GroupManager.kick(event);
            return;
        }
        String editGroupUserTitlePattern = "^%\\[mirai:at:\\d+] \\S+|^\u8bbe\u7f6e\u5934\u8854 \\S+";
        if ((owner || admin || power.isGroupManage()) && Pattern.matches(editGroupUserTitlePattern, code)) {
            l.info("\u8bbe\u7f6e\u5934\u8854\u6307\u4ee4");
            GroupManager.INSTANCE.editUserTitle(event);
            return;
        }
        String addProhibitedPattern = "^\\+wjc\\\\?[:\uff1a]\\S+( +\\S+)*?|^\u6dfb\u52a0\u8fdd\u7981\u8bcd\\\\?[:\uff1a]\\S+( +\\S+)*?";
        String deleteProhibitedPattern = "^-wjc\\\\?[:\uff1a]\\d+|^\u5220\u9664\u8fdd\u7981\u8bcd\\\\?[:\uff1a]\\d+";
        String queryProhibitedPattern = "^\\wjc\\\\?[:\uff1a]|^\u67e5\u8be2\u8fdd\u7981\u8bcd";
        if (owner || admin || power.isGroupManage() || power.isGroupWjc()) {
            GroupProhibitedAction groupProhibitedAction = new GroupProhibitedAction();
            if (Pattern.matches(addProhibitedPattern, code)) {
                l.info("\u6dfb\u52a0\u8fdd\u7981\u8bcd\u6307\u4ee4");
                groupProhibitedAction.addProhibited(event);
                return;
            }
            if (Pattern.matches(deleteProhibitedPattern, code)) {
                l.info("\u5220\u9664\u8fdd\u7981\u8bcd\u6307\u4ee4");
                groupProhibitedAction.deleteProhibited(event);
                return;
            }
            if (Pattern.matches(queryProhibitedPattern, code)) {
                l.info("\u67e5\u8be2\u8fdd\u7981\u8bcd\u6307\u4ee4");
                groupProhibitedAction.queryGroupProhibited(event);
                return;
            }
        }
        String addGroupWelcomeMessagePattern = "^%hyc|^\u6dfb\u52a0\u6b22\u8fce\u8bcd";
        String queryGroupWelcomeMessagePattern = "^hyc\\\\?[\uff1a:]|^\u67e5\u8be2\u6b22\u8fce\u8bcd";
        String deleteGroupWelcomeMessagePattern = "^-hyc[:\uff1a]\\d+( +\\d+)?|^\u5220\u9664\u6b22\u8fce\u8bcd\\\\?[\uff1a:]\\d+( +\\d+)?";
        if (owner || admin || power.isGroupManage() || power.isGroupHyc()) {
            GroupWelcomeInfoAction groupWelcomeInfoAction = new GroupWelcomeInfoAction();
            if (Pattern.matches(addGroupWelcomeMessagePattern, code)) {
                l.info("\u6dfb\u52a0\u6b22\u8fce\u8bcd\u6307\u4ee4");
                groupWelcomeInfoAction.addGroupWelcomeInfo(event);
                return;
            }
            if (Pattern.matches(queryGroupWelcomeMessagePattern, code)) {
                l.info("\u67e5\u8be2\u6b22\u8fce\u8bcd\u6307\u4ee4");
                groupWelcomeInfoAction.queryGroupWelcomeInfo(event);
                return;
            }
            if (Pattern.matches(deleteGroupWelcomeMessagePattern, code)) {
                l.info("\u5220\u9664\u6b22\u8fce\u8bcd\u6307\u4ee4");
                groupWelcomeInfoAction.deleteGroupWelcomeInfo(event);
                return;
            }
        }
        String addBlackListPattern = "^\\+hmd\\\\?[:\uff1a]\\[mirai:at:\\d+]( \\S+)*?|^\u6dfb\u52a0\u9ed1\u540d\u5355\\\\?[:\uff1a]\\[mirai:at:\\d+]( \\S+)*?";
        String queryBlackListPattern = "^hmd\\\\?[:\uff1a]|^\u67e5\u8be2\u9ed1\u540d\u5355";
        String deleteBlackListPattern = "^-hmd\\\\?[:\uff1a]\\d+|^\u5220\u9664\u9ed1\u540d\u5355\\\\?[:\uff1a]\\d+";
        if (owner || admin || power.isGroupManage() || power.isGroupHmd()) {
            if (Pattern.matches(addBlackListPattern, code)) {
                l.info("\u6dfb\u52a0\u9ed1\u540d\u5355\u6307\u4ee4");
                blackListAction.addBlackList(event);
                return;
            }
            if (Pattern.matches(queryBlackListPattern, code)) {
                l.info("\u67e5\u8be2\u9ed1\u540d\u5355\u6307\u4ee4");
                blackListAction.queryBlackList(event);
                return;
            }
            if (Pattern.matches(deleteBlackListPattern, code)) {
                l.info("\u5220\u9664\u9ed1\u540d\u5355\u6307\u4ee4");
                blackListAction.deleteBlackList(event);
                return;
            }
        }
        String addManySessionPattern = "^%dct|^\u6dfb\u52a0\u591a\u8bcd\u6761";
        String queryManySessionPattern = "^dct\\\\?[:\uff1a]|^\u67e5\u8be2\u591a\u8bcd\u6761";
        String deleteManySessionPattern = "^-dct\\\\?[:\uff1a]\\d+( +\\d+)*?|^\u5220\u9664\u591a\u8bcd\u6761\\\\?[:\uff1a]\\d+( +\\d+)*?";
        if (owner || admin || power.isSession() || power.isSessionDct()) {
            ManySessionAction manySessionAction = new ManySessionAction();
            if (Pattern.matches(addManySessionPattern, code)) {
                l.info("\u6dfb\u52a0\u591a\u8bcd\u6761\u6307\u4ee4");
                manySessionAction.addManySession(event);
                return;
            }
            if (Pattern.matches(queryManySessionPattern, code)) {
                l.info("\u67e5\u8be2\u591a\u8bcd\u6761\u6307\u4ee4");
                manySessionAction.queryManySession(event);
                return;
            }
            if (Pattern.matches(deleteManySessionPattern, code)) {
                l.info("\u5220\u9664\u591a\u8bcd\u6761\u6307\u4ee4");
                manySessionAction.deleteManySession(event);
                return;
            }
        }
        String addQuartzPattern = "^%ds|^\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1|^\u6dfb\u52a0\u5b9a\u65f6\u5668";
        String queryQuartzPattern = "^ds\\\\?[:\uff1a]|^\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1|^\u67e5\u8be2\u5b9a\u65f6\u5668";
        String deleteQuartzPattern = "^-ds\\\\?[:\uff1a]\\d+|^\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\\\\?[:\uff1a]\\d+|^\u5220\u9664\u5b9a\u65f6\u5668\\\\?[:\uff1a]\\d+";
        String switchQuartzPattern = "^%ds\\\\?[:\uff1a]\\d+|^\u5207\u6362\u5b9a\u65f6\u4efb\u52a1\\\\?[:\uff1a]\\d+|^\u5207\u6362\u5b9a\u65f6\u5668\\\\?[:\uff1a]\\d+";
        QuartzAction quartzAction = new QuartzAction();
        if (owner || admin || power.isDs() || power.isDscz()) {
            if (Pattern.matches(switchQuartzPattern, code)) {
                l.info("\u5207\u6362\u5b9a\u65f6\u5668\u6307\u4ee4");
                quartzAction.switchQuartz(event);
                return;
            }
            if (Pattern.matches(queryQuartzPattern, code)) {
                l.info("\u67e5\u8be2\u5b9a\u65f6\u5668\u6307\u4ee4");
                quartzAction.queryQuartz(event);
                return;
            }
        }
        if (owner || admin || power.isDs()) {
            if (Pattern.matches(addQuartzPattern, code)) {
                l.info("\u6dfb\u52a0\u5b9a\u65f6\u5668\u6307\u4ee4");
                quartzAction.addQuartz(event);
                return;
            }
            if (Pattern.matches(deleteQuartzPattern, code)) {
                l.info("\u5220\u9664\u5b9a\u65f6\u5668\u6307\u4ee4");
                quartzAction.deleteQuartz(event);
                return;
            }
        }
        this.isSessionMessage(event);
    }

    private void isSessionMessage(@NotNull MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Bot bot = event.getBot();
        Map<String, SessionInfo> sessionMap = StaticData.getSessionMap(bot);
        for (Map.Entry<String, SessionInfo> entry : sessionMap.entrySet()) {
            SessionInfo sessionInfo;
            if (!code.contains(entry.getKey())) continue;
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u5339\u914d\u89e6\u53d1\u5185\u5bb9->\u5b58\u5728");
            }
            if (!ShareUtils.mateScope(event, (sessionInfo = entry.getValue()).getScope())) continue;
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u5339\u914d\u4f5c\u7528\u57df->\u5b58\u5728");
            }
            if (!ShareUtils.mateMate(code, sessionInfo.getMate(), sessionInfo.getTerm())) continue;
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u5339\u914d\u5339\u914d\u65b9\u5f0f->\u6210\u529f");
            }
            Dialogue.INSTANCE.dialogueSession(event, sessionInfo);
            return;
        }
        Map<String, ManySessionInfo> manySession = StaticData.getManySession(bot);
        for (Map.Entry<String, ManySessionInfo> entry : manySession.entrySet()) {
            ManySessionInfo manySessionInfo;
            if (!code.contains(entry.getKey())) continue;
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u5339\u914d\u89e6\u53d1\u5185\u5bb9->\u5b58\u5728");
            }
            if (!ShareUtils.mateScope(event, (manySessionInfo = entry.getValue()).getScope())) continue;
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u5339\u914d\u4f5c\u7528\u57df->\u5b58\u5728");
            }
            if (!ShareUtils.mateMate(code, manySessionInfo.getMate(), manySessionInfo.getTrigger())) continue;
            if (ConfigData.INSTANCE.getDebugSwitch()) {
                l.info("\u5339\u914d\u5339\u914d\u65b9\u5f0f->\u6210\u529f");
            }
            Dialogue.INSTANCE.dialogueSession(event, manySessionInfo);
            return;
        }
    }
}

