/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.event;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.BlackListData;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.manage.GroupManager;
import java.util.Objects;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.event.EventHandler;
import net.mamoe.mirai.event.SimpleListenerHost;
import net.mamoe.mirai.event.events.GroupEvent;
import net.mamoe.mirai.event.events.MemberJoinEvent;
import net.mamoe.mirai.event.events.MemberJoinRequestEvent;
import net.mamoe.mirai.event.events.MemberLeaveEvent;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

public class GroupEventListener
extends SimpleListenerHost {
    private static final MiraiLogger l = HuYanSession.INSTANCE.getLogger();

    @EventHandler
    public void onMessage(@NotNull GroupEvent event) {
        MemberPermission botPermission = event.getGroup().getBotPermission();
        if (botPermission == MemberPermission.MEMBER) {
            return;
        }
        if (event instanceof MemberJoinEvent) {
            MemberJoinEvent memberJoinEvent = (MemberJoinEvent)event;
            if (GroupManager.detectBlackList(memberJoinEvent)) {
                return;
            }
            GroupManager.userJoinGroup(memberJoinEvent);
        }
    }

    @EventHandler
    public void onMessageTwo(@NotNull MemberJoinRequestEvent event) {
        long groupId = event.getGroupId();
        MemberPermission botPermission = Objects.requireNonNull(event.getGroup()).getBotPermission();
        if (botPermission == MemberPermission.MEMBER) {
            return;
        }
        if (!ConfigData.INSTANCE.getGroupList().contains(groupId)) {
            return;
        }
        if (GroupManager.detectBlackList(event)) {
            return;
        }
        GroupManager.userRequestGroup(event);
    }

    @EventHandler
    public void onMessageThree(@NotNull MemberLeaveEvent event) {
        long groupId = event.getGroupId();
        MemberPermission botPermission = event.getGroup().getBotPermission();
        if (botPermission == MemberPermission.MEMBER) {
            return;
        }
        if (!ConfigData.INSTANCE.getGroupList().contains(groupId)) {
            return;
        }
        if (BlackListData.INSTANCE.isAutoBlackList()) {
            GroupManager.autoAddBlackList(event);
        }
    }
}

