/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.entity.SessionInfo;
import cn.chahuyun.enums.Mate;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ListUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.ForwardMessage;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageKey;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class SessionAction {
    public static void init(boolean type) {
        List sessionInfos;
        try {
            sessionInfos = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = criteriaBuilder.createQuery(SessionInfo.class);
                JpaRoot from = query.from(SessionInfo.class);
                query.select((Selection)from);
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u4f1a\u8bdd\u6570\u636e\u52a0\u8f7d\u5931\u8d25:", (Throwable)e);
            return;
        }
        HashMap<Long, Map<String, SessionInfo>> sessionAll = new HashMap<Long, Map<String, SessionInfo>>();
        if (sessionInfos != null && !sessionInfos.isEmpty()) {
            for (final SessionInfo entity : sessionInfos) {
                if (!sessionAll.containsKey(entity.getBot())) {
                    sessionAll.put(entity.getBot(), (Map<String, SessionInfo>)new HashMap<String, SessionInfo>(){
                        {
                            this.put(entity.getTerm(), entity);
                        }
                    });
                    continue;
                }
                Map sessionMap = (Map)sessionAll.get(entity.getBot());
                if (sessionMap.containsKey(entity.getTerm())) continue;
                ((Map)sessionAll.get(entity.getBot())).put(entity.getTerm(), entity);
            }
            StaticData.setSessionMap(sessionAll);
        } else {
            StaticData.setSessionMap(sessionAll);
        }
        if (ConfigData.INSTANCE.getDebugSwitch() && type) {
            HuYanSession.log.info("\u6570\u636e\u5e93\u4f1a\u8bdd\u4fe1\u606f\u521d\u59cb\u5316\u6210\u529f!");
            return;
        }
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            HuYanSession.log.info("\u4f1a\u8bdd\u6570\u636e\u66f4\u65b0\u6210\u529f!");
        }
    }

    public void studySession(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        String[] split = code.split("\\s+");
        String key = split[1];
        String value = split[2];
        if (StaticData.isSessionKey(bot, key)) {
            subject.sendMessage("\u6211\u5df2\u7ecf\u5b66\u5e9f\u4e86" + key + "!\u4e0d\u80fd\u518d\u5b66\u4e86!");
            return;
        }
        int type = 0;
        String typePattern = "\\[mirai:image\\S+]";
        if (Pattern.matches(typePattern, key) || Pattern.matches(typePattern, value)) {
            type = 1;
        }
        boolean dynamic = false;
        Pattern compile = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
        if (compile.matcher(key).find() || compile.matcher(value).find()) {
            dynamic = true;
        }
        Mate mate = Mate.ACCURATE;
        Scope scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), -1);
        int minIndex = 3;
        if (split.length > minIndex) {
            block16: for (int i = minIndex; i < split.length; ++i) {
                String s;
                switch (s = split[i]) {
                    case "2": 
                    case "\u6a21\u7cca": {
                        mate = Mate.VAGUE;
                        continue block16;
                    }
                    case "3": 
                    case "\u5934\u90e8": {
                        mate = Mate.START;
                        continue block16;
                    }
                    case "4": 
                    case "\u7ed3\u5c3e": {
                        mate = Mate.END;
                        continue block16;
                    }
                    case "0": 
                    case "\u5168\u5c40": {
                        scope = new Scope(bot.getId(), "\u5168\u5c40", true, false, subject.getId(), -1);
                        continue block16;
                    }
                    default: {
                        String listPattern = "gr\\d+|\u7fa4\u7ec4\\d+";
                        if (!Pattern.matches(listPattern, s)) continue block16;
                        int listId = Integer.parseInt(s.substring(2));
                        if (ListUtil.isContainsList(bot, listId)) {
                            subject.sendMessage("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728!");
                            return;
                        }
                        scope = new Scope(bot.getId(), "\u7fa4\u7ec4" + listId, false, true, subject.getId(), listId);
                    }
                }
            }
        }
        if (subject instanceof User && !scope.getGlobal() && scope.getGroupInfo()) {
            subject.sendMessage("\u79c1\u53d1\u5b66\u4e60\u8bf7\u8f93\u5165\u4f5c\u7528\u57df\uff01");
            return;
        }
        this.saveSession(subject, bot, key, value, mate, scope, type, dynamic);
    }

    public void querySession(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        SessionAction.init(false);
        String querySessionPattern = "xx\\\\?[:\uff1a](\\S+)|\u67e5\u8be2 +\\S+";
        boolean type = Pattern.matches(querySessionPattern, code);
        if (type) {
            Map<String, SessionInfo> sessionMap;
            String[] split = code.split("[:\uff1a]| +");
            String key = split[1];
            try {
                sessionMap = StaticData.getSessionMap(bot);
            }
            catch (Exception e) {
                subject.sendMessage("\u67e5\u8be2\u4f1a\u8bdd\u6d88\u606f\u4e3a\u7a7a!");
                return;
            }
            if (sessionMap == null) {
                subject.sendMessage("\u6211\u4e0d\u592a\u4f1a\u8bb2\u53d1~!");
                return;
            }
            if (sessionMap.containsKey(key)) {
                SessionInfo sessionInfo = sessionMap.get(key);
                String trigger = this.judgeScope(event, subject, sessionInfo);
                subject.sendMessage("\u67e5\u8be2\u5230\u5bf9\u5e94\u4f1a\u8bdd:\n" + sessionInfo.getTerm() + "==>" + sessionInfo.getReply() + "\n\u5339\u914d\u65b9\u5f0f:" + sessionInfo.getMate().getMateName() + "\n\u89e6\u53d1\u8303\u56f4:" + trigger);
                return;
            }
            subject.sendMessage("\u6211\u4e0d\u662f\u5f88\u4f1a\u8bb2\u53d1~");
            return;
        }
        ForwardMessage forwardMessage = this.parseMessage(event);
        if (forwardMessage != null) {
            subject.sendMessage((Message)forwardMessage);
        }
    }

    public void studyDialogue(MessageEvent event) {
        String[] split;
        Contact subject = event.getSubject();
        User user = event.getSender();
        Bot bot = event.getBot();
        subject.sendMessage("\u5f00\u59cb\u6dfb\u52a0\u5bf9\u8bdd\uff0c\u8bf7\u8f93\u5165\u89e6\u53d1\u5185\u5bb9:");
        event.intercept();
        MessageEvent nextMessageEventFromUser = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextMessageEventFromUser)) {
            return;
        }
        String key = nextMessageEventFromUser.getMessage().serializeToMiraiCode();
        subject.sendMessage("\u8bf7\u53d1\u9001\u56de\u590d\u6d88\u606f:");
        nextMessageEventFromUser = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextMessageEventFromUser)) {
            return;
        }
        MessageChain valueChain = nextMessageEventFromUser.getMessage();
        subject.sendMessage("\u8bf7\u53d1\u9001\u53c2\u6570(\u4e00\u6b21\u53d1\u9001\uff0c\u591a\u53c2\u6570\u4e2d\u95f4\u9694\u5f00):");
        nextMessageEventFromUser = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextMessageEventFromUser)) {
            return;
        }
        String param = nextMessageEventFromUser.getMessage().serializeToMiraiCode();
        Mate mate = Mate.ACCURATE;
        Scope scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), 0);
        String[] stringArray = split = param.split(" +");
        int n = stringArray.length;
        block16: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "2": 
                case "\u6a21\u7cca": {
                    mate = Mate.VAGUE;
                    continue block16;
                }
                case "3": 
                case "\u5934\u90e8": {
                    mate = Mate.START;
                    continue block16;
                }
                case "4": 
                case "\u7ed3\u5c3e": {
                    mate = Mate.END;
                    continue block16;
                }
                case "0": 
                case "\u5168\u5c40": {
                    scope = new Scope(bot.getId(), "\u5168\u5c40", true, false, subject.getId(), -1);
                    continue block16;
                }
                default: {
                    String listPattern = "gr\\d+|\u7fa4\u7ec4\\d+";
                    if (!Pattern.matches(listPattern, s)) continue block16;
                    int listId = Integer.parseInt(s.substring(2));
                    if (ListUtil.isContainsList(bot, listId)) {
                        subject.sendMessage("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728!");
                        return;
                    }
                    scope = new Scope(bot.getId(), "\u7fa4\u7ec4" + listId, false, true, subject.getId(), listId);
                }
            }
        }
        if (subject instanceof User && !scope.getGlobal() && scope.getGroupInfo()) {
            subject.sendMessage("\u79c1\u53d1\u5b66\u4e60\u8bf7\u8f93\u5165\u4f5c\u7528\u57df\uff01");
            return;
        }
        String value = valueChain.serializeToMiraiCode();
        int type = 0;
        String typePattern = "\\[mirai:image\\S+]";
        if (Pattern.matches(typePattern, key) || Pattern.matches(typePattern, value)) {
            type = 1;
        }
        boolean dynamic = false;
        Pattern compile = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
        if (compile.matcher(key).find() || compile.matcher(value).find()) {
            dynamic = true;
        }
        if (valueChain.contains((MessageKey)ForwardMessage.Key) || valueChain.contains((MessageKey)Audio.Key)) {
            type = 5;
            dynamic = false;
            value = MessageChain.serializeToJsonString((MessageChain)valueChain);
        }
        this.saveSession(subject, bot, key, value, mate, scope, type, dynamic);
    }

    public void deleteSession(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        String[] split = code.split("[:\uff1a]");
        if (split.length == 1) {
            split = code.split(" +");
        }
        String key = split[1];
        this.deleteMessage(subject, bot, key);
    }

    public void deleteInformationSession(MessageEvent event) {
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        User user = event.getSender();
        subject.sendMessage("\u8bf7\u53d1\u9001\u9700\u8981\u5220\u9664\u7684\u6d88\u606f");
        MessageEvent eventFromUser = ShareUtils.getNextMessageEventFromUser(user);
        String key = eventFromUser.getMessage().serializeToMiraiCode();
        this.deleteMessage(subject, bot, key);
    }

    private void deleteMessage(Contact subject, Bot bot, String key) {
        Map<String, SessionInfo> sessionMap = StaticData.getSessionMap(bot);
        if (!sessionMap.containsKey(key)) {
            subject.sendMessage("\u6ca1\u6709\u627e\u5230\u5fd8\u6389\u7684\u4e1c\u897f...");
            return;
        }
        SessionInfo sessionInfo = sessionMap.get(key);
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                session.remove((Object)sessionInfo);
                return 0;
            });
        }
        catch (Exception e) {
            subject.sendMessage("\u51fa\u9519\u5566~~");
            e.printStackTrace();
            return;
        }
        subject.sendMessage("\u6211\u597d\u50cf\u5fd8\u8bb0\u4e86\u70b9\u5565?");
        SessionAction.init(false);
    }

    private void saveSession(Contact subject, Bot bot, String key, String value, Mate mate, Scope scope, int type, boolean dynamic) {
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                SessionInfo sessionInfoEntity = new SessionInfo(bot.getId(), type, key, value, mate, scope, dynamic);
                if (ScopeUtil.isScopeEmpty(scope)) {
                    session.persist((Object)scope);
                }
                session.persist((Object)sessionInfoEntity);
                return 0;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u6dfb\u52a0\u5bf9\u8bdd\u5931\u8d25:" + e.getMessage());
            subject.sendMessage("\u5b66\u4e0d\u5e9f!");
            e.printStackTrace();
            return;
        }
        subject.sendMessage("\u5b66\u5e9f\u4e86!");
        SessionAction.init(false);
    }

    private String judgeScope(MessageEvent event, Contact subject, SessionInfo sessionInfo) {
        Object trigger = "\u5176\u4ed6\u7fa4\u89e6\u53d1";
        long groupId = event.getSubject().getId();
        Scope scopeInfo = sessionInfo.getScope();
        if (scopeInfo.getGlobal()) {
            trigger = "\u5168\u5c40\u89e6\u53d1";
        } else if (scopeInfo.getGroupInfo()) {
            trigger = "\u7fa4\u7ec4:" + scopeInfo.getListId() + "\u89e6\u53d1";
        } else if (scopeInfo.getGroupNumber() == groupId) {
            trigger = "\u5f53\u524d\u7fa4\u89e6\u53d1";
        }
        return trigger;
    }

    private ForwardMessage parseMessage(MessageEvent event) {
        Map<String, SessionInfo> sessionMap;
        Contact group = event.getSubject();
        Bot bot = event.getBot();
        ForwardMessageBuilder nodes = new ForwardMessageBuilder(group);
        try {
            sessionMap = StaticData.getSessionMap(bot);
        }
        catch (Exception e) {
            group.sendMessage("\u67e5\u8be2\u4f1a\u8bdd\u6d88\u606f\u4e3a\u7a7a!");
            e.printStackTrace();
            return null;
        }
        if (sessionMap == null) {
            group.sendMessage("\u4f1a\u8bdd\u6d88\u606f\u4e3a\u7a7a!");
            return null;
        }
        MessageChainBuilder table = new MessageChainBuilder();
        MessageChainBuilder accurate = new MessageChainBuilder();
        MessageChainBuilder vague = new MessageChainBuilder();
        MessageChainBuilder start = new MessageChainBuilder();
        MessageChainBuilder end = new MessageChainBuilder();
        MessageChainBuilder other = new MessageChainBuilder();
        MessageChainBuilder special = new MessageChainBuilder();
        table.append((CharSequence)"\u4ee5\u4e0b\u4e3a\u6240\u6709\u67e5\u8be2\u5230\u7684\u89e6\u53d1\u5173\u952e\u8bcd\u7ed3\u679c\u2193");
        nodes.add((UserOrBot)bot, (Message)table.build());
        accurate.append((CharSequence)"\u6240\u6709\u7684\u7cbe\u51c6\u5339\u914d\u89e6\u53d1\u6d88\u606f:\n");
        vague.append((CharSequence)"\u6240\u6709\u7684\u6a21\u7cca\u5339\u914d\u89e6\u53d1\u6d88\u606f:\n");
        start.append((CharSequence)"\u6240\u6709\u7684\u5934\u90e8\u5339\u914d\u89e6\u53d1\u6d88\u606f:\n");
        end.append((CharSequence)"\u6240\u6709\u7684\u7ed3\u5c3e\u5339\u914d\u89e6\u53d1\u6d88\u606f:\n");
        other.append((CharSequence)"\u6240\u6709\u7684\u5176\u4ed6\u5339\u914d\u89e6\u53d1\u6d88\u606f:\n");
        special.append((CharSequence)"\u6240\u6709\u7684\u7279\u6b8a\u5339\u914d\u89e6\u53d1\u6d88\u606f:\n");
        ArrayList<SessionInfo> values = new ArrayList<SessionInfo>(sessionMap.values());
        for (SessionInfo base : values) {
            String trigger = this.judgeScope(event, group, base);
            block1 : switch (base.getType()) {
                case 0: {
                    switch (base.getMate()) {
                        case ACCURATE: {
                            accurate.append((CharSequence)base.getTerm()).append((CharSequence)" ==> ").append((CharSequence)base.getReply()).append((CharSequence)" -> ").append((CharSequence)trigger).append((CharSequence)"\n");
                            break block1;
                        }
                        case VAGUE: {
                            vague.append((CharSequence)base.getTerm()).append((CharSequence)" ==> ").append((CharSequence)base.getReply()).append((CharSequence)" -> ").append((CharSequence)trigger).append((CharSequence)"\n");
                            break block1;
                        }
                        case START: {
                            start.append((CharSequence)base.getTerm()).append((CharSequence)" ==> ").append((CharSequence)base.getReply()).append((CharSequence)" -> ").append((CharSequence)trigger).append((CharSequence)"\n");
                            break block1;
                        }
                        case END: {
                            end.append((CharSequence)base.getTerm()).append((CharSequence)" ==> ").append((CharSequence)base.getReply()).append((CharSequence)" -> ").append((CharSequence)trigger).append((CharSequence)"\n");
                            break block1;
                        }
                    }
                    break;
                }
                case 1: {
                    other.append((Message)MiraiCode.deserializeMiraiCode((String)base.getTerm())).append((CharSequence)" ==> ").append((Message)MiraiCode.deserializeMiraiCode((String)base.getReply())).append((CharSequence)" -> ").append((CharSequence)trigger).append((CharSequence)":").append((CharSequence)base.getMate().getMateName()).append((CharSequence)"\n");
                    break;
                }
                case 5: {
                    special.append((Message)MiraiCode.deserializeMiraiCode((String)base.getTerm())).append((CharSequence)" ==> ").append((CharSequence)MessageChain.deserializeFromJsonString((String)base.getReply()).contentToString()).append((CharSequence)" -> ").append((CharSequence)trigger).append((CharSequence)":").append((CharSequence)base.getMate().getMateName()).append((CharSequence)"\n");
                }
            }
        }
        nodes.add((UserOrBot)bot, (Message)accurate.build());
        nodes.add((UserOrBot)bot, (Message)vague.build());
        nodes.add((UserOrBot)bot, (Message)start.build());
        nodes.add((UserOrBot)bot, (Message)end.build());
        nodes.add((UserOrBot)bot, (Message)other.build());
        nodes.add((UserOrBot)bot, (Message)special.build());
        return nodes.build();
    }
}

