/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.entity.ManySession;
import cn.chahuyun.entity.QuartzInfo;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.manage.QuartzManager;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ListUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Audio;
import net.mamoe.mirai.message.data.ForwardMessage;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageKey;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class QuartzAction {
    public static void init(boolean type) {
        List quartzInfos = (List)HibernateUtil.factory.fromTransaction(session -> {
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            JpaCriteriaQuery query = builder.createQuery(QuartzInfo.class);
            JpaRoot from = query.from(QuartzInfo.class);
            query.select((Selection)from);
            return session.createQuery((CriteriaQuery)query).list();
        });
        for (QuartzInfo quartzInfo : quartzInfos) {
            boolean addSchedulerJob;
            if (quartzInfo.isStatus() || !(addSchedulerJob = QuartzManager.addSchedulerJob(quartzInfo))) continue;
            quartzInfo.setStatus(true);
            QuartzAction.updateQuartz(quartzInfo);
        }
        HuYanSession.log.info("\u5b9a\u65f6\u5668\u52a0\u8f7d\u6210\u529f!");
    }

    public void addQuartz(MessageEvent event) {
        String[] params;
        User user = event.getSender();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        subject.sendMessage("\u8bf7\u8f93\u5165\u5b9a\u65f6\u5668\u540d\u79f0:");
        MessageEvent nextNameEvent = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextNameEvent)) {
            return;
        }
        String name = nextNameEvent.getMessage().serializeToMiraiCode();
        String cron = null;
        boolean cronSure = true;
        while (cronSure) {
            subject.sendMessage("\u8bf7\u8f93\u5165\u5b9a\u65f6\u5668\u9891\u7387(cron\u8868\u8fbe\u5f0f):");
            MessageEvent nextCronStringEvent = ShareUtils.getNextMessageEventFromUser(user);
            if (ShareUtils.isQuit(nextCronStringEvent)) {
                return;
            }
            String cronString = nextCronStringEvent.getMessage().contentToString();
            Matcher matcher = Pattern.compile("^\\$cron\\(\\S+?( +\\S+){5}?\\)").matcher(cronString);
            if (!matcher.find()) {
                subject.sendMessage("\u6c92\u6709\u8bc6\u522b\u5230cron\u8868\u8fbe\u5f0f!\u8bf7\u91cd\u65b0\u8f93\u5165");
                continue;
            }
            cron = matcher.group().split("\\(")[1].split("\\)")[0];
            subject.sendMessage(String.format("\u8bc6\u522b\u5230cron\u8868\u8fbe\u5f0f-> %s <- \u662f\u5426\u786e\u8ba4", cron));
            MessageEvent nextCronStringSure = ShareUtils.getNextMessageEventFromUser(user);
            if (ShareUtils.isQuit(nextCronStringSure)) {
                return;
            }
            String nextCronStringSureCode = nextCronStringSure.getMessage().serializeToMiraiCode();
            if (!Pattern.matches("!|\uff01|1|ok|\u786e\u8ba4", nextCronStringSureCode)) continue;
            cronSure = false;
        }
        subject.sendMessage("\u8bf7\u8f93\u5165\u5b9a\u65f6\u5668\u53c2\u6570:(\u53c2\u6570\u4e2d\u95f4\u4ee5\u7a7a\u683c\u9694\u5f00)");
        MessageEvent nextParamsEvent = ShareUtils.getNextMessageEventFromUser(user);
        if (ShareUtils.isQuit(nextParamsEvent)) {
            return;
        }
        boolean isPolling = false;
        boolean isRandom = false;
        Scope scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), -1);
        String[] stringArray = params = nextParamsEvent.getMessage().serializeToMiraiCode().split(" +");
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String param;
            switch (param = stringArray[i]) {
                case "lx": 
                case "\u8f6e\u8be2": {
                    isPolling = true;
                    continue block14;
                }
                case "sj": 
                case "\u968f\u673a": {
                    isRandom = true;
                    continue block14;
                }
                case "0": 
                case "\u5168\u5c40": {
                    scope = new Scope(bot.getId(), "\u5168\u5c40", true, false, subject.getId(), -1);
                    continue block14;
                }
                default: {
                    String listPattern = "gr\\d+|\u7fa4\u7ec4\\d+";
                    if (!Pattern.matches(listPattern, param)) continue block14;
                    int listId = Integer.parseInt(param.substring(2));
                    if (ListUtil.isContainsList(bot, listId)) {
                        subject.sendMessage("\u8be5\u7fa4\u7ec4\u4e0d\u5b58\u5728!");
                        return;
                    }
                    scope = new Scope(bot.getId(), "\u7fa4\u7ec4" + listId, false, true, subject.getId(), listId);
                }
            }
        }
        if (!isPolling && !isRandom) {
            QuartzInfo quartzInfo;
            subject.sendMessage("\u8bf7\u8f93\u5165\u53d1\u9001\u5185\u5bb9:");
            MessageEvent nextReplyEvent = ShareUtils.getNextMessageEventFromUser(user);
            if (ShareUtils.isQuit(nextReplyEvent)) {
                return;
            }
            MessageChain nextReplyEventMessage = nextReplyEvent.getMessage();
            String miraiCode = nextReplyEventMessage.serializeToMiraiCode();
            boolean dynamic = false;
            Pattern compile = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
            if (compile.matcher(miraiCode).find() || compile.matcher(miraiCode).find()) {
                dynamic = true;
            }
            boolean other = false;
            if (nextReplyEventMessage.contains((MessageKey)ForwardMessage.Key) || nextReplyEventMessage.contains((MessageKey)Audio.Key)) {
                dynamic = false;
                other = true;
                miraiCode = MessageChain.serializeToJsonString((MessageChain)nextReplyEventMessage);
            }
            if (this.saveQuartz(quartzInfo = new QuartzInfo(bot.getId(), name, cron, dynamic, other, miraiCode, false, false, scope), scope)) {
                subject.sendMessage(String.format("\u5b9a\u65f6\u4efb\u52a1 %s \u6dfb\u52a0\u6210\u529f!", name));
                return;
            }
            subject.sendMessage(String.format("\u5b9a\u65f6\u4efb\u52a1 %s \u6dfb\u52a0\u5931\u8d25!", name));
            return;
        }
        QuartzInfo quartzInfo = new QuartzInfo(bot.getId(), name, cron, false, false, "miraiCode", isPolling, isRandom, scope);
        List<ManySession> manySessions = quartzInfo.getManySessions();
        boolean isQuit = false;
        while (!isQuit) {
            subject.sendMessage("\u8bf7\u53d1\u9001\u591a\u8bcd\u6761\u56de\u590d\u6d88\u606f:");
            MessageEvent nextEvent = ShareUtils.getNextMessageEventFromUser(user);
            if (ShareUtils.isQuit(nextEvent)) {
                return;
            }
            MessageChain nextEventMessage = nextEvent.getMessage();
            String miraiCode = nextEventMessage.serializeToMiraiCode();
            if (miraiCode.equals("\uff01\uff01") || miraiCode.equals("!!")) {
                isQuit = true;
            }
            if ((miraiCode.equals("\uff01") || miraiCode.equals("!")) && manySessions.size() > 2) {
                manySessions.remove(manySessions.size() - 1);
                subject.sendMessage("\u5220\u9664\u4e0a\u4e00\u6761\u56de\u590d\u6d88\u606f\u6210\u529f\uff01");
                continue;
            }
            boolean dynamic = false;
            Pattern compile = Pattern.compile(ShareUtils.DYNAMIC_MESSAGE_PATTERN);
            if (compile.matcher(miraiCode).find() || compile.matcher(miraiCode).find()) {
                dynamic = true;
            }
            boolean other = false;
            if (nextEventMessage.contains((MessageKey)ForwardMessage.Key) || nextEventMessage.contains((MessageKey)Audio.Key)) {
                dynamic = false;
                other = true;
                miraiCode = MessageChain.serializeToJsonString((MessageChain)nextEventMessage);
            }
            ManySession manySession = new ManySession(bot.getId(), dynamic, other, miraiCode);
            manySessions.add(manySession);
            subject.sendMessage("\u6dfb\u52a0\u6210\u529f!");
        }
        if (this.saveQuartz(quartzInfo, scope)) {
            subject.sendMessage(String.format("\u5b9a\u65f6\u4efb\u52a1 %s \u6dfb\u52a0\u6210\u529f!", name));
            return;
        }
        subject.sendMessage(String.format("\u5b9a\u65f6\u4efb\u52a1 %s \u6dfb\u52a0\u5931\u8d25!", name));
    }

    public void queryQuartz(MessageEvent event) {
        List quartzInfos;
        Bot bot = event.getBot();
        Contact subject = event.getSubject();
        try {
            quartzInfos = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(QuartzInfo.class);
                JpaRoot from = query.from(QuartzInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u62c9~", (Throwable)e);
            subject.sendMessage("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519!");
            return;
        }
        if (quartzInfos == null || quartzInfos.isEmpty()) {
            subject.sendMessage("\u5b9a\u65f6\u4efb\u52a1\u4e3a\u7a7a\uff01");
            return;
        }
        ForwardMessageBuilder builder = new ForwardMessageBuilder(subject);
        builder.add((UserOrBot)bot, (Message)new PlainText("\u4ee5\u4e0b\u662f\u6240\u6709\u591a\u8bcd\u6761\u6d88\u606f\u2193"));
        for (QuartzInfo value : quartzInfos) {
            List<ManySession> manySessions = value.getManySessions();
            MessageChainBuilder chainBuilder = new MessageChainBuilder();
            chainBuilder.add((SingleMessage)new PlainText(String.format("\u5b9a\u65f6\u5668\u6761\u7f16\u53f7:%d%n\u5b9a\u65f6\u5668\u540d\u79f0:%s%n\u5b9a\u65f6\u5668\u9891\u7387: %s%n", value.getId(), value.getName(), value.getCronString())));
            new PlainText(String.format("\u5b9a\u65f6\u5668\u662f\u5426\u5f00\u542f:%s%n", value.isStatus() ? "\u5f00\u542f" : "\u5173\u95ed"));
            new PlainText(String.format("\u4f5c\u7528\u57df:%s%n", value.getScope().getScopeName()));
            new PlainText(String.format("\u5f53\u524d\u7fa4\u662f\u5426\u89e6\u53d1:%b", ShareUtils.mateScope(event, value.getScope()) ? "\u662f" : "\u5426"));
            if (value.isPolling() && value.isRandom()) {
                chainBuilder.add((SingleMessage)new PlainText("\u5b9a\u65f6\u5668\u56de\u590d\u5185\u5bb9:"));
                chainBuilder.add((Message)MiraiCode.deserializeMiraiCode((String)value.getReply()));
            } else {
                chainBuilder.add((SingleMessage)new PlainText(String.format("\u5b9a\u65f6\u5668\u56de\u590d\u65b9\u5f0f:%s", value.isPolling() ? "\u8f6e\u8be2" : "\u968f\u673a")));
            }
            builder.add((UserOrBot)bot, (Message)chainBuilder.build());
            if (value.isPolling() && value.isRandom()) continue;
            ForwardMessageBuilder messageBuilder = new ForwardMessageBuilder(subject);
            for (ManySession session2 : manySessions) {
                if (session2.isOther()) {
                    messageBuilder.add((UserOrBot)bot, (Message)new PlainText(String.format("\u7f16\u53f7:%s", session2.getId())));
                    MessageChain singleMessages = MessageChain.deserializeFromJsonString((String)session2.getReply());
                    messageBuilder.add((UserOrBot)bot, (Message)singleMessages);
                    continue;
                }
                MessageChainBuilder messageChainBuilder = new MessageChainBuilder();
                messageChainBuilder.add(String.format("\u7f16\u53f7:%s%n", session2.getId()));
                messageChainBuilder.add((Message)MiraiCode.deserializeMiraiCode((String)session2.getReply()));
                messageBuilder.add((UserOrBot)bot, (Message)messageChainBuilder.build());
            }
        }
    }

    public void deleteQuartz(MessageEvent event) {
        List quartzInfos;
        Bot bot = event.getBot();
        Contact subject = event.getSubject();
        String code = event.getMessage().serializeToMiraiCode();
        String id = code.split("[:\uff1a]")[1];
        try {
            quartzInfos = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(QuartzInfo.class);
                JpaRoot from = query.from(QuartzInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                query.where((Expression)builder.equal((Expression)from.get("id"), (Object)id));
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u62c9~", (Throwable)e);
            subject.sendMessage("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519!");
            return;
        }
        if (quartzInfos == null || quartzInfos.isEmpty()) {
            subject.sendMessage("\u8be5\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
            return;
        }
        QuartzInfo quartzInfo = (QuartzInfo)quartzInfos.get(0);
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                session.remove((Object)quartzInfo);
                return true;
            });
        }
        catch (Exception e) {
            subject.sendMessage("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u5931\u8d25!");
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return;
        }
        subject.sendMessage("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u6210\u529f!");
    }

    public void switchQuartz(MessageEvent event) {
        QuartzInfo quartzInfo;
        List quartzInfos;
        Bot bot = event.getBot();
        Contact subject = event.getSubject();
        String code = event.getMessage().serializeToMiraiCode();
        String id = code.split("[:\uff1a]")[1];
        try {
            quartzInfos = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(QuartzInfo.class);
                JpaRoot from = query.from(QuartzInfo.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                query.where((Expression)builder.equal((Expression)from.get("id"), (Object)id));
                return session.createQuery((CriteriaQuery)query).list();
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u62c9~", (Throwable)e);
            subject.sendMessage("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519!");
            return;
        }
        if (quartzInfos == null || quartzInfos.isEmpty()) {
            subject.sendMessage("\u8be5\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
            return;
        }
        quartzInfo.setStatus(!(quartzInfo = (QuartzInfo)quartzInfos.get(0)).isStatus());
        if (QuartzManager.addSchedulerJob(quartzInfo)) {
            subject.sendMessage(String.format("\u5b9a\u65f6\u5668 %s %s\u6210\u529f!", quartzInfo.getName(), quartzInfo.isStatus() ? "\u5f00\u542f" : "\u5173\u95ed"));
            QuartzAction.updateQuartz(quartzInfo);
            return;
        }
        subject.sendMessage(String.format("\u5b9a\u65f6\u5668 %s %s\u5931\u8d25!", quartzInfo.getName(), !quartzInfo.isStatus() ? "\u5f00\u542f" : "\u5173\u95ed"));
    }

    public static void increase(QuartzInfo quartzInfo) {
        quartzInfo.setPollingNumber(quartzInfo.getPollingNumber() + 1);
        HibernateUtil.factory.fromTransaction(session -> (QuartzInfo)session.merge((Object)quartzInfo));
    }

    private static void updateQuartz(QuartzInfo quartzInfo) {
        HibernateUtil.factory.fromTransaction(session -> (QuartzInfo)session.merge((Object)quartzInfo));
    }

    private boolean saveQuartz(QuartzInfo quartzInfo, Scope scope) {
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                if (ScopeUtil.isScopeEmpty(scope)) {
                    session.persist(session);
                }
                session.persist((Object)quartzInfo);
                return true;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return false;
        }
        return true;
    }
}

