/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.Power;
import cn.chahuyun.utils.HibernateUtil;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.NormalMemberKt;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.ConcurrencyKind;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.EventPriority;
import net.mamoe.mirai.event.GlobalEventChannel;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.SingleMessage;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class PowerAction {
    public static void init(boolean type) {
        List powerList = (List)HibernateUtil.factory.fromTransaction(session -> {
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            JpaCriteriaQuery query = builder.createQuery(Power.class);
            JpaRoot from = query.from(Power.class);
            query.select((Selection)from);
            return session.createQuery((CriteriaQuery)query).list();
        });
        Map<Long, Map<String, Power>> map = PowerAction.parseList(powerList);
        StaticData.setPowerMap(map);
        if (ConfigData.INSTANCE.getDebugSwitch() && type) {
            HuYanSession.log.info("\u6570\u636e\u5e93\u6743\u9650\u4fe1\u606f\u521d\u59cb\u5316\u6210\u529f!");
            return;
        }
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            HuYanSession.log.info("\u6743\u9650\u4fe1\u606f\u66f4\u65b0\u6210\u529f!");
        }
    }

    public void addOrUpdatePower(MessageEvent event, boolean type) {
        String value;
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        long user = 0L;
        long group = subject instanceof Group ? subject.getId() : 0L;
        MessageChain message = event.getMessage();
        for (SingleMessage singleMessage : message) {
            if (!(singleMessage instanceof At)) continue;
            user = ((At)singleMessage).getTarget();
        }
        String mark = group + "." + user;
        Map<String, Power> powerMap = StaticData.getPowerMap(bot);
        Power power = null;
        if (powerMap == null || powerMap.isEmpty() || !powerMap.containsKey(mark)) {
            power = new Power(bot.getId(), group, user);
        } else if (powerMap.containsKey(mark)) {
            power = powerMap.get(mark);
        }
        switch (value = code.split(" +")[1]) {
            case "admin": {
                power.setAdmin(type);
                break;
            }
            case "list": {
                power.setGroupList(type);
                break;
            }
            case "session": {
                power.setSession(type);
                break;
            }
            case "sessionX": 
            case "sessionx": {
                power.setSessionX(type);
                break;
            }
            case "sessionDct": 
            case "sessiondct": {
                power.setSessionDct(type);
                break;
            }
            case "ds": {
                power.setDs(type);
                break;
            }
            case "dscz": {
                power.setDscz(type);
                break;
            }
            case "group": {
                power.setGroupManage(type);
                break;
            }
            case "grouphyc": 
            case "groupHyc": {
                power.setGroupHyc(type);
                break;
            }
            case "groupjy": 
            case "groupJy": {
                power.setGroupJy(type);
                break;
            }
            case "groupHmd": 
            case "grouphmd": {
                power.setGroupHmd(type);
                break;
            }
            case "groupch": 
            case "groupCh": {
                power.setGroupCh(type);
                break;
            }
            case "groupTr": 
            case "grouptr": {
                power.setGroupTr(type);
                break;
            }
            case "all": {
                if (!type) break;
                power.setAll();
                break;
            }
            default: {
                subject.sendMessage("\u672a\u8bc6\u522b\u6743\u9650\uff01");
                return;
            }
        }
        NormalMember friend = bot.getGroup(group).get(user);
        if (!type && value.equals("all")) {
            Power finalPower = power;
            HibernateUtil.factory.fromTransaction(session -> {
                session.remove((Object)finalPower);
                PowerAction.init(false);
                return 0;
            });
            subject.sendMessage("\u6e05\u9664\u7528\u6237 " + friend.getRemark() + " \u6240\u6709\u6743\u9650\u6210\u529f\uff01");
            PowerAction.init(false);
            return;
        }
        Power updatePower = power;
        HibernateUtil.factory.fromTransaction(session -> {
            session.merge((Object)updatePower);
            return 0;
        });
        if (type) {
            subject.sendMessage("\u6dfb\u52a0\u7528\u6237 " + friend.getRemark() + " \u6743\u9650 " + (value.equals("all") ? "\u5168\u90e8" : value) + " \u6210\u529f!");
        } else {
            subject.sendMessage("\u5220\u9664\u7528\u6237 " + friend.getRemark() + " \u6743\u9650" + (value.equals("all") ? "\u5168\u90e8" : value) + " \u6210\u529f!");
        }
        PowerAction.init(false);
    }

    public void queryPower(MessageEvent event) {
        String split;
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        PowerAction.init(false);
        String[] splits = code.split(" +");
        if (splits.length == 2 && (split = splits[1]).equals("all")) {
            int pageNo = 1;
            Map<String, Power> powerMap = StaticData.getPowerMap(bot);
            if (powerMap.size() == 0) {
                subject.sendMessage("\u76ee\u524d\u6ca1\u6709\u6743\u9650\u4fe1\u606f");
                return;
            }
            this.paginationQueryAll(event, pageNo);
            return;
        }
    }

    private static Map<Long, Map<String, Power>> parseList(List<Power> powerList) {
        if (powerList == null || powerList.isEmpty()) {
            return null;
        }
        HashMap<Long, Map<String, Power>> listMap = new HashMap<Long, Map<String, Power>>();
        for (final Power power : powerList) {
            long bot = power.getBot();
            final String key = power.getGroupId() + "." + power.getQq();
            if (!listMap.containsKey(bot)) {
                listMap.put(bot, (Map<String, Power>)new HashMap<String, Power>(){
                    {
                        this.put(key, power);
                    }
                });
                continue;
            }
            if (((Map)listMap.get(bot)).containsKey(key)) continue;
            ((Map)listMap.get(bot)).put(key, power);
        }
        return listMap;
    }

    private void paginationQueryAll(MessageEvent event, int pageNo) {
        Contact subject = event.getSubject();
        User user = event.getSender();
        Bot bot = event.getBot();
        List<Power> powerList = new ArrayList<Power>(StaticData.getPowerMap(bot).values());
        powerList.sort((a, b) -> {
            if (a.getGroupId() >= b.getGroupId()) {
                return -1;
            }
            return 1;
        });
        int pageTotal = powerList.size() % 10 == 0 ? powerList.size() / 10 : powerList.size() / 10 + 1;
        int pageMax = pageNo * 10;
        powerList = powerList.subList(pageMax - 10, Math.min(powerList.size(), pageMax));
        ForwardMessageBuilder forwardMessageBuilder = new ForwardMessageBuilder(subject);
        forwardMessageBuilder.add((UserOrBot)bot, singleMessages -> {
            singleMessages.add("\u4ee5\u4e0b\u662f\u672cbot\u7684\u6240\u6709\u6743\u9650\u4fe1\u606f\u2193");
            return null;
        });
        long owner = ConfigData.INSTANCE.getOwner();
        Friend friend = bot.getFriend(owner);
        Object ownerString = "\u4e3b\u4eba:";
        if (friend != null) {
            ownerString = (String)ownerString + friend.getRemark();
        }
        Object finalOwnerString = ownerString = (String)ownerString + "(" + owner + ")";
        forwardMessageBuilder.add((UserOrBot)bot, arg_0 -> PowerAction.lambda$paginationQueryAll$5((String)finalOwnerString, arg_0));
        for (Power power : powerList) {
            forwardMessageBuilder.add((UserOrBot)bot, singleMessages -> {
                NormalMember member;
                Group group = bot.getGroup(power.getGroupId());
                MessageChainBuilder builder = new MessageChainBuilder();
                Object groupPowerString = "";
                Object userPowerString = "";
                if (group == null) {
                    groupPowerString = "\u672a\u77e5\u7fa4(" + power.getGroupId() + ")";
                    userPowerString = "\u672a\u77e5\u7528\u6237(" + power.getQq() + ")";
                    builder.append((CharSequence)userPowerString).append((CharSequence)"\n").append((CharSequence)"\u6240\u5c5e\u7fa4:").append((CharSequence)groupPowerString).append((CharSequence)"\n");
                }
                if ((member = group.get(power.getQq())) == null) {
                    userPowerString = "\u672a\u77e5\u7528\u6237(" + power.getQq() + ")";
                    builder.append((CharSequence)userPowerString).append((CharSequence)"\n");
                } else {
                    builder.append((CharSequence)NormalMemberKt.getNameCardOrNick((User)member)).append((CharSequence)"(").append((CharSequence)("" + power.getQq())).append((CharSequence)")\n");
                    builder.append((CharSequence)"\u6240\u5c5e\u7fa4:").append((CharSequence)group.getName()).append((CharSequence)"(").append((CharSequence)("" + power.getGroupId())).append((CharSequence)")\n");
                }
                singleMessages.add((Message)builder.build());
                return null;
            });
            forwardMessageBuilder.add((UserOrBot)bot, (Message)new ForwardMessageBuilder(subject).add((UserOrBot)bot, singleMessages -> {
                singleMessages.add(power.toString());
                return null;
            }).build());
        }
        forwardMessageBuilder.add((UserOrBot)bot, singleMessages -> {
            singleMessages.add("\u5f53\u524d\u9875\u6570:" + pageNo + "/\u603b\u9875\u6570:" + pageTotal);
            return null;
        });
        subject.sendMessage((Message)forwardMessageBuilder.build());
        EventChannel channel = GlobalEventChannel.INSTANCE.parentScope((CoroutineScope)HuYanSession.INSTANCE).filterIsInstance(MessageEvent.class).filter(nextEvent -> nextEvent.getSender().getId() == user.getId());
        channel.subscribeOnce(MessageEvent.class, (CoroutineContext)EmptyCoroutineContext.INSTANCE, ConcurrencyKind.LOCKED, EventPriority.HIGH, nextEvent -> {
            String string = nextEvent.getMessage().contentToString();
            if (string.equals("\u4e0b\u4e00\u9875")) {
                if (pageNo + 1 <= pageTotal) {
                    this.paginationQueryAll((MessageEvent)nextEvent, pageNo + 1);
                }
            } else if (string.equals("\u4e0a\u4e00\u9875") && pageNo - 1 > 0) {
                this.paginationQueryAll((MessageEvent)nextEvent, pageNo - 1);
            }
        });
    }

    private static /* synthetic */ Unit lambda$paginationQueryAll$5(String finalOwnerString, MessageChainBuilder singleMessages) {
        singleMessages.add(finalOwnerString);
        return null;
    }
}

