/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.config.ConfigData;
import cn.chahuyun.data.StaticData;
import cn.chahuyun.entity.GroupInfo;
import cn.chahuyun.entity.GroupList;
import cn.chahuyun.utils.HibernateUtil;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class ListAction {
    public static void init(boolean type) {
        Map parseList = (Map)HibernateUtil.factory.fromTransaction(session -> {
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            JpaCriteriaQuery query = builder.createQuery(GroupList.class);
            JpaRoot from = query.from(GroupList.class);
            query.select((Selection)from);
            List groupLists = session.createQuery((CriteriaQuery)query).list();
            return ListAction.parseList(groupLists);
        });
        StaticData.setGroupListMap(parseList);
        if (type) {
            HuYanSession.log.info("\u6570\u636e\u5e93\u7fa4\u7ec4\u4fe1\u606f\u521d\u59cb\u5316\u6210\u529f!");
            return;
        }
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            HuYanSession.log.info("\u7fa4\u7ec4\u4fe1\u606f\u66f4\u65b0\u6210\u529f!");
        }
    }

    public void addGroupListInfo(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        if (ConfigData.INSTANCE.getDebugSwitch()) {
            HuYanSession.log.info("code-" + code);
        }
        String[] split = code.split("\\s+");
        int key = Integer.parseInt(split[0].split("\\\\?[:\uff1a]")[1]);
        StringBuilder reply = new StringBuilder();
        Map<Integer, GroupList> groupListMap = StaticData.getGroupListMap(bot);
        if (groupListMap != null && groupListMap.containsKey(key)) {
            GroupList groupList = groupListMap.get(key);
            for (int i = 1; i < split.length; ++i) {
                long groupId = Long.parseLong(split[i]);
                if (!groupList.containsGroupId(groupId)) continue;
                reply.append("\u7fa4").append(groupId).append("\u5df2\u5b58\u5728\n");
            }
        }
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                GroupList groupList = groupListMap != null && groupListMap.containsKey(key) ? (GroupList)groupListMap.get(key) : new GroupList(bot.getId(), key);
                for (int i = 1; i < split.length; ++i) {
                    long groupId = Long.parseLong(split[i]);
                    if (groupList.containsGroupId(groupId)) continue;
                    GroupInfo groupInfo = new GroupInfo(bot.getId(), key, groupId);
                    groupList.getGroups().add(groupInfo);
                }
                session.merge((Object)groupList);
                return 0;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u6570\u636e\u5e93\u6dfb\u52a0\u7fa4\u7ec4\u5931\u8d25:", (Throwable)e);
            subject.sendMessage("\u7fa4\u7ec4" + key + "\u6dfb\u52a0\u5931\u8d25\uff01");
            return;
        }
        if (split.length == 2 && !reply.toString().equals("")) {
            subject.sendMessage("\u7fa4\u7ec4" + key + "\u4e2d" + reply);
            return;
        }
        String message = "\u7fa4\u7ec4" + key + "\u6dfb\u52a0\u7fa4\u6210\u529f\uff01";
        if (!reply.toString().equals("")) {
            message = message + "\u5176\u4e2d:\n" + reply;
        }
        subject.sendMessage(message);
        ListAction.init(false);
    }

    public void queryGroupListInfo(MessageEvent event) {
        Map<Integer, GroupList> groupListMap;
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        ListAction.init(false);
        String[] split = code.split("\\\\?[:\uff1a]");
        int key = 0;
        if (split.length == 2) {
            key = Integer.parseInt(split[1]);
        }
        if ((groupListMap = StaticData.getGroupListMap(bot)) == null || groupListMap.isEmpty()) {
            subject.sendMessage("\u6ca1\u6709\u7fa4\u7ec4\u4fe1\u606f!");
            return;
        }
        if (key != 0 && !groupListMap.containsKey(key)) {
            subject.sendMessage("\u6ca1\u6709\u8fd9\u4e2a\u7fa4\u7ec4\u4fe1\u606f!");
            return;
        }
        ForwardMessageBuilder forwardMessageBuilder = new ForwardMessageBuilder(subject);
        forwardMessageBuilder.add((UserOrBot)bot, singleMessages -> {
            singleMessages.add("\u4ee5\u4e0b\u4e3a\u6240\u6709\u67e5\u8be2\u5230\u7684\u7fa4\u7ec4\u2193");
            return null;
        });
        for (GroupList entity : groupListMap.values()) {
            if (key != 0 && key != entity.getListId()) continue;
            forwardMessageBuilder.add((UserOrBot)bot, chain -> {
                chain.add("\u7fa4\u7ec4\u7f16\u53f7\uff1a" + entity.getListId() + "\n");
                Iterator<GroupInfo> iterator = entity.getGroups().iterator();
                while (iterator.hasNext()) {
                    GroupInfo next = iterator.next();
                    chain.add(next.getGroupId() + "->");
                    String groupName = bot.getGroup(next.getGroupId()) == null ? "\u672a\u77e5\u7fa4" : Objects.requireNonNull(bot.getGroup(next.getGroupId())).getName();
                    chain.add(groupName);
                    if (!iterator.hasNext()) continue;
                    chain.add("\n");
                }
                return null;
            });
        }
        subject.sendMessage((Message)forwardMessageBuilder.build());
    }

    public void deleteGroupListInfo(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        String[] split = code.split("\\\\?[:\uff1a]");
        String[] strings = split[1].split("\\s+");
        int key = Integer.parseInt(strings[0]);
        int minSplit = 2;
        Long value = null;
        boolean type = true;
        if (strings.length == minSplit) {
            value = Long.parseLong(strings[1]);
            type = false;
        }
        if (type) {
            if (!StaticData.isGrouper(bot, key)) {
                subject.sendMessage("\u6ca1\u6709\u627e\u5230\u8981\u5fd8\u6389\u7684\u7fa4\u7ec4~");
                return;
            }
        } else if (!StaticData.isGrouper(bot, key, value)) {
            subject.sendMessage("\u6ca1\u6709\u627e\u5230\u8981\u5fd8\u6389\u7684\u7fa4~");
            return;
        }
        Boolean aBoolean = false;
        try {
            boolean finalType = type;
            Long finalValue = value;
            aBoolean = (Boolean)HibernateUtil.factory.fromTransaction(session -> {
                Map<Integer, GroupList> groupListMap = StaticData.getGroupListMap(bot);
                GroupList groupList = null;
                if (groupListMap != null && groupListMap.containsKey(key)) {
                    groupList = groupListMap.get(key);
                }
                if (finalType) {
                    session.remove(groupList);
                } else {
                    assert (groupList != null);
                    GroupInfo groupInfo = (GroupInfo)groupList.getGroups().stream().filter(item -> item.getGroupId() == finalValue.longValue()).collect(Collectors.toList()).get(0);
                    groupList.getGroups().remove(groupInfo);
                    session.merge((Object)groupList);
                }
                return true;
            });
        }
        catch (Exception e) {
            if (e instanceof PersistenceException) {
                HuYanSession.log.error("\u4e0d\u5141\u8bb8\u7fa4\u7ec4\u4e3a\u7a7a\u7fa4\u7ec4\uff01");
            }
            HuYanSession.log.error("\u6570\u636e\u5e93\u5220\u9664\u7fa4\u7ec4\u5931\u8d25:", (Throwable)e);
        }
        if (Boolean.FALSE.equals(aBoolean)) {
            subject.sendMessage("\u7fa4\u7ec4\u5220\u9664\u5931\u8d25!");
            return;
        }
        subject.sendMessage("\u7fa4\u7ec4" + key + "\u5220\u9664" + (String)(value == null ? "\u6210\u529f!" : value + "\u7fa4\u6210\u529f!"));
        ListAction.init(false);
    }

    private static Map<Long, Map<Integer, GroupList>> parseList(List<GroupList> groupLists) {
        if (groupLists == null || groupLists.isEmpty()) {
            return null;
        }
        HashMap<Long, Map<Integer, GroupList>> listMap = new HashMap<Long, Map<Integer, GroupList>>();
        for (final GroupList entity : groupLists) {
            long bot = entity.getBot();
            final int listId = entity.getListId();
            if (!listMap.containsKey(bot)) {
                listMap.put(bot, (Map<Integer, GroupList>)new HashMap<Integer, GroupList>(){
                    {
                        this.put(listId, entity);
                    }
                });
                continue;
            }
            if (((Map)listMap.get(bot)).containsKey(listId)) continue;
            ((Map)listMap.get(bot)).put(listId, entity);
        }
        return listMap;
    }
}

