/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.controller;

import cn.chahuyun.HuYanSession;
import cn.chahuyun.entity.Blacklist;
import cn.chahuyun.entity.Scope;
import cn.chahuyun.utils.HibernateUtil;
import cn.chahuyun.utils.ScopeUtil;
import cn.chahuyun.utils.ShareUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.regex.Pattern;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.contact.UserOrBot;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.ForwardMessageBuilder;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.SingleMessage;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaRoot;

public class BlackListAction {
    public void addBlackList(MessageEvent event) {
        Blacklist blacklist;
        MessageChain message = event.getMessage();
        Contact subject = event.getSubject();
        User user = event.getSender();
        String code = message.serializeToMiraiCode();
        Bot bot = event.getBot();
        Group group = null;
        if (subject instanceof Group) {
            group = (Group)subject;
        }
        long userId = 0L;
        for (SingleMessage sing : message) {
            if (!(sing instanceof At)) continue;
            userId = ((At)sing).getTarget();
        }
        String[] split = code.split(" +");
        String reason = "\u8fdd\u53cd\u89c4\u5219!";
        boolean kick = true;
        boolean prohibit = true;
        boolean withdraw = true;
        Scope scope = new Scope(bot.getId(), "\u5f53\u524d", false, false, subject.getId(), 0);
        if (split.length > 1) {
            block18: for (int i = 1; i < split.length; ++i) {
                String s;
                switch (s = split[i]) {
                    case "t": {
                        kick = false;
                        continue block18;
                    }
                    case "jy": {
                        prohibit = false;
                        continue block18;
                    }
                    case "ch": {
                        withdraw = false;
                        continue block18;
                    }
                    case "0": 
                    case "\u5168\u5c40": {
                        scope.setScopeName("\u5168\u5c40");
                        scope.setGlobal(true);
                        continue block18;
                    }
                    case "%": {
                        subject.sendMessage("\u8bf7\u8f93\u5165\u5c01\u7981\u7406\u7531:");
                        reason = ShareUtils.getNextMessageEventFromUser(user).getMessage().serializeToMiraiCode();
                        continue block18;
                    }
                    default: {
                        if (!Pattern.matches("gr\\d+", s)) continue block18;
                        scope.setScopeName("\u7fa4\u7ec4" + s.substring(1));
                        scope.setGroupInfo(true);
                        scope.setListId(Integer.parseInt(s.substring(1)));
                    }
                }
            }
        }
        if (!BlackListAction.saveBlackList(blacklist = new Blacklist(bot.getId(), userId, reason, kick, prohibit, withdraw, scope), scope)) {
            subject.sendMessage("\u9ed1\u540d\u5355\u6dfb\u52a0\u5931\u8d25!");
        }
        subject.sendMessage("\u9ed1\u540d\u5355\u6dfb\u52a0\u6210\u529f!");
        if (group == null || group.getBotPermission() == MemberPermission.MEMBER) {
            return;
        }
        if (blacklist.isKick()) {
            try {
                group.get(userId).kick(reason);
                subject.sendMessage("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237->" + userId + " \u5df2\u8e22\u51fa,\u7406\u7531:" + reason);
            }
            catch (Exception e) {
                HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
                subject.sendMessage("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237->" + userId + " \u8e22\u51fa\u5931\u8d25!");
            }
        } else if (blacklist.isProhibit()) {
            group.get(userId).mute(999999999);
            subject.sendMessage("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237->" + userId + " \u5df2\u7981\u8a00,\u7406\u7531:" + reason);
        }
    }

    public void queryBlackList(MessageEvent event) {
        List blacklists;
        Contact subject = event.getSubject();
        Bot bot = event.getBot();
        try {
            blacklists = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(Blacklist.class);
                JpaRoot from = query.from(Blacklist.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                List list = session.createQuery((CriteriaQuery)query).list();
                for (Blacklist blacklist : list) {
                    if (blacklist.getScope() != null) continue;
                    blacklist.setScope(ScopeUtil.getScope(blacklist.getScopeMark()));
                }
                return list;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return;
        }
        if (blacklists == null || blacklists.isEmpty()) {
            subject.sendMessage("\u6ca1\u6709\u9ed1\u540d\u5355\u4fe1\u606f!");
            return;
        }
        ForwardMessageBuilder messageBuilder = new ForwardMessageBuilder(subject);
        messageBuilder.add((UserOrBot)bot, (Message)new PlainText("\u4ee5\u4e0b\u662f\u6240\u6709\u9ed1\u540d\u5355\u7528\u6237\u2193"));
        for (Blacklist blacklist : blacklists) {
            MessageChainBuilder chainBuilder = new MessageChainBuilder();
            chainBuilder.add(String.format("\u9ed1\u540d\u5355\u7f16\u53f7:%d%nqq:%d%n\u5c01\u7981\u7406\u7531:%s%n", blacklist.getId(), blacklist.getBlackQQ(), blacklist.getReason()));
            Scope scope = blacklist.getScope();
            if (ShareUtils.mateScope(event, scope)) {
                chainBuilder.add("\u5f53\u524d\u7fa4\u662f\u5426\u89e6\u53d1:\u662f\n");
            } else {
                chainBuilder.add("\u5f53\u524d\u7fa4\u662f\u5426\u89e6\u53d1:\u5426\n");
            }
            chainBuilder.add(String.format("\u4f5c\u7528\u57df:%s", scope.getScopeName()));
            messageBuilder.add((UserOrBot)bot, (Message)chainBuilder.build());
        }
        subject.sendMessage((Message)messageBuilder.build());
    }

    public void deleteBlackList(MessageEvent event) {
        String code = event.getMessage().serializeToMiraiCode();
        Contact subject = event.getSubject();
        String key = code.split("[:\uff1a]")[1];
        Boolean aBoolean = (Boolean)HibernateUtil.factory.fromTransaction(session -> {
            HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
            JpaCriteriaQuery query = builder.createQuery(Blacklist.class);
            JpaRoot from = query.from(Blacklist.class);
            query.select((Selection)from);
            query.where((Expression)builder.equal((Expression)from.get("id"), (Object)key));
            List list = session.createQuery((CriteriaQuery)query).list();
            if (list == null || list.isEmpty()) {
                return false;
            }
            Blacklist blacklist = (Blacklist)list.get(0);
            session.remove((Object)blacklist);
            return true;
        });
        if (aBoolean.booleanValue()) {
            subject.sendMessage("\u9ed1\u540d\u5355\u5220\u9664\u6210\u529f!");
        } else {
            subject.sendMessage("\u9ed1\u660e\u5355\u5220\u9664\u5931\u8d25!");
        }
    }

    public static boolean saveBlackList(Blacklist blacklist, Scope scope) {
        try {
            HibernateUtil.factory.fromTransaction(session -> {
                if (ScopeUtil.isScopeEmpty(scope)) {
                    session.persist((Object)scope);
                }
                session.merge((Object)blacklist);
                return null;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return false;
        }
        return true;
    }

    public void isBlackUser(MessageEvent event) {
        List blacklists;
        Contact subject = event.getSubject();
        if (!(subject instanceof Group)) {
            return;
        }
        Group group = (Group)subject;
        User user = event.getSender();
        Bot bot = event.getBot();
        NormalMember member = group.get(user.getId());
        try {
            blacklists = (List)HibernateUtil.factory.fromTransaction(session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                JpaCriteriaQuery query = builder.createQuery(Blacklist.class);
                JpaRoot from = query.from(Blacklist.class);
                query.select((Selection)from);
                query.where((Expression)builder.equal((Expression)from.get("bot"), (Object)bot.getId()));
                query.where((Expression)builder.equal((Expression)from.get("blackQQ"), (Object)user.getId()));
                List list = session.createQuery((CriteriaQuery)query).list();
                for (Blacklist blacklist : list) {
                    if (blacklist.getScope() != null) continue;
                    blacklist.setScope(ScopeUtil.getScope(blacklist.getScopeMark()));
                }
                return list;
            });
        }
        catch (Exception e) {
            HuYanSession.log.error("\u51fa\u9519\u5566~", (Throwable)e);
            return;
        }
        if (blacklists == null || blacklists.isEmpty()) {
            return;
        }
        for (Blacklist blacklist : blacklists) {
            if (!ShareUtils.mateScope(bot, group, blacklist.getScope())) continue;
            if (blacklist.isKick()) {
                try {
                    member.kick("\u4f60\u5df2\u88ab\u5c01\u7981");
                    subject.sendMessage(String.format("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237 %d ,\u5df2\u8e22\u51fa,\u5c01\u7981\u7406\u7531: %s", user.getId(), blacklist.getReason()));
                }
                catch (Exception e) {
                    HuYanSession.log.warning("\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
                }
                continue;
            }
            if (blacklist.isProhibit()) {
                member.mute(999999999);
                subject.sendMessage(String.format("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237 %d ,\u5df2\u7981\u8a00,\u5c01\u7981\u7406\u7531: %s", user.getId(), blacklist.getReason()));
                continue;
            }
            if (!blacklist.isWithdraw()) continue;
            MessageSource.recall((MessageChain)event.getMessage());
            subject.sendMessage(String.format("\u68c0\u6d4b\u5230\u9ed1\u540d\u5355\u7528\u6237 %d ,\u5df2\u64a4\u56de\u6d88\u606f,\u5c01\u7981\u7406\u7531: %s", user.getId(), blacklist.getReason()));
        }
    }
}

