/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.authorize.listening.impl;

import cn.chahuyun.authorize.HuYanAuthorize;
import cn.chahuyun.authorize.Interface.CustomPattern;
import cn.chahuyun.authorize.annotation.MessageAuthorize;
import cn.chahuyun.authorize.aop.JavaBeanProxy;
import cn.chahuyun.authorize.config.AuthorizeConfig;
import cn.chahuyun.authorize.enums.MessageMatchingEnum;
import cn.chahuyun.authorize.enums.PermissionMatchingEnum;
import cn.chahuyun.authorize.listening.Filter;
import cn.chahuyun.authorize.manager.PermissionManager;
import cn.chahuyun.authorize.utils.Log;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.Event;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.ListeningStatus;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;
import org.jetbrains.annotations.NotNull;

public class MessageFilter
implements Filter {
    private EventChannel<MessageEvent> channel;

    private MessageFilter() {
    }

    public static void register(Set<Class<?>> classes, EventChannel<MessageEvent> channel) {
        MessageFilter register = new MessageFilter();
        register.setChannel(channel);
        for (Class<?> aClass : classes) {
            Object newInstance;
            HuYanAuthorize.LOGGER.debug("\u5df2\u626b\u63cf\u5230\u6d88\u606f\u6ce8\u518c\u7c7b->" + aClass.getName());
            try {
                newInstance = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                HuYanAuthorize.LOGGER.error("\u6ce8\u518c\u7c7b:" + aClass.getName() + "\u5b9e\u4f8b\u5316\u5931\u8d25!");
                return;
            }
            Method[] methods = aClass.getDeclaredMethods();
            Stream<Method> stream = Arrays.stream(methods);
            register.filter(stream, newInstance);
        }
    }

    @Override
    public void filter(Stream<Method> stream, Object instance) {
        stream.filter(it -> it.isAnnotationPresent(MessageAuthorize.class) && it.getParameterCount() == 1).forEach(it -> {
            Class<MessageEvent> parameterType = it.getParameterTypes()[0];
            if (parameterType.isAssignableFrom(MessageEvent.class)) {
                Class<MessageEvent> methodType = parameterType.asSubclass(MessageEvent.class);
                this.execute(instance, (Method)it, (EventChannel<? extends MessageEvent>)this.channel.filterIsInstance(methodType), (Class<? extends MessageEvent>)methodType);
            } else {
                Log.warning("\u7c7b[%s]\u4e2d\u65b9\u6cd5[%s]\u7684\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!", instance.getClass().getName(), it.getName());
            }
        });
    }

    public void execute(@NotNull Object bean, @NotNull Method method, @NotNull EventChannel<? extends MessageEvent> channel, Class<? extends MessageEvent> methodType) {
        HuYanAuthorize.LOGGER.debug("\u6dfb\u52a0\u6d88\u606f\u6ce8\u518c\u65b9\u6cd5->" + method.getName() + " : \u6d88\u606f\u83b7\u53d6\u7c7b\u578b->" + method.getParameterTypes()[0].getSimpleName());
        MessageAuthorize annotation = method.getAnnotation(MessageAuthorize.class);
        channel.filter(event -> this.eventCheckPermission((MessageEvent)event, annotation)).filter(event -> this.messageMate((MessageEvent)event, annotation)).subscribe(methodType, (CoroutineContext)EmptyCoroutineContext.INSTANCE, annotation.concurrency(), annotation.priority(), event -> JavaBeanProxy.getInstance().register(bean, method, (Event)event) ? ListeningStatus.LISTENING : ListeningStatus.STOPPED);
    }

    private boolean eventCheckPermission(MessageEvent event, MessageAuthorize authorize) {
        String[] groupPermissions;
        Bot bot = event.getBot();
        User sender = event.getSender();
        Contact subject = event.getSubject();
        if (subject instanceof Group && !(groupPermissions = authorize.groupPermissions())[0].equals("null")) {
            PermissionMatchingEnum groupPermissionsMatching = authorize.groupPermissionsMatching();
            if (MessageFilter.isPermission(bot.getId(), subject.getId(), subject.getId(), groupPermissionsMatching, groupPermissions)) {
                return false;
            }
        }
        String[] permissions = authorize.userPermissions();
        PermissionMatchingEnum userPermissionsMatching = authorize.userPermissionsMatching();
        switch (permissions[0]) {
            case "null": {
                return true;
            }
            case "admin": 
            case "owner": {
                if (AuthorizeConfig.INSTANCE.getOwner() == sender.getId()) {
                    return true;
                }
                if (!PermissionManager.checkPermission(bot.getId(), subject.getId(), sender.getId(), "admin")) break;
                return true;
            }
        }
        return !MessageFilter.isPermission(bot.getId(), subject.getId(), sender.getId(), userPermissionsMatching, permissions);
    }

    private boolean messageMate(MessageEvent event, MessageAuthorize annotation) {
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        MessageMatchingEnum matching = annotation.messageMatching();
        String[] text = annotation.text();
        boolean messageMatching = false;
        block1 : switch (matching) {
            case TEXT: {
                for (String messageString : text) {
                    if (!code.equals(messageString = messageString.replaceFirst("#", ""))) continue;
                    messageMatching = true;
                    break block1;
                }
                break;
            }
            case REGULAR: {
                messageMatching = Pattern.matches(text[0], code);
                break;
            }
            case CUSTOM: {
                Class<? extends CustomPattern> custom = annotation.custom();
                try {
                    messageMatching = (Boolean)ReflectUtil.invoke((Object)ReflectUtil.newInstance(custom, (Object[])new Object[0]), (String)"custom", (Object[])new Object[]{event});
                    break;
                }
                catch (UtilException e) {
                    HuYanAuthorize.LOGGER.error("\u4f7f\u7528\u81ea\u5b9a\u4e49\u5339\u914d\u5f02\u5e38!", (Throwable)e);
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        if (text.length == 1) {
            messageMatching = "null".equals(text[0]) || messageMatching;
        }
        return messageMatching;
    }

    private static boolean isPermission(long bot, long group, long id, PermissionMatchingEnum matching, String[] permissions) {
        if (AuthorizeConfig.INSTANCE.getOwner() == id || PermissionManager.checkPermission(bot, group, id, "admin") || PermissionManager.checkPermission(bot, group, id, "all")) {
            return false;
        }
        if (matching == PermissionMatchingEnum.AND) {
            boolean success = true;
            for (String permission : permissions) {
                success = success && PermissionManager.checkPermission(bot, group, id, permission);
            }
            return !success;
        }
        for (String permission : permissions) {
            if (!PermissionManager.checkPermission(bot, group, id, permission)) continue;
            return false;
        }
        return true;
    }

    public EventChannel<MessageEvent> getChannel() {
        return this.channel;
    }

    public void setChannel(EventChannel<MessageEvent> channel) {
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageFilter)) {
            return false;
        }
        MessageFilter other = (MessageFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventChannel<MessageEvent> this$channel = this.getChannel();
        EventChannel<MessageEvent> other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventChannel<MessageEvent> $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    public String toString() {
        return "MessageFilter(channel=" + this.getChannel() + ")";
    }
}

