/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.authorize;

import cn.chahuyun.authorize.HuYanAuthorize;
import cn.chahuyun.authorize.annotation.EventComponent;
import cn.chahuyun.authorize.entity.PermissionInfo;
import cn.chahuyun.authorize.listening.impl.MessageFilter;
import cn.chahuyun.authorize.utils.HibernateUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.lang.ClassScanner;
import cn.hutool.core.util.URLUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.console.plugin.jvm.JavaPlugin;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.GlobalEventChannel;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.utils.MiraiLogger;

public class PermissionServer {
    private static final PermissionServer INSTANCE = new PermissionServer();

    private PermissionServer() {
    }

    public static PermissionServer getInstance() {
        return INSTANCE;
    }

    public void init(JavaPlugin instance, String packagePath) {
        MiraiLogger log = HuYanAuthorize.LOGGER;
        EventChannel eventEventChannel = GlobalEventChannel.INSTANCE.parentScope((CoroutineScope)instance);
        packagePath = packagePath.replace(".", "/");
        ClassScanner classScanner = null;
        ClassLoader classLoader = null;
        Set<Class<Object>> scan = new HashSet();
        try {
            classLoader = instance.getClass().getClassLoader();
            classScanner = new ClassScanner(packagePath, aClass -> aClass.isAnnotationPresent(EventComponent.class));
            classScanner.setClassLoader(classLoader);
            scan = classScanner.scan();
        }
        catch (Exception e) {
            log.warning("\u7c7b\u626b\u63cf\u9519\u8bef!");
            e.printStackTrace();
        }
        if (classLoader != null && scan.isEmpty()) {
            log.debug("\u4f7f\u7528\u65e7\u7684\u7c7b\u626b\u63cf\u65b9\u5f0f");
            scan = this.reflectiveScan(classLoader, classScanner, packagePath);
        }
        if (scan == null || scan.isEmpty()) {
            log.error("\u5305\u626b\u63cf\u4e25\u91cd\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5305\u8def\u5f84\u6216\u6ce8\u89e3!");
            return;
        }
        MessageFilter.register(scan, (EventChannel<MessageEvent>)eventEventChannel.filterIsInstance(MessageEvent.class));
        log.info("HuYanAuthorize message event registration succeeded !");
    }

    public boolean addPermission(String code, String description) {
        ArrayList<String> defaultPermissions = new ArrayList<String>(){
            {
                this.add("owner");
                this.add("null");
                this.add("admin");
                this.add("all");
            }
        };
        if (defaultPermissions.contains(code)) {
            return false;
        }
        try {
            HibernateUtil.factory.fromSession(session -> (PermissionInfo)session.get(PermissionInfo.class, (Object)code));
            return false;
        }
        catch (Exception e) {
            PermissionInfo permissionInfo = new PermissionInfo(code, description);
            try {
                HibernateUtil.factory.fromTransaction(session -> (PermissionInfo)session.merge((Object)permissionInfo));
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    @Deprecated
    private Set<Class<?>> reflectiveScan(ClassLoader classLoader, ClassScanner classScanner, String packagePath) {
        Class<ClassScanner> classScannerClass = ClassScanner.class;
        Enumeration<URL> resources = classLoader.getResources(packagePath);
        EnumerationIter enumerationIter = new EnumerationIter(resources);
        for (URL url : enumerationIter) {
            try {
                Method scanJar = classScannerClass.getDeclaredMethod("scanJar", JarFile.class);
                scanJar.setAccessible(true);
                scanJar.invoke((Object)classScanner, URLUtil.getJarFile((URL)url));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Field classes = classScannerClass.getDeclaredField("classes");
        classes.setAccessible(true);
        return (Set)classes.get(classScanner);
    }
}

