/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.authorize.manager;

import cn.chahuyun.authorize.HuYanAuthorize;
import cn.chahuyun.authorize.annotation.MessageAuthorize;
import cn.chahuyun.authorize.annotation.MessageComponent;
import cn.chahuyun.authorize.entity.PermissionInfo;
import cn.chahuyun.authorize.entity.UserPermissionInfo;
import cn.chahuyun.authorize.enums.MessageMatchingEnum;
import cn.chahuyun.authorize.utils.HibernateUtil;
import cn.chahuyun.authorize.utils.QueryUtil;
import java.util.List;
import java.util.Objects;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.SingleMessage;

@MessageComponent
public class PermissionManager {
    @MessageAuthorize(text={"^[+|-]\\[mirai:at:\\d+]( +\\S+){1,5}"}, messageMatching=MessageMatchingEnum.REGULAR, userPermissions={"admin"}, messageEventType=GroupMessageEvent.class)
    public void controlMemberPermission(GroupMessageEvent event) {
        Group subject = event.getSubject();
        Group group = event.getGroup();
        Bot bot = event.getBot();
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        MessageChainBuilder builder = QueryUtil.quoteReply(message);
        long atId = 0L;
        for (SingleMessage singleMessage : message) {
            if (!(singleMessage instanceof At)) continue;
            atId = ((At)singleMessage).getTarget();
        }
        if (atId == 0L) {
            subject.sendMessage("\u6743\u9650\u64cd\u4f5c\u8bc6\u522b\u5931\u8d25!");
            return;
        }
        boolean b = code.charAt(0) == '+';
        String[] split = code.split(" +");
        if (b) {
            builder.append((SingleMessage)QueryUtil.formatMessage("\u4e3a\u7fa4\u6210\u5458%s(%s)\u6dfb\u52a0\u4ee5\u4e0b\u6743\u9650:", Objects.requireNonNull(group.get(atId)).getNick(), atId));
        } else {
            builder.append((SingleMessage)QueryUtil.formatMessage("\u4e3a\u7fa4\u6210\u5458%s(%s)\u5220\u9664\u4ee5\u4e0b\u6743\u9650:", Objects.requireNonNull(group.get(atId)).getNick(), atId));
        }
        MessageChain singleMessages = this.operationPermissions(b, bot.getId(), subject.getId(), atId, false, builder, split);
        subject.sendMessage((Message)singleMessages);
    }

    @MessageAuthorize(text={"^[+|-]\\d+( +\\S+){1,5}"}, messageMatching=MessageMatchingEnum.REGULAR, userPermissions={"admin"})
    public void controlFriendPermission(MessageEvent event) {
        long botId = event.getBot().getId();
        Contact subject = event.getSubject();
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        String[] split = code.split(" +");
        boolean b = code.charAt(0) == '+';
        long userId = Long.parseLong(split[0].substring(1));
        MessageChainBuilder builder = QueryUtil.quoteReply(message);
        if (b) {
            builder.append((SingleMessage)QueryUtil.formatMessage("\u4e3a\u7528\u6237 %s \u6dfb\u52a0\u4ee5\u4e0b\u6743\u9650:", userId));
        } else {
            builder.append((SingleMessage)QueryUtil.formatMessage("\u4e3a\u7528\u6237 %s \u5220\u9664\u4ee5\u4e0b\u6743\u9650:", userId));
        }
        MessageChain singleMessages = this.operationPermissions(b, botId, userId, userId, true, builder, split);
        subject.sendMessage((Message)singleMessages);
    }

    @MessageAuthorize(text={"^[+|-]group( +\\S+){1,5}"}, messageMatching=MessageMatchingEnum.REGULAR, userPermissions={"admin"}, messageEventType=GroupMessageEvent.class)
    public void controlGroupPermission(GroupMessageEvent event) {
        long botId = event.getBot().getId();
        Group subject = event.getSubject();
        Group group = event.getGroup();
        long groupId = group.getId();
        MessageChain message = event.getMessage();
        String code = message.serializeToMiraiCode();
        String[] split = code.split(" +");
        boolean b = code.charAt(0) == '+';
        MessageChainBuilder builder = QueryUtil.quoteReply(message);
        if (b) {
            builder.append((SingleMessage)QueryUtil.formatMessage("\u4e3a\u7fa4%s(%s)\u6dfb\u52a0\u4ee5\u4e0b\u6743\u9650:", group.getName(), groupId));
        } else {
            builder.append((SingleMessage)QueryUtil.formatMessage("\u4e3a\u7fa4%s(%s)\u5220\u9664\u4ee5\u4e0b\u6743\u9650:", group.getName(), groupId));
        }
        MessageChain singleMessages = this.operationPermissions(b, botId, groupId, groupId, true, builder, split);
        subject.sendMessage((Message)singleMessages);
    }

    @MessageAuthorize(text={"[!\uff01]prem ?\\[mirai:at:\\d+]"}, messageMatching=MessageMatchingEnum.REGULAR, userPermissions={"admin"}, messageEventType=GroupMessageEvent.class)
    public void viewMemberPermission(GroupMessageEvent event) {
        long botId = event.getBot().getId();
        MessageChain message = event.getMessage();
        Group subject = event.getSubject();
        Group group = event.getGroup();
        long groupId = group.getId();
        MessageChainBuilder builder = QueryUtil.quoteReply(message);
        long atId = 0L;
        for (SingleMessage singleMessage : message) {
            if (!(singleMessage instanceof At)) continue;
            atId = ((At)singleMessage).getTarget();
        }
        if (atId == 0L) {
            subject.sendMessage("\u6743\u9650\u67e5\u770b\u8bc6\u522b\u5931\u8d25!");
            return;
        }
        long finalAtId = atId;
        List userPermissionInfos = null;
        try {
            userPermissionInfos = (List)HibernateUtil.factory.fromSession(session -> session.createQuery("from UserPermissionInfo as u where u.bot ='" + botId + "' and u.qq = '" + finalAtId + "' and u.groupId = '" + groupId + "' and u.global = false ", UserPermissionInfo.class).list());
        }
        catch (Exception e) {
            HuYanAuthorize.LOGGER.error((Throwable)e);
            return;
        }
        builder.append((CharSequence)String.format("\u7fa4\u6210\u5458%s(%s)\u62e5\u6709\u4e0b\u5217\u6743\u9650:", Objects.requireNonNull(group.get(atId)).getNick(), atId));
        subject.sendMessage((Message)this.viewPermissions(userPermissionInfos, builder));
    }

    @MessageAuthorize(text={"\u6d4b\u8bd5"}, userPermissions={"admin"}, messageEventType=GroupMessageEvent.class)
    public void test(GroupMessageEvent event) {
        event.getSubject().sendMessage("\u6210\u529f");
    }

    public static boolean checkPermission(long bot, long group, long id, String code) {
        return PermissionManager.checkPermission(bot, group, id, code, true);
    }

    public static boolean isPermission(String code) {
        try {
            return (Boolean)HibernateUtil.factory.fromSession(session -> session.createQuery("from PermissionInfo as perm where perm.code = '" + code + "'", PermissionInfo.class).getSingleResult() != null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkPermission(long bot, long group, long id, String code, boolean number) {
        if (number) {
            try {
                boolean result;
                boolean bl = result = HibernateUtil.factory.fromSession(session -> (UserPermissionInfo)session.createQuery("from UserPermissionInfo as u left join PermissionInfo as perm on u.code = perm.code where u.bot ='" + bot + "' and u.qq = '" + id + "' and u.global =  true and perm.code = '" + code + "'", UserPermissionInfo.class).getSingleResult()) != null;
                if (result) {
                    return true;
                }
                if (group == id) {
                    return false;
                }
                return PermissionManager.checkPermission(bot, group, id, code, false);
            }
            catch (Exception e) {
                if (group == id) {
                    return false;
                }
                return PermissionManager.checkPermission(bot, group, id, code, false);
            }
        }
        try {
            return HibernateUtil.factory.fromSession(session -> (UserPermissionInfo)session.createQuery("from UserPermissionInfo u left join PermissionInfo perm on u.code = perm.code where u.bot ='" + bot + "' and u.qq = '" + id + "' and u.groupId = '" + group + "' and perm.code = '" + code + "'", UserPermissionInfo.class).getSingleResult()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private MessageChain operationPermissions(boolean b, long botId, long groupId, long userId, boolean isGlobal, MessageChainBuilder builder, String[] split) {
        if (b) {
            for (int i = 1; i < split.length; ++i) {
                String perm = split[i];
                if (!PermissionManager.isPermission(perm)) {
                    builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u6743\u9650\u4e0d\u5b58\u5728!");
                    continue;
                }
                if (PermissionManager.checkPermission(botId, groupId, userId, perm)) {
                    builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u5df2\u5b58\u5728!");
                    continue;
                }
                UserPermissionInfo userPermissionInfo = new UserPermissionInfo(userId, groupId, botId, isGlobal, perm);
                if (userPermissionInfo.save()) {
                    builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u6dfb\u52a0\u6210\u529f!");
                    continue;
                }
                builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u6dfb\u52a0\u5931\u8d25!");
            }
        } else {
            for (int i = 1; i < split.length; ++i) {
                String perm = split[i];
                if (!PermissionManager.isPermission(perm)) {
                    builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u6743\u9650\u4e0d\u5b58\u5728!");
                    continue;
                }
                if (PermissionManager.checkPermission(botId, groupId, userId, perm)) {
                    Boolean aBoolean = (Boolean)HibernateUtil.factory.fromSession(session -> {
                        try {
                            UserPermissionInfo singleResult = (UserPermissionInfo)session.createQuery("from UserPermissionInfo as u left join PermissionInfo as perm on u.code = perm.code where u.bot ='" + botId + "' and u.qq = '" + userId + "' and u.groupId = '" + groupId + "' and perm.code = '" + perm + "'", UserPermissionInfo.class).getSingleResult();
                            session.remove((Object)singleResult);
                            return true;
                        }
                        catch (Exception e) {
                            HuYanAuthorize.LOGGER.error("\u7fa4\u6210\u5458\u57fa\u672c\u6743\u9650\u5220\u9664\u5931\u8d25:", (Throwable)e);
                            return false;
                        }
                    });
                    if (aBoolean.booleanValue()) {
                        builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u5220\u9664\u6210\u529f!");
                        continue;
                    }
                    builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u5220\u9664\u5931\u8d25!");
                    continue;
                }
                builder.append((CharSequence)"\n\u6743\u9650:").append((CharSequence)perm).append((CharSequence)"-\u4e0d\u5b58\u5728!");
            }
        }
        return builder.build();
    }

    private MessageChain viewPermissions(List<UserPermissionInfo> userPermissionInfos, MessageChainBuilder builder) {
        for (UserPermissionInfo userPermissionInfo : userPermissionInfos) {
            PermissionInfo permissionInfo = userPermissionInfo.getPermissionInfo();
            builder.append((SingleMessage)QueryUtil.formatMessage("\n\u6743\u9650:%s\n%s", permissionInfo.getCode(), permissionInfo.getDescription()));
        }
        return builder.build();
    }
}

