/*
 * Decompiled with CFR 0.152.
 */
package cn.chahuyun.authorize;

import cn.chahuyun.authorize.HuYanAuthorize;
import cn.chahuyun.authorize.annotation.MessageAuthorize;
import cn.chahuyun.authorize.annotation.MessageComponent;
import cn.chahuyun.authorize.config.AuthorizeConfig;
import cn.chahuyun.authorize.entity.PermissionInfo;
import cn.chahuyun.authorize.enums.MessageMatchingEnum;
import cn.chahuyun.authorize.enums.PermissionMatchingEnum;
import cn.chahuyun.authorize.manager.PermissionManager;
import cn.chahuyun.authorize.utils.HibernateUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.lang.ClassScanner;
import cn.hutool.core.util.URLUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.console.plugin.jvm.JavaPlugin;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.User;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.GlobalEventChannel;
import net.mamoe.mirai.event.ListeningStatus;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

public class PermissionServer {
    private static final PermissionServer instance = new PermissionServer();

    private PermissionServer() {
    }

    public static PermissionServer getInstance() {
        return instance;
    }

    public void init(JavaPlugin instance, String packagePath) {
        MiraiLogger log = HuYanAuthorize.LOGGER;
        EventChannel eventEventChannel = GlobalEventChannel.INSTANCE.parentScope((CoroutineScope)instance);
        packagePath = packagePath.replace(".", "/");
        ClassScanner classScanner = new ClassScanner(packagePath, aClass -> aClass.isAnnotationPresent(MessageComponent.class));
        ClassLoader classLoader = instance.getClass().getClassLoader();
        classScanner.setClassLoader(classLoader);
        Set<Class<?>> scan = classScanner.scan();
        if (scan.isEmpty()) {
            log.debug("\u4f7f\u7528\u65e7\u7684\u7c7b\u626b\u63cf\u65b9\u5f0f");
            scan = this.reflectiveScan(classLoader, classScanner, packagePath);
        }
        scan.forEach(aClass -> {
            Object newInstance;
            log.debug("\u5df2\u626b\u63cf\u5230\u6d88\u606f\u6ce8\u518c\u7c7b->" + aClass.getName());
            try {
                newInstance = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u6ce8\u518c\u7c7b:" + aClass.getName() + "\u5b9e\u4f8b\u5316\u5931\u8d25!");
                return;
            }
            Arrays.stream(aClass.getMethods()).filter(method -> method.isAnnotationPresent(MessageAuthorize.class)).filter(method -> {
                if (method.getParameterCount() != 1) {
                    return false;
                }
                return method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(MessageAuthorize.class).messageEventType());
            }).forEach(it -> PermissionServer.execute(newInstance, it, (EventChannel<MessageEvent>)eventEventChannel.filterIsInstance(MessageEvent.class)));
        });
        log.info("HuYanAuthorize message event registration succeeded !");
    }

    public boolean addPermission(String code, String description) {
        ArrayList<String> defaultPermissions = new ArrayList<String>(){
            {
                this.add("owner");
                this.add("null");
                this.add("admin");
                this.add("all");
            }
        };
        if (defaultPermissions.contains(code)) {
            return false;
        }
        try {
            HibernateUtil.factory.fromSession(session -> (PermissionInfo)session.get(PermissionInfo.class, (Object)code));
            return false;
        }
        catch (Exception e) {
            PermissionInfo permissionInfo = new PermissionInfo(code, description);
            try {
                HibernateUtil.factory.fromTransaction(session -> (PermissionInfo)session.merge((Object)permissionInfo));
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    private static void execute(Object bean, @NotNull Method method, @NotNull EventChannel<MessageEvent> channel) {
        HuYanAuthorize.LOGGER.debug("\u6dfb\u52a0\u6d88\u606f\u6ce8\u518c\u65b9\u6cd5->" + method.getName() + " : \u6d88\u606f\u83b7\u53d6\u7c7b\u578b->" + method.getParameterTypes()[0].getSimpleName());
        MessageAuthorize annotation = method.getAnnotation(MessageAuthorize.class);
        channel.filter(event -> {
            boolean quit = false;
            Bot bot = event.getBot();
            User sender = event.getSender();
            Contact subject = event.getSubject();
            if (subject instanceof Group) {
                String[] groupPermissions = annotation.groupPermissions();
                if (groupPermissions[0].equals("null")) {
                    quit = true;
                } else {
                    Object groupPermissionsMatching = annotation.groupPermissionsMatching();
                    if (PermissionServer.isPermission(bot.getId(), subject.getId(), subject.getId(), (PermissionMatchingEnum)((Object)((Object)groupPermissionsMatching)), groupPermissions)) {
                        return false;
                    }
                }
            }
            String[] permissions = annotation.userPermissions();
            switch (permissions[0]) {
                case "null": {
                    break;
                }
                case "owner": {
                    quit = quit && AuthorizeConfig.INSTANCE.getOwner() == sender.getId();
                    break;
                }
                case "admin": {
                    quit = quit && (AuthorizeConfig.INSTANCE.getOwner() == sender.getId() || PermissionManager.checkPermission(bot.getId(), subject.getId(), sender.getId(), "admin"));
                    break;
                }
                default: {
                    PermissionMatchingEnum permissionsMatching = annotation.userPermissionsMatching();
                    if (!PermissionServer.isPermission(bot.getId(), subject.getId(), sender.getId(), permissionsMatching, permissions)) break;
                    return false;
                }
            }
            if (!quit) {
                return false;
            }
            MessageChain message = event.getMessage();
            String code = message.serializeToMiraiCode();
            MessageMatchingEnum matching = annotation.messageMatching();
            String[] text = annotation.text();
            boolean messageMatching = false;
            if (matching == MessageMatchingEnum.TEXT) {
                for (String messageString : text) {
                    if (!code.equals(messageString = messageString.replaceFirst("#", ""))) continue;
                    messageMatching = true;
                    break;
                }
            } else {
                messageMatching = Pattern.matches(text[0], code);
            }
            if (text.length == 1) {
                messageMatching = text[0].equals("null") || messageMatching;
            }
            return messageMatching;
        }).subscribe(annotation.messageEventType(), (CoroutineContext)EmptyCoroutineContext.INSTANCE, annotation.concurrency(), annotation.priority(), event -> {
            try {
                method.invoke(bean, event);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                HuYanAuthorize.LOGGER.error("\u6d88\u606f\u4e8b\u4ef6\u65b9\u6cd5\u6267\u884c\u5931\u8d25!", (Throwable)e);
            }
            return ListeningStatus.LISTENING;
        });
    }

    private static boolean isPermission(long bot, long group, long id, PermissionMatchingEnum matching, String[] permissions) {
        if (AuthorizeConfig.INSTANCE.getOwner() == id || PermissionManager.checkPermission(bot, group, id, "admin") || PermissionManager.checkPermission(bot, group, id, "all")) {
            return false;
        }
        if (matching == PermissionMatchingEnum.AND) {
            boolean success = true;
            for (String permission : permissions) {
                success = success && PermissionManager.checkPermission(bot, group, id, permission);
            }
            return !success;
        }
        for (String permission : permissions) {
            if (!PermissionManager.checkPermission(bot, group, id, permission)) continue;
            return false;
        }
        return true;
    }

    private Set<Class<?>> reflectiveScan(ClassLoader classLoader, ClassScanner classScanner, String packagePath) {
        Class<ClassScanner> classScannerClass = ClassScanner.class;
        Enumeration<URL> resources = classLoader.getResources(packagePath);
        EnumerationIter enumerationIter = new EnumerationIter(resources);
        for (URL url : enumerationIter) {
            try {
                Method scanJar = classScannerClass.getDeclaredMethod("scanJar", JarFile.class);
                scanJar.setAccessible(true);
                scanJar.invoke((Object)classScanner, URLUtil.getJarFile((URL)url));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Field classes = classScannerClass.getDeclaredField("classes");
        classes.setAccessible(true);
        return (Set)classes.get(classScanner);
    }
}

