/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.service;

import cn.cenxt.task.constants.Constants;
import cn.cenxt.task.enums.ExecResultEnum;
import cn.cenxt.task.enums.TaskStatusEnum;
import cn.cenxt.task.mapper.ExecHistoryMapper;
import cn.cenxt.task.mapper.TaskRowMapper;
import cn.cenxt.task.model.ExecHistory;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.utils.CronAnalysisUtil;
import cn.cenxt.task.utils.IpUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class CenxtTaskService {
    private static final Logger logger = LoggerFactory.getLogger(CenxtTaskService.class);
    private JdbcTemplate jdbcTemplate;

    public CenxtTaskService() {
    }

    public CenxtTaskService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void initTable() {
        if (!this.checkTableExist(Constants.TABLE_NAME_TASK)) {
            logger.info("begin init table");
            logger.info(Constants.SQL_CREATE_TASK_TABLE());
            this.jdbcTemplate.update(Constants.SQL_CREATE_TASK_TABLE());
            logger.info("success init table");
        }
        if (!this.checkTableExist(Constants.TABLE_NAME_EXEC_HISTORY)) {
            logger.info("begin init table");
            logger.info(Constants.SQL_CREATE_EXEC_HISTORY_TABLE());
            this.jdbcTemplate.update(Constants.SQL_CREATE_EXEC_HISTORY_TABLE());
            logger.info("success init table");
        }
    }

    public boolean checkTableExist(String tableName) {
        try {
            this.jdbcTemplate.update("SHOW CREATE TABLE " + tableName);
            logger.info("table " + tableName + " is exist");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<Task> getWaitExecTask(int size) {
        String ip = IpUtil.getLocalIp();
        Object[] params = new Object[]{ip, ip, size};
        return this.jdbcTemplate.query(Constants.SQL_QUERY_WAITE_EXEC_TASK_LIST(), params, (RowMapper)new TaskRowMapper());
    }

    public boolean lockTask(Task task) {
        return this.jdbcTemplate.update(Constants.SQL_QUERY_LOCK_TASK(), new Object[]{IpUtil.getLocalIp(), task.getId(), task.getExecTime()}) > 0;
    }

    public void releaseTask(Task task, TaskStatusEnum taskStatusEnum) {
        try {
            this.jdbcTemplate.update(Constants.SQL_RELEASE_TASK(), new Object[]{taskStatusEnum.getStatus(), CronAnalysisUtil.getNextTime(task.getCronStr(), task.getExecTime()), task.getId()});
        }
        catch (Exception e) {
            logger.error("releaseTask error", (Throwable)e);
        }
    }

    public void failAndDisableTask(int id) {
        try {
            this.jdbcTemplate.update(Constants.SQL_FAIL_AND_RELEASE_TASK(), new Object[]{id});
        }
        catch (Exception e) {
            logger.error("failAndDisableTask error", (Throwable)e);
        }
    }

    public void saveExecHistory(Task task, Date finishTime, ExecResultEnum execResult, String message) {
        try {
            long cost = finishTime == null ? 0L : finishTime.getTime() - task.getExecTime().getTime();
            ExecHistory history = this.getExecHistory(task.getExecId());
            if (history == null) {
                this.jdbcTemplate.update(Constants.SQL_INSERT_EXEC_HISTORY(), new Object[]{task.getId(), task.getExecId(), IpUtil.getLocalIp(), task.getExecTime(), finishTime, cost, execResult.getResult(), 0, 0, 0, message});
            } else {
                this.jdbcTemplate.update(Constants.SQL_UPDATE_EXEC_HISTORY(), new Object[]{finishTime, cost, execResult.getResult(), 0, 0, 0, message, task.getExecId()});
            }
        }
        catch (Exception e) {
            logger.error("saveExecHistory error", (Throwable)e);
        }
    }

    public void saveExecHistory(Task task, Date finishTime, ExecHistory execHistory) {
        if (execHistory.getExecMessage().length() > 10000) {
            execHistory.setExecMessage(execHistory.getExecMessage().substring(0, 10000));
        }
        try {
            ExecHistory history = this.getExecHistory(task.getExecId());
            if (history == null) {
                this.jdbcTemplate.update(Constants.SQL_INSERT_EXEC_HISTORY(), new Object[]{task.getId(), task.getExecId(), IpUtil.getLocalIp(), task.getExecTime(), finishTime, execHistory.getCost(), execHistory.getExecResult(), execHistory.getRetryTimes(), execHistory.getExecReport().getSuccessCount(), execHistory.getExecReport().getFailCount(), execHistory.getExecMessage()});
            } else {
                this.jdbcTemplate.update(Constants.SQL_UPDATE_EXEC_HISTORY(), new Object[]{finishTime, execHistory.getCost(), execHistory.getExecResult(), execHistory.getRetryTimes(), execHistory.getExecReport().getSuccessCount(), execHistory.getExecReport().getFailCount(), execHistory.getExecMessage(), task.getExecId()});
            }
        }
        catch (Exception e) {
            logger.error("saveExecHistory error", (Throwable)e);
        }
    }

    public Date getNowTime() {
        try {
            return (Date)this.jdbcTemplate.queryForObject("SELECT NOW()", (RowMapper)new RowMapper<Date>(){

                public Date mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getTimestamp(1);
                }
            });
        }
        catch (Exception e) {
            logger.error("getNowTime error", (Throwable)e);
            return new Date();
        }
    }

    public List<Task> getAllTasks() {
        return this.jdbcTemplate.query(Constants.SQL_QUERY_ALL_TASK_LIST(), (RowMapper)new TaskRowMapper());
    }

    public List<Task> getAllTasksByUser(String username) {
        Object[] params = new Object[]{username};
        return this.jdbcTemplate.query(Constants.SQL_QUERY_ALL_TASK_LIST_BY_USER(), params, (RowMapper)new TaskRowMapper());
    }

    public List<ExecHistory> getExecHistory(int taskId, int size) {
        Object[] params = new Object[]{taskId, size};
        return this.jdbcTemplate.query(Constants.SQL_QUERY_EXEC_HISTORY_LIST(), params, (RowMapper)new ExecHistoryMapper());
    }

    public ExecHistory getExecHistory(String execId) {
        Object[] params = new Object[]{execId};
        List execHistories = this.jdbcTemplate.query(Constants.SQL_QUERY_EXEC_HISTORY_BY_EXEC_ID(), params, (RowMapper)new ExecHistoryMapper());
        if (execHistories == null || execHistories.isEmpty()) {
            return null;
        }
        return (ExecHistory)execHistories.get(0);
    }

    public List<ExecHistory> getErrorExecHistory(int taskId, int size) {
        Object[] params = new Object[]{taskId, size};
        return this.jdbcTemplate.query(Constants.SQL_QUERY_ERROR_EXEC_HISTORY_LIST(), params, (RowMapper)new ExecHistoryMapper());
    }

    public int deleteExecHistory(Date date, int size) {
        return this.jdbcTemplate.update(Constants.SQL_DELETE_EXEC_HISTORY(), new Object[]{date, size});
    }

    public void saveTask(Task task, String username) {
        if (task.getId() > 0) {
            this.jdbcTemplate.update(Constants.SQL_UPDATE_TASK(), new Object[]{task.getName(), task.getDescription(), task.getCronStr(), task.getExpire(), task.getRetryTimes(), task.getParams(), task.getNextTime(), username, task.getId()});
        } else {
            this.jdbcTemplate.update(Constants.SQL_INSERT_TASK(), new Object[]{task.getName(), task.getDescription(), task.getCronStr(), task.getExpire(), task.getRetryTimes(), task.getParams(), task.getNextTime(), username});
        }
    }

    public void enableTask(int id, boolean enabled, String username) {
        this.jdbcTemplate.update(Constants.SQL_UPDATE_TASK_ENABLE(), new Object[]{enabled ? 1 : 0, username, id});
    }

    public void deleteTask(int id) {
        this.jdbcTemplate.update(Constants.SQL_DELETE_TASK(), new Object[]{id});
    }
}

