/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.scheduler;

import cn.cenxt.task.enums.ExecResultEnum;
import cn.cenxt.task.jobs.CenxtJob;
import cn.cenxt.task.listeners.CenxtTaskListener;
import cn.cenxt.task.model.ExecHistory;
import cn.cenxt.task.model.Task;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExecCallable
implements Callable<ExecHistory> {
    private final Logger logger;
    private Task task;
    private CenxtJob job;
    private CenxtTaskListener listener;
    private ExecHistory execHistory;

    public ExecCallable(Task task, CenxtJob job, CenxtTaskListener listener, ExecHistory execHistory) {
        this.logger = LoggerFactory.getLogger((String)task.getName());
        this.task = task;
        this.job = job;
        this.listener = listener;
        this.execHistory = execHistory;
    }

    @Override
    public ExecHistory call() throws Exception {
        this.logger.info("task begin ,execId:{}", (Object)this.task.getExecId());
        long start = System.currentTimeMillis();
        int i = 0;
        boolean result = true;
        StringBuilder message = new StringBuilder();
        try {
            this.listener.begin(this.task);
        }
        catch (Exception e) {
            this.logger.warn("listener begin error", (Throwable)e);
        }
        int retryTimes = Math.max(this.task.getRetryTimes(), 0);
        while (i <= retryTimes) {
            block22: {
                long step = System.currentTimeMillis();
                this.execHistory.getExecReport().setMessage("");
                this.execHistory.getExecReport().setSuccessCount(0L);
                this.execHistory.getExecReport().setSuccessCount(0L);
                if (i > 0) {
                    this.execHistory.setRetryTimes(i);
                    this.execHistory.setExecResult(ExecResultEnum.RETRYING.getResult());
                    this.logger.info("task retry ,execId:{},retryTimes:{}", (Object)this.task.getExecId(), (Object)i);
                    try {
                        this.listener.retry(this.task, this.execHistory.getRetryTimes());
                    }
                    catch (Exception e) {
                        this.logger.warn("listener retry error", (Throwable)e);
                    }
                }
                try {
                    this.job.pre(this.task);
                    result = this.job.exec(this.task, this.execHistory.getExecReport());
                    if (!StringUtils.isEmpty((Object)this.execHistory.getExecReport().getMessage())) {
                        message.append(this.execHistory.getExecReport().getMessage()).append("\n");
                    }
                    this.execHistory.setExecMessage(message.toString());
                }
                catch (InterruptedException ex) {
                    this.logger.error("task interrupted ,execId:{}", (Object)this.task.getExecId());
                    try {
                        this.listener.fail(this.task, System.currentTimeMillis() - step, i + 1, ex);
                        this.listener.exceptionFinish(this.task, System.currentTimeMillis() - step, this.execHistory.getRetryTimes());
                    }
                    catch (Exception e) {
                        this.logger.warn("listener fail error", (Throwable)e);
                    }
                    this.execHistory.setCost(System.currentTimeMillis() - start);
                    this.execHistory.setExecResult(ExecResultEnum.INTERRUPTED.getResult());
                    return this.execHistory;
                }
                catch (Exception ex) {
                    this.logger.error("task exec error, execId:{}", (Object)this.task.getExecId(), (Object)ex);
                    message.append("\u3010\u9519\u8bef\u3011").append(ex.getMessage()).append("\n");
                    this.execHistory.setExecMessage(message.toString());
                    this.execHistory.setCost(System.currentTimeMillis() - start);
                    this.execHistory.setExecResult(ExecResultEnum.FAIL.getResult());
                    try {
                        this.listener.fail(this.task, System.currentTimeMillis() - step, i + 1, ex);
                    }
                    catch (Exception e) {
                        this.logger.warn("listener fail error", (Throwable)e);
                    }
                    break block22;
                }
                if (result) {
                    if (this.execHistory.getRetryTimes() > 0) {
                        this.execHistory.setExecResult(ExecResultEnum.RETRY_SUCCESS.getResult());
                        break;
                    }
                    this.execHistory.setExecResult(ExecResultEnum.SUCCESS.getResult());
                    break;
                }
                this.execHistory.setExecResult(ExecResultEnum.FAIL.getResult());
                message.append("\u3010").append(i).append("\u3011").append("\u6267\u884c\u8fd4\u56de\u5931\u8d25").append("\n");
                this.execHistory.setExecMessage(message.toString());
                try {
                    this.listener.fail(this.task, System.currentTimeMillis() - step, i + 1, null);
                }
                catch (Exception e) {
                    this.logger.warn("listener fail error", (Throwable)e);
                }
            }
            ++i;
        }
        long cost = System.currentTimeMillis() - start;
        this.execHistory.setCost(cost);
        this.logger.info("task finished ,execId:{},execResult:{}", (Object)this.task.getExecId(), (Object)this.execHistory.getExecResult());
        try {
            if (result) {
                this.listener.finish(this.task, cost, this.execHistory.getRetryTimes());
            } else {
                this.listener.exceptionFinish(this.task, cost, this.execHistory.getRetryTimes());
            }
        }
        catch (Exception e) {
            this.logger.warn("listener finish error", (Throwable)e);
        }
        return this.execHistory;
    }
}

