/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.scheduler;

import cn.cenxt.task.constants.Constants;
import cn.cenxt.task.enums.ExecResultEnum;
import cn.cenxt.task.enums.TaskStatusEnum;
import cn.cenxt.task.jobs.CenxtJob;
import cn.cenxt.task.listeners.CenxtTaskListener;
import cn.cenxt.task.model.Task;
import cn.cenxt.task.properties.CenxtTaskProperties;
import cn.cenxt.task.scheduler.ExecWrapper;
import cn.cenxt.task.service.CenxtTaskService;
import cn.cenxt.task.utils.CronAnalysisUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class CenxtTaskScheduler
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(CenxtTaskScheduler.class);
    private static ThreadPoolExecutor executor;
    @Autowired
    private CenxtTaskProperties taskProperties;
    @Autowired
    private CenxtTaskService cenxtTaskService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CenxtTaskListener cenxtTaskListener;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        String tableNamePrefix = this.taskProperties.getTableNamePrefix();
        if (!StringUtils.isEmpty((Object)tableNamePrefix)) {
            if (!Constants.TABLE_NAME_TASK.startsWith(tableNamePrefix = tableNamePrefix.trim())) {
                Constants.TABLE_NAME_TASK = tableNamePrefix + Constants.TABLE_NAME_TASK;
            }
            if (!Constants.TABLE_NAME_EXEC_HISTORY.startsWith(tableNamePrefix)) {
                Constants.TABLE_NAME_EXEC_HISTORY = tableNamePrefix + Constants.TABLE_NAME_EXEC_HISTORY;
            }
        }
        if (this.taskProperties.isInitTable()) {
            try {
                this.cenxtTaskService.initTable();
            }
            catch (Exception e) {
                logger.error("initTable error", (Throwable)e);
                System.exit(1);
                return;
            }
        }
        final int interval = Math.max(this.taskProperties.getScanInterval(), 500);
        final int[] fetchSize = new int[]{Math.max(this.taskProperties.getFetchSize(), 3)};
        int poolSize = Math.max(this.taskProperties.getThread(), 3);
        executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(poolSize);
        logger.info("success create executor with size {}", (Object)poolSize);
        new Thread(CenxtTaskScheduler.class.getSimpleName()){

            @Override
            public void run() {
                block7: while (true) {
                    try {
                        Thread.sleep(interval);
                    }
                    catch (Exception e) {
                        logger.warn("CenxtTaskScheduler sleep error", (Throwable)e);
                    }
                    try {
                        int size = Math.min(fetchSize[0], executor.getCorePoolSize() - executor.getActiveCount());
                        logger.debug("now available pool size:{}", (Object)size);
                        CenxtTaskScheduler.this.printPool(executor);
                        if (size < 1) continue;
                        List<Task> waitExecTask = CenxtTaskScheduler.this.cenxtTaskService.getWaitExecTask(size);
                        logger.debug("get tasks size:{}", (Object)waitExecTask.size());
                        Iterator<Task> iterator = waitExecTask.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block7;
                            Task task = iterator.next();
                            try {
                                CenxtJob job = (CenxtJob)CenxtTaskScheduler.this.applicationContext.getBean(task.getName(), CenxtJob.class);
                                if (CronAnalysisUtil.getNextTime(task.getCronStr(), new Date()) == null) continue;
                                logger.debug("try to lock task:{}", (Object)task);
                                if (!CenxtTaskScheduler.this.cenxtTaskService.lockTask(task)) {
                                    logger.debug("fail to lock task:{}", (Object)task);
                                    continue;
                                }
                                task.setExecId(UUID.randomUUID().toString());
                                logger.info("success lock task:{}", (Object)task);
                                task.setExecTime(CenxtTaskScheduler.this.cenxtTaskService.getNowTime());
                                ExecWrapper execWrapper = new ExecWrapper(task, job, CenxtTaskScheduler.this.cenxtTaskListener, CenxtTaskScheduler.this.cenxtTaskService);
                                CenxtTaskScheduler.this.cenxtTaskService.saveExecHistory(task, null, ExecResultEnum.WAITING, null);
                                executor.execute(execWrapper);
                                logger.info("task submit ,execId:{}", (Object)task.getExecId());
                            }
                            catch (BeansException e) {
                                logger.warn("not found task. task:{}", (Object)task.getName());
                                CenxtTaskScheduler.this.cenxtTaskService.saveExecHistory(task, CenxtTaskScheduler.this.cenxtTaskService.getNowTime(), ExecResultEnum.FAIL, "not found task");
                                CenxtTaskScheduler.this.cenxtTaskService.failAndDisableTask(task.getId());
                            }
                            catch (RejectedExecutionException e) {
                                logger.error("CenxtTaskScheduler exec error,task:{},execId:{}", new Object[]{task.getName(), task.getExecId(), e});
                                CenxtTaskScheduler.this.cenxtTaskService.saveExecHistory(task, CenxtTaskScheduler.this.cenxtTaskService.getNowTime(), ExecResultEnum.FAIL, "pool reject");
                                CenxtTaskScheduler.this.cenxtTaskService.releaseTask(task, TaskStatusEnum.FAIL);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("CenxtTaskScheduler Error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private void printPool(ThreadPoolExecutor executor) {
        logger.debug(" ActiveCount: {} poolSize:{} queueSize:{} taskCount:{}", new Object[]{executor.getActiveCount(), executor.getPoolSize(), executor.getQueue().size(), executor.getTaskCount()});
    }
}

