/*
 * Decompiled with CFR 0.152.
 */
package cn.cenxt.task.listeners;

import cn.cenxt.task.listeners.CenxtTaskListener;
import cn.cenxt.task.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskListener
implements CenxtTaskListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTaskListener.class);

    @Override
    public void begin(Task task) {
        logger.info("task begin. name:{},execId:{}", (Object)task.getName(), (Object)task.getExecId());
    }

    @Override
    public void finish(Task task, long cost, int retryTimes) {
        if (retryTimes == 0) {
            logger.info("task finished. name:{},execId:{},cost:{}ms", new Object[]{task.getName(), task.getExecId(), cost});
        } else {
            logger.info("task finished after {} times retry. name:{},execId:{},cost:{}ms", new Object[]{retryTimes, task.getName(), task.getExecId(), cost});
        }
    }

    @Override
    public void exceptionFinish(Task task, long cost, int retryTimes) {
        logger.error("task exception finish after {} times retry. name:{},execId:{},cost:{}ms", new Object[]{retryTimes, task.getName(), task.getExecId(), cost});
    }

    @Override
    public void fail(Task task, long cost, int times, Exception e) {
        logger.error("task exec fail. name:{},execId:{},cost:{}ms", new Object[]{task.getName(), task.getExecId(), cost});
    }

    @Override
    public void retry(Task task, int retryTimes) {
        logger.warn("task exec fail will retry. name:{},execId:{},retryTimes:{}", new Object[]{task.getName(), task.getExecId(), retryTimes});
    }
}

